/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classpath;

import java.io.IOException;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.FullReadLines;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.text.CharArrayStringBuffer;

public class LoadLibraryExtensionPointsFile
extends FullReadLines<Void> {
    private ClassLoader classLoader;

    public <T extends ClassLoader> LoadLibraryExtensionPointsFile(BufferedReadableCharacterStream stream, T classLoader) {
        super("Initializing extension points: " + stream.getDescription(), stream, (byte)2, null);
        this.classLoader = classLoader;
    }

    @Override
    protected void processLine(CharArrayStringBuffer line) throws IOException {
        block5: {
            if (line.isEmpty()) {
                return;
            }
            try {
                Class<?> cl = Class.forName(line.asString(), true, this.classLoader);
                if (ExtensionPoint.class.isAssignableFrom(cl)) {
                    ExtensionPoint ext = (ExtensionPoint)cl.newInstance();
                    ExtensionPoints.add(ext);
                    ((ApplicationClassLoader)((Object)this.classLoader)).getApplication().getDefaultLogger().info("Extension point: " + cl.getName());
                    break block5;
                }
                if (CustomExtensionPoint.class.isAssignableFrom(cl)) {
                    CustomExtensionPoint ext = (CustomExtensionPoint)cl.newInstance();
                    ExtensionPoints.add(ext);
                    break block5;
                }
                throw new IOException("Invalid extension point class: " + line + " must extend ExtensionPoint or CustomExtensionPoint");
            }
            catch (Exception e) {
                throw IO.error(e);
            }
        }
    }

    @Override
    protected Void generateResult() {
        return null;
    }
}

