/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.io.Closeable;
import java.io.PrintStream;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;

public class Console
implements Closeable {
    private TurnArray<Object> stdout = new TurnArray(100);
    private TurnArray<Object> stderr = new TurnArray(50);
    private Thread thread;
    private boolean stop = false;
    private Async<Exception> stopped = new Async();
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public synchronized void out(String line) {
        this.stdout.addLast(line);
        this.notify();
    }

    public synchronized void out(Throwable t) {
        this.stdout.addLast(t);
        this.notify();
    }

    public synchronized void err(String line) {
        this.stderr.addLast(line);
        this.notify();
    }

    public synchronized void err(Throwable t) {
        this.stderr.addLast(t);
        this.notify();
    }

    public Console(Application app) {
        this.thread = app.getThreadFactory().newThread(() -> {
            while (!this.stop) {
                Object errObj;
                Object outObj = null;
                Console console = this;
                synchronized (console) {
                    errObj = this.stderr.pollFirst();
                    if (errObj == null && (outObj = this.stdout.pollFirst()) == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                if (errObj != null) {
                    Console.printTo(errObj, this.err);
                    continue;
                }
                Console.printTo(outObj, this.out);
            }
            while (!this.stderr.isEmpty()) {
                this.err.println(this.stderr.removeFirst());
            }
            while (!this.stdout.isEmpty()) {
                this.out.println(this.stdout.removeFirst());
            }
            System.out.println("Console stopped for " + app.getGroupId() + '/' + app.getArtifactId());
            this.stopped.unblock();
        });
        this.thread.setName("Console for " + app.getGroupId() + "." + app.getArtifactId() + " " + app.getVersion().toString());
        this.thread.start();
    }

    private static void printTo(Object toPrint, PrintStream stream) {
        if (toPrint instanceof CharSequence) {
            stream.println(toPrint);
        } else if (toPrint instanceof Throwable) {
            ((Throwable)toPrint).printStackTrace(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stop = true;
        Console console = this;
        synchronized (console) {
            this.notify();
        }
        this.stopped.block(0L);
    }
}

