/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.TaskWorker;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.DebugUtil;

public abstract class FixedThreadTaskManager
extends TaskManager {
    private int nbThreads;
    private TurnArray<TaskWorker> spare;
    private TurnArray<TaskWorker> blocked;
    private LinkedList<TaskWorker> aside = new LinkedList();
    private LinkedList<AsyncSupplier<TaskWorker, NoException>> pausesToDo = new LinkedList();

    public FixedThreadTaskManager(String name, Object resource, int nbThreads, ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager) {
        super(name, resource, threadFactory, taskPriorityManager);
        this.nbThreads = nbThreads;
        this.spare = new TurnArray(nbThreads * 2);
        this.blocked = new TurnArray(nbThreads);
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    @Override
    void started() {
        new CloseOldSpare().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void finishAndStopThreads() {
        AsyncSupplier<TaskWorker, NoException> waitPause;
        this.finishAndStopWorkers();
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            while (!this.spare.isEmpty()) {
                this.spare.removeFirst().forceStop(true);
            }
        }
        while ((waitPause = this.getPauseToDo()) != null) {
            waitPause.unblockSuccess(null);
        }
    }

    protected abstract void finishAndStopWorkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceStopThreads() {
        this.forceStopWorkers();
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            while (!this.spare.isEmpty()) {
                this.spare.removeFirst().forceStop(true);
            }
        }
    }

    protected abstract void forceStopWorkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTransfer() {
        TurnArray<TaskWorker> turnArray = this.blocked;
        synchronized (turnArray) {
            for (TaskWorker w : this.blocked) {
                Threading.logger.error("  - Remaining blocked thread: " + w.thread.getName());
            }
        }
    }

    Thread newThread(TaskWorker worker) {
        Thread t = this.threadFactory.newThread(worker);
        t.setUncaughtExceptionHandler(new UncaughtExceptionHandler(worker));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final Task<?, ?> peekNextOrWait() {
        block12: {
            Task<?, ?> task;
            try {
                TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
                // MONITORENTER : taskPriorityManager
                if (this.pausesToDo.isEmpty()) break block12;
                task = null;
                // MONITOREXIT : taskPriorityManager
                if (this.stopping == null) return task;
                Object object = this.stopping;
            }
            catch (Throwable throwable) {
                if (this.stopping == null) throw throwable;
                Object object = this.stopping;
                // MONITORENTER : object
                this.stopping.notify();
                // MONITOREXIT : object
                throw throwable;
            }
            this.stopping.notify();
            // MONITOREXIT : object
            return task;
        }
        Task<?, ?> task = this.taskPriorityManager.peekNextOrWait();
        // MONITOREXIT : taskPriorityManager
        if (this.stopping == null) return task;
        Object object = this.stopping;
        // MONITORENTER : object
        this.stopping.notify();
        // MONITOREXIT : object
        return task;
    }

    protected abstract TaskWorker createWorker();

    protected abstract void replaceWorkerBySpare(TaskWorker var1, TaskWorker var2);

    protected abstract TaskWorker[] getWorkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSpare(TaskWorker worker) {
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            this.spare.addLast(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncSupplier<TaskWorker, NoException> getPauseToDo() {
        if (this.pausesToDo.isEmpty()) {
            return null;
        }
        LinkedList<AsyncSupplier<TaskWorker, NoException>> linkedList = this.pausesToDo;
        synchronized (linkedList) {
            if (this.pausesToDo.isEmpty()) {
                return null;
            }
            return this.pausesToDo.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceBySpare(TaskWorker worker) {
        TaskWorker w;
        Object object = this.spare;
        synchronized (object) {
            w = this.spare.pollFirst();
        }
        if (w == null) {
            w = this.createWorker();
            this.replaceWorkerBySpare(worker, w);
            w.thread.start();
        } else {
            this.replaceWorkerBySpare(worker, w);
            object = w;
            synchronized (object) {
                w.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imBlocked(TaskWorker worker) {
        worker.blocked = true;
        if (Threading.traceBlockingTasks) {
            Threading.logger.error("Task " + worker.currentTask.description + " blocked", new Exception());
        }
        if (this.transferredTo != null) {
            Threading.logger.info("Task blocked while transferring to a new TaskManager: " + worker.currentTask.description);
            TurnArray<TaskWorker> turnArray = this.blocked;
            synchronized (turnArray) {
                this.blocked.addLast(worker);
            }
            return;
        }
        this.replaceBySpare(worker);
        TurnArray<TaskWorker> turnArray = this.blocked;
        synchronized (turnArray) {
            this.blocked.addLast(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imUnblocked(TaskWorker worker, long since) {
        worker.blocked = false;
        if (Threading.traceBlockingTasks) {
            Threading.logger.error("Task " + worker.currentTask.description + " unblocked after " + (System.nanoTime() - since) / 1000000L + "ms.");
        }
        AsyncSupplier pause = new AsyncSupplier();
        TurnArray<TaskWorker> turnArray = this.taskPriorityManager;
        synchronized (turnArray) {
            LinkedList<AsyncSupplier<TaskWorker, NoException>> linkedList = this.pausesToDo;
            synchronized (linkedList) {
                this.pausesToDo.add(pause);
            }
            this.taskPriorityManager.notify();
        }
        if (!this.stopped) {
            pause.blockPause(30000L);
        }
        if (pause.getResult() != null) {
            this.replaceWorkerBySpare((TaskWorker)pause.getResult(), worker);
            turnArray = this.spare;
            synchronized (turnArray) {
                this.spare.addLast((TaskWorker)pause.getResult());
            }
        }
        turnArray = this.blocked;
        synchronized (turnArray) {
            this.blocked.removeInstance(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TaskWorker> getAllActiveWorkers() {
        TaskWorker[] workers = this.getWorkers();
        ArrayList<TaskWorker> list = new ArrayList<TaskWorker>(workers.length + this.blocked.size() + this.aside.size());
        Collections.addAll(list, workers);
        Deque<TaskWorker> deque = this.blocked;
        synchronized (deque) {
            list.addAll(this.blocked);
        }
        deque = this.aside;
        synchronized (deque) {
            list.addAll(this.aside);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TaskWorker> getBlockedWorkers() {
        TurnArray<TaskWorker> turnArray = this.blocked;
        synchronized (turnArray) {
            return new ArrayList<TaskWorker>(this.blocked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putWorkerAside(TaskWorker worker) {
        if (worker.aside) {
            return;
        }
        TaskWorker newWorker = this.createWorker();
        worker.aside = true;
        LinkedList<TaskWorker> linkedList = this.aside;
        synchronized (linkedList) {
            this.aside.add(worker);
            this.replaceWorkerBySpare(worker, newWorker);
        }
        newWorker.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killWorker(TaskWorker worker) {
        LinkedList<TaskWorker> linkedList = this.aside;
        synchronized (linkedList) {
            if (!this.aside.remove(worker)) {
                return;
            }
        }
        StackTraceElement[] stack = worker.thread.getStackTrace();
        StringBuilder s = new StringBuilder(1024);
        s.append("Task stopped at \r\n");
        DebugUtil.createStackTrace(s, stack);
        Threading.logger.error(s.toString());
        worker.thread.stop();
        if (worker.currentTask != null) {
            worker.currentTask.cancel(new CancelException("Task was running since a too long time"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asideWorkerDone(TaskWorker worker) {
        LinkedList<TaskWorker> linkedList = this.aside;
        synchronized (linkedList) {
            this.aside.remove(worker);
        }
    }

    @Override
    public void debug(StringBuilder s) {
        try {
            s.append("Task Manager: ").append(this.getName()).append(" (").append(this.nbThreads).append(" threads):\r\n");
            for (TaskWorker w : this.getWorkers()) {
                w.debug(s, "Worker");
            }
            for (TaskWorker w : this.spare) {
                try {
                    w.debug(s, "Spare");
                }
                catch (Exception exception) {}
            }
            for (TaskWorker w : this.blocked) {
                try {
                    w.debug(s, "Blocked");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void printStats(StringBuilder s) {
        try {
            s.append("Task Manager: ").append(this.getName()).append(" (").append(this.nbThreads).append(" threads):\r\n");
            for (TaskWorker w : this.getWorkers()) {
                s.append(" - Worker ");
                w.printStats(s);
            }
            for (TaskWorker w : this.spare) {
                s.append(" - Spare ");
                w.printStats(s);
            }
            for (TaskWorker w : this.blocked) {
                s.append(" - Blocked ");
                w.printStats(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CloseOldSpare
    extends Task.Cpu<Void, NoException> {
        private CloseOldSpare() {
            super("Close old spare threads for " + FixedThreadTaskManager.this.getName(), (byte)7);
            this.executeEvery(60000L, 360000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            TurnArray turnArray = FixedThreadTaskManager.this.spare;
            synchronized (turnArray) {
                if (FixedThreadTaskManager.this.spare.size() <= FixedThreadTaskManager.this.nbThreads) {
                    return null;
                }
                for (TaskWorker t : FixedThreadTaskManager.this.spare) {
                    if (t.lastUsed <= 300000L) continue;
                    Threading.logger.info("Spare thread not used since more than 5 minutes => stop it");
                    t.forceStop(true);
                    FixedThreadTaskManager.this.spare.removeInstance(t);
                    return null;
                }
            }
            return null;
        }
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private TaskWorker worker;

        public UncaughtExceptionHandler(TaskWorker worker) {
            this.worker = worker;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.worker.currentTask != null && !this.worker.currentTask.isDone()) {
                CancelException reason;
                this.worker.currentTask.cancelling = reason = new CancelException("Unexpected error in thread " + t.getName(), e);
                this.worker.currentTask.result.cancelled(reason);
            }
            FixedThreadTaskManager.this.replaceBySpare(this.worker);
            LCCore.getApplication().getDefaultLogger().error("Error in TaskWorker " + t.getName(), e);
        }
    }
}

