/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskScheduler;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Runnables;

public abstract class Task<T, TError extends Exception> {
    public static final byte PRIORITY_TOP = 0;
    public static final byte PRIORITY_URGENT = 1;
    public static final byte PRIORITY_IMPORTANT = 2;
    public static final byte PRIORITY_RATHER_IMPORTANT = 3;
    public static final byte PRIORITY_NORMAL = 4;
    public static final byte PRIORITY_RATHER_LOW = 5;
    public static final byte PRIORITY_LOW = 6;
    public static final byte PRIORITY_BACKGROUND = 7;
    public static final byte NB_PRIORITES = 8;
    public static final byte STATUS_NOT_STARTED = 0;
    public static final byte STATUS_STARTED_WAITING = 1;
    public static final byte STATUS_STARTED_READY = 2;
    public static final byte STATUS_RUNNING = 3;
    public static final byte STATUS_BLOCKED = 4;
    public static final byte STATUS_EXECUTED = 5;
    public static final byte STATUS_DONE = 6;
    Application app;
    TaskManager manager;
    byte status;
    Output result = new Output();
    CancelException cancelling = null;
    Consumer<Pair<T, TError>> ondone = null;
    String description;
    byte priority;
    long executeEvery;
    long nextExecution;
    private List<IAsync<?>> holdSP = null;
    protected JoinPoint<TError> taskJoin = null;

    public Task(TaskManager manager, String description, byte priority) {
        this(manager, description, priority, null);
    }

    public Task(TaskManager manager, String description, byte priority, Consumer<Pair<T, TError>> ondone) {
        if (manager == null) {
            throw new IllegalArgumentException("TaskManager must not be null");
        }
        this.app = LCCore.getApplication();
        this.manager = manager;
        this.description = description;
        this.priority = priority;
        this.ondone = ondone;
        this.result.onDone(() -> {
            if (this.app.isDebugMode() && Threading.traceTaskDone) {
                Threading.logger.info("Task done: " + description);
            }
            if (this.result.isCancelled() && this.status < 3) {
                Logger logger = this.app.getLoggerFactory().getLogger("Threading");
                if (logger.debug()) {
                    CancelException reason = this.result.getCancelEvent();
                    logger.debug("Task cancelled: " + description + " => " + (reason != null ? reason.getMessage() : "No reason given"));
                }
                this.cancel(this.result.getCancelEvent());
            }
            this.status = (byte)6;
        });
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.newTask(this);
        }
    }

    public Task(Object resource, String description, byte priority, Consumer<Pair<T, TError>> ondone) {
        this(Threading.get(resource), description, priority, ondone);
    }

    public Task(Object resource, String description, byte priority) {
        this(Threading.get(resource), description, priority, null);
    }

    public final byte getStatus() {
        return this.status;
    }

    public final String getDescription() {
        return this.description;
    }

    protected final void setDescription(String descr) {
        this.description = descr;
    }

    public final Application getApplication() {
        return this.app;
    }

    public final TaskManager getTaskManager() {
        return this.manager;
    }

    public abstract T run() throws TError, CancelException;

    final void execute() {
        T res;
        if (this.cancelling != null) {
            this.status = (byte)6;
            this.result.cancelled(this.cancelling);
            this.checkSP();
            return;
        }
        try {
            res = this.run();
        }
        catch (CancelException e) {
            this.status = (byte)6;
            this.cancelling = e;
            this.result.cancelled(e);
            this.checkSP();
            return;
        }
        catch (Exception t) {
            this.status = (byte)6;
            if (this.cancelling != null) {
                if (!this.result.isCancelled()) {
                    this.result.cancelled(this.cancelling);
                }
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().warn("Task " + this.description + " error while trying to cancel it: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
                }
            } else if (!this.result.isCancelled()) {
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().error("Task " + this.description + " error: " + t.getMessage(), t);
                }
                try {
                    Exception error = t;
                    if (this.ondone != null) {
                        this.ondone.accept(new Pair<Object, Exception>(null, error));
                    }
                    this.result.unblockError(error);
                }
                catch (ClassCastException e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", t);
                    this.result.cancelled(this.cancelling);
                }
                catch (Exception e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", e);
                    this.result.cancelled(this.cancelling);
                }
            } else if (this.app.isDebugMode()) {
                this.app.getDefaultLogger().warn("Task " + this.description + " error after being cancelled: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
            }
            this.checkSP();
            return;
        }
        if (this.taskJoin == null) {
            this.status = (byte)6;
            try {
                if (this.ondone != null) {
                    this.ondone.accept(new Pair<T, Object>(res, null));
                }
            }
            catch (Exception t) {
                this.app.getDefaultLogger().error("Error while calling ondone on task " + this.description, t);
            }
            this.result.unblockSuccess(res);
            this.checkSP();
            return;
        }
        this.status = (byte)5;
        this.taskJoin.onDone(() -> {
            this.status = (byte)6;
            if (this.taskJoin.isCancelled()) {
                this.cancelling = this.taskJoin.getCancelEvent();
                this.result.cancelled(this.cancelling);
            } else if (this.taskJoin.hasError()) {
                if (this.ondone != null) {
                    this.ondone.accept(new Pair(null, this.taskJoin.getError()));
                }
                this.result.unblockError(this.taskJoin.getError());
            } else {
                if (this.ondone != null) {
                    this.ondone.accept(new Pair<Object, Object>(res, null));
                }
                this.result.unblockSuccess(res);
            }
            this.taskJoin = null;
            this.checkSP();
        });
        if (this.app.isDebugMode()) {
            this.taskJoin.listenTime(30000L, () -> this.app.getDefaultLogger().warn("Task " + this.description + " is done, but still waiting for other works to be done after 30s."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void rescheduleIfNeeded() {
        if (this.executeEvery > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
                this.executeIn(this.executeEvery);
            }
            TaskScheduler.schedule(this);
        } else if (this.nextExecution > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
            }
            TaskScheduler.schedule(this);
        }
    }

    private void checkSP() {
        if (this.holdSP == null) {
            return;
        }
        for (IAsync<?> sp : this.holdSP) {
            if (sp.isDone()) continue;
            sp.cancel(new CancelException("Task " + this.description + " done without unblock this synchronization point"));
        }
        this.holdSP = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task<T, TError> start() {
        if (this instanceof Done) {
            return this;
        }
        if (this.cancelling != null) {
            this.result.cancelled(this.cancelling);
        }
        Task task = this;
        synchronized (task) {
            long now;
            if (this.result.isCancelled()) {
                return this;
            }
            if (this.status != 0) {
                if (this.status >= 6) {
                    throw new RuntimeException("Task already done: " + this.description + " with " + (this.result.getError() != null ? "error " + ((Throwable)this.result.getError()).getMessage() : "success"));
                }
                throw new RuntimeException("Task already started (" + this.status + "): " + this.description);
            }
            if (this.nextExecution > 0L && this.nextExecution > (now = System.currentTimeMillis())) {
                TaskScheduler.schedule(this);
                return this;
            }
            this.sendToTaskManager();
            return this;
        }
    }

    final void sendToTaskManager() {
        while (this.manager.getTransferTarget() != null) {
            this.manager = this.manager.getTransferTarget();
        }
        this.status = (byte)2;
        this.manager.addReady(this);
    }

    public final void cancel(CancelException reason) {
        if (this.cancelling != null) {
            return;
        }
        if (reason == null) {
            reason = new CancelException("No reason given");
        }
        this.cancelling = reason;
        if (TaskScheduler.cancel(this) || this.manager.remove(this) || this.status == 0) {
            this.status = (byte)6;
            this.result.cancelled(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean cancelIfExecutionNotStarted(CancelException reason) {
        Task task = this;
        synchronized (task) {
            if (this.status < 3) {
                this.cancel(reason);
                return true;
            }
        }
        return false;
    }

    public final void setError(TError error) {
        this.status = (byte)6;
        this.result.unblockError(error);
    }

    public final boolean isDone() {
        return this.status == 6 && this.result.isDone();
    }

    public final boolean isSuccessful() {
        return this.status == 6 && this.result.isSuccessful();
    }

    public final boolean isCancelling() {
        return this.cancelling != null || this.result.isCancelled();
    }

    public final boolean isCancelled() {
        return this.result.isCancelled();
    }

    public final boolean isStarted() {
        return this.status > 0;
    }

    public final boolean isRunning() {
        return this.status >= 3 && this.status < 6;
    }

    public final T getResult() {
        return this.result.getResult();
    }

    public final TError getError() {
        return this.result.getError();
    }

    public final CancelException getCancelEvent() {
        return this.cancelling != null ? this.cancelling : this.result.getCancelEvent();
    }

    public final boolean hasError() {
        return this.result.hasError();
    }

    public final byte getPriority() {
        return this.priority;
    }

    public final synchronized void setPriority(byte priority) {
        if (this.priority == priority) {
            return;
        }
        if (this.status == 2 && this.manager.remove(this)) {
            this.priority = priority;
            while (this.manager.getTransferTarget() != null) {
                this.manager = this.manager.getTransferTarget();
            }
            this.manager.addReady(this);
            return;
        }
        this.priority = priority;
    }

    public final Output getOutput() {
        return this.result;
    }

    public final Task<T, TError> ensureUnblocked(IAsync<?> ... sp) {
        if (this.status == 6) {
            for (int i = 0; i < sp.length; ++i) {
                if (sp[i].isDone()) continue;
                sp[i].cancel(new CancelException("Task " + this.description + " done without unblock this synchronization point"));
            }
            return this;
        }
        if (this.holdSP == null) {
            this.holdSP = new ArrayList(sp.length + 2);
        }
        Collections.addAll(this.holdSP, sp);
        return this;
    }

    public final Task<T, TError> executeAt(long time) {
        this.nextExecution = time;
        return this;
    }

    public final Task<T, TError> executeIn(long delay) {
        return this.executeAt(System.currentTimeMillis() + delay);
    }

    public final Task<T, TError> executeEvery(long delay, long initialDelay) {
        this.executeEvery = delay;
        return this.executeIn(initialDelay);
    }

    public final void stopRepeat() {
        this.executeEvery = 0L;
    }

    public final Task<T, TError> executeAgainIn(long delay) {
        return this.executeAgainAt(System.currentTimeMillis() + delay);
    }

    public final Task<T, TError> executeAgainAt(long time) {
        return this.executeAt(time);
    }

    public final synchronized void changeNextExecutionTime(long time) {
        if (this.status == 1) {
            TaskScheduler.changeNextExecutionTime(this, time);
        } else {
            this.nextExecution = time;
        }
    }

    public final synchronized void executeNextOccurenceNow() {
        long now = System.currentTimeMillis();
        if (this.nextExecution > now) {
            this.changeNextExecutionTime(System.currentTimeMillis());
        }
    }

    public final synchronized void executeNextOccurenceNow(byte priority) {
        this.setPriority(priority);
        this.executeNextOccurenceNow();
    }

    public final void startOn(IAsync<? extends Exception> sp, boolean evenOnErrorOrCancel) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(this, sp);
        }
        sp.onDone(() -> {
            if (evenOnErrorOrCancel) {
                this.start();
                return;
            }
            if (sp.isCancelled()) {
                this.cancel(sp.getCancelEvent());
            } else if (sp.hasError()) {
                try {
                    Object err = sp.getError();
                    this.status = (byte)6;
                    this.result.unblockError(err);
                }
                catch (ClassCastException e) {
                    this.cancel(new CancelException("Error while waiting", (Throwable)sp.getError()));
                }
            } else {
                this.start();
            }
        });
    }

    public final void startOn(boolean evenOnErrorOrCancel, IAsync<?> ... list) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(this, list);
        }
        JoinPoint jp = new JoinPoint();
        for (IAsync<?> sp : list) {
            if (sp == null) continue;
            jp.addToJoin(sp);
        }
        jp.start();
        jp.onDone(() -> {
            if (evenOnErrorOrCancel) {
                this.start();
                return;
            }
            if (jp.isCancelled()) {
                this.cancel(jp.getCancelEvent());
            } else if (jp.hasError()) {
                try {
                    Object err = jp.getError();
                    this.status = (byte)6;
                    this.result.unblockError(err);
                }
                catch (ClassCastException e) {
                    this.cancel(new CancelException("Error while waiting", (Throwable)jp.getError()));
                }
            } else {
                this.start();
            }
        });
    }

    public final void startOnDone(Task<?, ?> task) {
        if (task == null || task.isDone()) {
            this.start();
            return;
        }
        this.startOn(task.getOutput(), true);
    }

    public final void setDone(T result, TError error) {
        this.status = (byte)6;
        if (error == null) {
            this.result.unblockSuccess(result);
        } else {
            this.result.unblockError(error);
        }
    }

    public final void ondone(Task<?, ?> todo, boolean evenIfErrorOrCancel) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(todo, this);
        }
        if (this.result.isCancelled()) {
            todo.cancel(this.result.getCancelEvent());
        } else if (this.result.hasError()) {
            todo.cancel(new CancelException((Throwable)this.result.getError()));
        } else if (this.result.isDone()) {
            todo.start();
        } else {
            todo.startOn(this.result, evenIfErrorOrCancel);
        }
    }

    public long getMaxBlockingTimeInNanoBeforeToLog() {
        return 100000000L;
    }

    public final String toString() {
        return super.toString() + "[" + this.description + "]";
    }

    public final class Output
    extends AsyncSupplier<T, TError> {
        private Output() {
        }

        public Task<T, TError> getTask() {
            return Task.this;
        }

        @Override
        public void unblockCancel(CancelException reason) {
            Task.this.cancel(reason);
        }

        void cancelled(CancelException reason) {
            super.unblockCancel(reason);
        }

        public String toString() {
            return "Task synchronization point [" + Task.this.description + "]";
        }
    }

    public static final class Done<T, TError extends Exception>
    extends Task<T, TError> {
        public Done(T result, TError error) {
            super(Threading.getCPUTaskManager(), "", (byte)4, null);
            this.setDone(result, error);
        }

        @Override
        public T run() {
            return null;
        }
    }

    public static abstract class Parameter<TParam, TResult, TError extends Exception>
    extends Task<TResult, TError> {
        private TParam parameter;

        public Parameter(TaskManager tm, String description, byte priority, Consumer<Pair<TResult, TError>> ondone) {
            super(tm, description, priority, ondone);
        }

        public Parameter(TaskManager tm, String description, byte priority) {
            super(tm, description, priority);
        }

        public TParam getParameter() {
            return this.parameter;
        }

        public void setParameter(TParam parameter) {
            this.parameter = parameter;
        }

        public void start(TParam parameter) {
            this.setParameter(parameter);
            this.start();
        }
    }

    public static abstract class Unmanaged<TResult, TError extends Exception>
    extends Task<TResult, TError> {
        public Unmanaged(String description, byte priority) {
            super(Threading.getUnmanagedTaskManager(), description, priority);
        }
    }

    public static abstract class OnFile<T, TError extends Exception>
    extends Task<T, TError> {
        public OnFile(File file, String description, byte priority, Consumer<Pair<T, TError>> ondone) {
            super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority, ondone);
        }

        public OnFile(File file, String description, byte priority) {
            super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority);
        }

        public OnFile(TaskManager manager, String description, byte priority, Consumer<Pair<T, TError>> ondone) {
            super(manager, description, priority, ondone);
        }

        public OnFile(TaskManager manager, String description, byte priority) {
            super(manager, description, priority);
        }

        public static abstract class Parameter<TParam, TResult, TError extends Exception>
        extends net.lecousin.framework.concurrent.Task$Parameter<TParam, TResult, TError> {
            public Parameter(File file, String description, byte priority, Consumer<Pair<TResult, TError>> ondone) {
                super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority, ondone);
            }

            public Parameter(File file, String description, byte priority) {
                super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority);
            }
        }
    }

    public static abstract class Cpu<T, TError extends Exception>
    extends Task<T, TError> {
        public Cpu(String description, byte priority, Consumer<Pair<T, TError>> ondone) {
            super(Threading.getCPUTaskManager(), description, priority, ondone);
        }

        public Cpu(String description, byte priority) {
            super(Threading.getCPUTaskManager(), description, priority);
        }

        public static class FromSupplierThrows<T, TError extends Exception>
        extends Cpu<T, TError> {
            private Runnables.SupplierThrows<T, TError> supplier;

            public FromSupplierThrows(String description, byte priority, Runnables.SupplierThrows<T, TError> supplier) {
                super(description, priority);
                this.supplier = supplier;
            }

            public FromSupplierThrows(String description, byte priority, Consumer<Pair<T, TError>> ondone, Runnables.SupplierThrows<T, TError> supplier) {
                super(description, priority, ondone);
                this.supplier = supplier;
            }

            @Override
            public T run() throws TError {
                return this.supplier.get();
            }
        }

        public static class FromRunnable
        extends Cpu<Void, NoException> {
            private Runnable runnable;

            public FromRunnable(Runnable runnable, String description, byte priority, Consumer<Pair<Void, NoException>> ondone) {
                super(description, priority, ondone);
                this.runnable = runnable;
            }

            public FromRunnable(Runnable runnable, String description, byte priority) {
                super(description, priority);
                this.runnable = runnable;
            }

            public FromRunnable(String description, byte priority, Runnable runnable) {
                super(description, priority);
                this.runnable = runnable;
            }

            @Override
            public Void run() {
                this.runnable.run();
                return null;
            }
        }

        public static abstract class Parameter<TParam, TResult, TError extends Exception>
        extends net.lecousin.framework.concurrent.Task$Parameter<TParam, TResult, TError> {
            public Parameter(String description, byte priority, Consumer<Pair<TResult, TError>> ondone) {
                super(Threading.getCPUTaskManager(), description, priority, ondone);
            }

            public Parameter(String description, byte priority) {
                super(Threading.getCPUTaskManager(), description, priority);
            }

            public static class FromFunctionThrows<TParam, TResult, TError extends Exception>
            extends Parameter<TParam, TResult, TError> {
                private Runnables.FunctionThrows<TParam, TResult, TError> fct;

                public FromFunctionThrows(String description, byte priority, Runnables.FunctionThrows<TParam, TResult, TError> fct) {
                    super(description, priority);
                    this.fct = fct;
                }

                @Override
                public TResult run() throws TError, CancelException {
                    return this.fct.apply(this.getParameter());
                }
            }

            public static class FromConsumerThrows<TParam, TError extends Exception>
            extends Parameter<TParam, Void, TError> {
                private Runnables.ConsumerThrows<TParam, TError> consumer;

                public FromConsumerThrows(String description, byte priority, Runnables.ConsumerThrows<TParam, TError> consumer) {
                    super(description, priority);
                    this.consumer = consumer;
                }

                @Override
                public Void run() throws TError, CancelException {
                    this.consumer.accept(this.getParameter());
                    return null;
                }
            }
        }
    }
}

