/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskWorker;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.util.DebugUtil;

public final class TaskMonitoring {
    public static boolean checkLocksOfBlockingTasks = false;
    public static int monitoringInterval = 60000;
    public static int secondsBeforeToPutTaskAside = 300;
    public static int secondsBeforeToKillTask = 600;
    private static TaskMonitor monitor;

    private TaskMonitoring() {
    }

    static synchronized void start(ThreadFactory threadFactory) {
        if (monitor != null) {
            return;
        }
        monitor = new TaskMonitor();
        Thread t = threadFactory.newThread(monitor);
        t.setName("Task Monitoring");
        t.start();
        LCCore.get().toClose(monitor);
    }

    private static class TaskMonitor
    implements Runnable,
    Closeable {
        private Object lock = new Object();
        private boolean closed = false;

        private TaskMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.closed) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(monitoringInterval);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (this.closed) {
                        break;
                    }
                }
                LinkedList<TaskWorker> blocked = new LinkedList<TaskWorker>();
                for (TaskManager manager : Threading.getAllTaskManagers()) {
                    if (!(manager instanceof FixedThreadTaskManager)) continue;
                    FixedThreadTaskManager m = (FixedThreadTaskManager)manager;
                    TaskMonitor.check(m);
                    blocked.addAll(m.getBlockedWorkers());
                }
                TaskMonitor.checkBlockedWorkers(blocked);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.closed = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        private static void check(FixedThreadTaskManager manager) {
            for (TaskWorker worker : manager.getAllActiveWorkers()) {
                TaskMonitor.check(worker);
            }
        }

        private static void check(TaskWorker worker) {
            if (worker == null) {
                return;
            }
            long now = System.nanoTime();
            Task<?, ?> task = worker.currentTask;
            if (task == null) {
                return;
            }
            long start = worker.currentTaskStart;
            long seconds = (now - start) / 1000000000L;
            if (seconds < (long)secondsBeforeToPutTaskAside) {
                return;
            }
            if (seconds < (long)secondsBeforeToKillTask) {
                if (worker.aside) {
                    return;
                }
                StringBuilder s = new StringBuilder(1024);
                s.append("Task ").append(task).append(" is running since ").append(seconds).append(" seconds ! put it aside and start a new thread, current stack:\r\n");
                DebugUtil.createStackTrace(s, worker.thread.getStackTrace());
                TaskMonitor.appendLocks(s, worker.thread);
                Threading.logger.warn(s.toString());
                worker.manager.putWorkerAside(worker);
                return;
            }
            StringBuilder s = new StringBuilder(1024);
            s.append("Task ").append(task).append(" is running since ").append(seconds).append(" seconds ! kill it! current stack:\r\n");
            DebugUtil.createStackTrace(s, worker.thread.getStackTrace());
            TaskMonitor.appendLocks(s, worker.thread);
            Threading.logger.error(s.toString());
            worker.manager.killWorker(worker);
        }

        private static void checkBlockedWorkers(LinkedList<TaskWorker> workers) {
            if (!checkLocksOfBlockingTasks) {
                return;
            }
            if (workers.isEmpty()) {
                return;
            }
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean == null) {
                return;
            }
            long[] ids = new long[workers.size()];
            int i = 0;
            for (TaskWorker w : workers) {
                ids[i++] = w.thread.getId();
            }
            ThreadInfo[] info = bean.getThreadInfo(ids, true, false);
            Iterator it = workers.iterator();
            for (ThreadInfo ti : info) {
                MonitorInfo[] monitors;
                TaskWorker w = (TaskWorker)it.next();
                Task<?, ?> task = w.currentTask;
                if (task == null || !w.blocked || (monitors = ti.getLockedMonitors()).length == 0) continue;
                StringBuilder s = new StringBuilder(1024);
                s.append("TaskWorker is blocked while locking objects in task ").append(task.description).append(":\r\n");
                DebugUtil.createStackTrace(s, ti.getStackTrace());
                TaskMonitor.append(s, monitors);
                if (!w.blocked || System.currentTimeMillis() - w.currentTaskStart - w.blockedTime < 5000L) continue;
                Threading.logger.error(s.toString());
            }
        }

        private static void appendLocks(StringBuilder s, Thread t) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean == null) {
                return;
            }
            ThreadInfo info = bean.getThreadInfo(new long[]{t.getId()}, true, false)[0];
            if (info == null) {
                return;
            }
            MonitorInfo[] monitors = info.getLockedMonitors();
            TaskMonitor.append(s, monitors);
        }

        private static void append(StringBuilder s, MonitorInfo[] monitors) {
            if (monitors.length > 0) {
                s.append("\r\nLocked monitors:");
                for (int i = 0; i < monitors.length; ++i) {
                    StackTraceElement trace = monitors[i].getLockedStackFrame();
                    s.append("\r\n - ").append(trace.getClassName()).append('#').append(trace.getMethodName()).append(':').append(trace.getLineNumber());
                }
            }
        }
    }
}

