/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.exception.NoException;

public final class ThreadingDebugHelper {
    private static ArrayList<JP> jps = new ArrayList();
    private static LinkedList<MonitoredTask> tasks = new LinkedList();

    private ThreadingDebugHelper() {
    }

    public static synchronized void register(JoinPoint<?> jp) {
        JP j = new JP();
        j.jp = jp;
        JP.access$202(j, Thread.currentThread().getStackTrace());
        jps.add(j);
    }

    public static synchronized void registerJoin(JoinPoint<?> jp, IAsync<?> sp) {
        for (JP j : jps) {
            if (j.jp != jp) continue;
            j.toJoinTraces.add(Thread.currentThread().getStackTrace());
            j.toJoinSP.add(sp);
            sp.onDone(() -> {
                int i = j.toJoinSP.indexOf(sp);
                j.toJoinSP.remove(i);
                j.toJoinTraces.remove(i);
            });
            break;
        }
    }

    public static synchronized void started(final JoinPoint<?> jp) {
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Check JoinPoint", 6){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (jp.isDone()) {
                    return null;
                }
                Class<ThreadingDebugHelper> clazz = ThreadingDebugHelper.class;
                synchronized (ThreadingDebugHelper.class) {
                    for (int i = 0; i < jps.size(); ++i) {
                        if (((JP)jps.get(i)).jp != jp) continue;
                        JP j = (JP)jps.get(i);
                        StringBuilder s = new StringBuilder();
                        s.append("JoinPoint still blocked after 30s.:\r\n");
                        s.append(" + Creation =\r\n");
                        for (StackTraceElement e : j.creationTrace) {
                            s.append("    - ").append(e.getClassName()).append('#').append(e.getMethodName()).append(":").append(e.getLineNumber()).append("\r\n");
                        }
                        s.append(" + Remaining joins:\r\n");
                        for (int k = 0; k < j.toJoinSP.size(); ++k) {
                            IAsync sp = (IAsync)j.toJoinSP.get(k);
                            if (sp.isDone()) continue;
                            s.append("    + ");
                            if (sp instanceof Task.Output) {
                                s.append("Task [").append(((Task.Output)sp).getTask().getDescription()).append("], ");
                            }
                            s.append("creation at\r\n");
                            for (StackTraceElement e : (StackTraceElement[])j.toJoinTraces.get(k)) {
                                s.append("        - ").append(e.getClassName()).append('#').append(e.getMethodName()).append(":").append(e.getLineNumber()).append("\r\n");
                            }
                        }
                        Threading.logger.error(s.toString());
                        jps.remove(i);
                        break;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
        };
        task.executeIn(30000L);
        task.start();
    }

    public static synchronized void unblocked(Async<?> sp) {
        if (sp instanceof JoinPoint) {
            for (int i = 0; i < jps.size(); ++i) {
                if (jps.get(i).jp != sp) continue;
                jps.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void newTask(Task<?, ?> task) {
        LinkedList<MonitoredTask> linkedList = tasks;
        synchronized (linkedList) {
            tasks.add(new MonitoredTask(task));
        }
        task.getOutput().onDone(() -> {
            LinkedList<MonitoredTask> linkedList = tasks;
            synchronized (linkedList) {
                Iterator it = tasks.iterator();
                while (it.hasNext()) {
                    if (((MonitoredTask)it.next()).task != task) continue;
                    it.remove();
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitingFor(Task<?, ?> task, IAsync<?> sp) {
        LinkedList<MonitoredTask> linkedList = tasks;
        synchronized (linkedList) {
            for (MonitoredTask t : tasks) {
                if (t.task != task) continue;
                t.waitingFor.add(sp);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitingFor(Task<?, ?> task, IAsync<?>[] sp) {
        LinkedList<MonitoredTask> linkedList = tasks;
        synchronized (linkedList) {
            for (MonitoredTask t : tasks) {
                if (t.task != task) continue;
                for (int i = 0; i < sp.length; ++i) {
                    t.waitingFor.add(sp[i]);
                }
            }
        }
    }

    static void waitingFor(Task<?, ?> task, Task<?, ?> waitingFor) {
        ThreadingDebugHelper.waitingFor(task, waitingFor.getOutput());
    }

    static void traceTasksNotDone() {
        Thread t = new Thread("Track tasks not done"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    LinkedList linkedList = tasks;
                    synchronized (linkedList) {
                        long now = System.currentTimeMillis();
                        Iterator it = tasks.iterator();
                        while (it.hasNext()) {
                            MonitoredTask t = (MonitoredTask)it.next();
                            if (now - t.creation < 30000L) continue;
                            if (t.task.executeEvery > 0L) {
                                it.remove();
                                continue;
                            }
                            if (t.task.nextExecution > now) continue;
                            StringBuilder s = new StringBuilder();
                            s.append("Task not yet done: ").append(t.task.description).append("\r\n");
                            s.append("  -> status = ").append(t.task.status).append("\r\n");
                            for (IAsync iAsync : t.waitingFor) {
                                s.append(" -> Waiting for ");
                                s.append(iAsync.toString());
                                if (iAsync.isDone()) {
                                    s.append(" [unblocked]");
                                }
                                if (iAsync.hasError()) {
                                    s.append(" [has error]");
                                }
                                if (iAsync.isCancelled()) {
                                    s.append(" [cancelled]");
                                }
                                s.append("\r\n");
                            }
                            Threading.logger.debug(s.toString());
                        }
                    }
                }
            }
        };
        t.start();
    }

    private static class MonitoredTask {
        Task<?, ?> task;
        long creation = System.currentTimeMillis();
        LinkedList<IAsync<?>> waitingFor = new LinkedList();

        MonitoredTask(Task<?, ?> task) {
            this.task = task;
        }
    }

    private static class JP {
        private JoinPoint<?> jp;
        private StackTraceElement[] creationTrace;
        private ArrayList<StackTraceElement[]> toJoinTraces = new ArrayList();
        private ArrayList<IAsync<?>> toJoinSP = new ArrayList();

        private JP() {
        }

        static /* synthetic */ StackTraceElement[] access$202(JP x0, StackTraceElement[] x1) {
            x0.creationTrace = x1;
            return x1;
        }
    }
}

