/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.Cancellable;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.ThreadUtil;

public interface IAsync<TError extends Exception>
extends Cancellable {
    public boolean isDone();

    public boolean hasError();

    public void error(TError var1);

    public TError getError();

    default public boolean isSuccessful() {
        return this.isDone() && !this.hasError() && !this.isCancelled();
    }

    public void block(long var1);

    default public void blockException(long timeout) throws TError {
        this.block(timeout);
        if (this.hasError()) {
            throw this.getError();
        }
    }

    default public void blockThrow(long timeout) throws TError, CancelException {
        this.block(timeout);
        if (this.hasError()) {
            throw this.getError();
        }
        if (this.isCancelled()) {
            throw this.getCancelEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void blockPause(long logWarningAfterMillis) {
        IAsync iAsync = this;
        synchronized (iAsync) {
            while (this.blockPauseCondition()) {
                long start = System.currentTimeMillis();
                if (!ThreadUtil.wait(this, logWarningAfterMillis + 1000L)) {
                    return;
                }
                if (System.currentTimeMillis() - start <= logWarningAfterMillis) continue;
                Logger logger = LCCore.get().getThreadingLogger();
                logger.warn("Still blocked after " + logWarningAfterMillis / 1000L + "s.", new Exception(""));
            }
        }
    }

    public boolean blockPauseCondition();

    default public void onSuccess(final Runnable listener) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.isSuccessful()) {
                    listener.run();
                }
            }

            public String toString() {
                return listener.toString();
            }
        });
    }

    default public void onError(final Consumer<TError> listener) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.hasError()) {
                    listener.accept(IAsync.this.getError());
                }
            }

            public String toString() {
                return listener.toString();
            }
        });
    }

    default public void onCancel(final Consumer<CancelException> listener) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.isCancelled()) {
                    listener.accept(IAsync.this.getCancelEvent());
                }
            }

            public String toString() {
                return listener.toString();
            }
        });
    }

    default public void onErrorOrCancel(final Runnable runnable) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (!IAsync.this.isSuccessful()) {
                    runnable.run();
                }
            }

            public String toString() {
                return runnable.toString();
            }
        });
    }

    public void onDone(Runnable var1);

    default public void onDone(Async<TError> sp) {
        this.onDone(() -> {
            if (this.isCancelled()) {
                sp.cancel(this.getCancelEvent());
            } else if (this.hasError()) {
                sp.error(this.getError());
            } else {
                sp.unblock();
            }
        });
    }

    default public <TError2 extends Exception> void onDone(Async<TError2> sp, Function<TError, TError2> errorConverter) {
        this.onDone(() -> {
            if (this.isCancelled()) {
                sp.cancel(this.getCancelEvent());
            } else if (this.hasError()) {
                sp.error((Exception)errorConverter.apply(this.getError()));
            } else {
                sp.unblock();
            }
        });
    }

    default public <T> void onDone(AsyncSupplier<T, TError> sp, Supplier<T> resultSupplier) {
        this.onDone(() -> sp.unblockSuccess(resultSupplier.get()), sp);
    }

    default public void onDone(final Runnable onReady, final Consumer<TError> onError, final Consumer<CancelException> onCancel) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.hasError()) {
                    onError.accept(IAsync.this.getError());
                } else if (IAsync.this.isCancelled()) {
                    onCancel.accept(IAsync.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return onReady.toString() + '/' + onError + '/' + onCancel;
            }
        });
    }

    default public void onDone(final Runnable onReady, final IAsync<TError> onErrorOrCancel) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.hasError()) {
                    onErrorOrCancel.error(IAsync.this.getError());
                } else if (IAsync.this.isCancelled()) {
                    onErrorOrCancel.cancel(IAsync.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return onReady.toString();
            }
        });
    }

    default public <TError2 extends Exception> void onDone(final Runnable onReady, final IAsync<TError2> onErrorOrCancel, final Function<TError, TError2> errorConverter) {
        this.onDone(new Runnable(){

            @Override
            public void run() {
                if (IAsync.this.hasError()) {
                    onErrorOrCancel.error((Exception)errorConverter.apply(IAsync.this.getError()));
                } else if (IAsync.this.isCancelled()) {
                    onErrorOrCancel.cancel(IAsync.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return onReady.toString();
            }
        });
    }

    default public boolean forwardIfNotSuccessful(IAsync<TError> sp) {
        if (this.hasError()) {
            sp.error(this.getError());
            return true;
        }
        if (this.isCancelled()) {
            sp.cancel(this.getCancelEvent());
            return true;
        }
        return false;
    }

    default public void thenStart(Task<?, ? extends Exception> task, boolean evenIfErrorOrCancel) {
        task.startOn(this, evenIfErrorOrCancel);
    }

    default public void thenStart(String description, byte priority, Runnable task, boolean evenIfErrorOrCancel) {
        new Task.Cpu.FromRunnable(task, description, priority).startOn(this, evenIfErrorOrCancel);
    }

    default public void thenStart(Task<?, ? extends Exception> task, Runnable onErrorOrCancel) {
        task.startOn(this, false);
        this.onErrorOrCancel(onErrorOrCancel);
    }

    default public void thenStart(Task<?, ? extends Exception> task, IAsync<TError> onErrorOrCancel) {
        this.onDone(() -> {
            task.start();
            task.getOutput().onCancel(cancel -> {
                if (!onErrorOrCancel.isDone()) {
                    onErrorOrCancel.cancel((CancelException)cancel);
                }
            });
        }, onErrorOrCancel);
    }

    default public <TError2 extends Exception> void thenStart(Task<?, ? extends Exception> task, IAsync<TError2> onErrorOrCancel, Function<TError, TError2> errorConverter) {
        this.onDone(() -> {
            task.start();
            task.getOutput().onCancel(cancel -> {
                if (!onErrorOrCancel.isDone()) {
                    onErrorOrCancel.cancel((CancelException)cancel);
                }
            });
        }, onErrorOrCancel, errorConverter);
    }

    default public void thenStart(String description, byte priority, Runnable task, IAsync<TError> onErrorOrCancel) {
        Task.Cpu.FromRunnable t = new Task.Cpu.FromRunnable(task, description, priority);
        this.onDone(() -> {
            t.start();
            t.getOutput().onCancel(cancel -> {
                if (!onErrorOrCancel.isDone()) {
                    onErrorOrCancel.cancel((CancelException)cancel);
                }
            });
        }, onErrorOrCancel);
    }

    default public boolean thenDoOrStart(Runnable runnable, String taskDescription, byte taskPriority) {
        if (this.isDone()) {
            runnable.run();
            return true;
        }
        this.thenStart(new Task.Cpu.FromRunnable(taskDescription, taskPriority, runnable), true);
        return false;
    }

    default public boolean thenDoOrStart(Runnable runnable, String taskDescription, byte taskPriority, IAsync<TError> onErrorOrCancel) {
        if (this.isDone()) {
            if (!this.forwardIfNotSuccessful(onErrorOrCancel)) {
                runnable.run();
            }
            return true;
        }
        this.thenStart(new Task.Cpu.FromRunnable(taskDescription, taskPriority, runnable), onErrorOrCancel);
        return false;
    }

    default public <TError2 extends Exception> boolean thenDoOrStart(Runnable runnable, String taskDescription, byte taskPriority, IAsync<TError2> onErrorOrCancel, Function<TError, TError2> errorConverter) {
        if (this.isDone()) {
            if (this.hasError()) {
                onErrorOrCancel.error((Exception)errorConverter.apply(this.getError()));
            } else if (this.isCancelled()) {
                onErrorOrCancel.cancel(this.getCancelEvent());
            } else {
                runnable.run();
            }
            return true;
        }
        this.thenStart(new Task.Cpu.FromRunnable(taskDescription, taskPriority, runnable), onErrorOrCancel, errorConverter);
        return false;
    }

    default public AsyncSupplier<Void, TError> toAsyncSupplier() {
        AsyncSupplier aw = new AsyncSupplier();
        this.onDone(() -> {
            if (this.hasError()) {
                aw.error(this.getError());
            } else if (this.isCancelled()) {
                aw.cancel(this.getCancelEvent());
            } else {
                aw.unblockSuccess(null);
            }
        });
        return aw;
    }

    public Collection<?> getAllListeners();

    default public void logListenerError(Logger log, Object listener, Throwable error) {
        log.error("Exception thrown by an inline listener of " + this.getClass().getSimpleName() + ": " + listener, error);
    }
}

