/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.Collection;
import java.util.function.Function;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;

public class JoinPoint<TError extends Exception>
extends Async<TError> {
    private int nbToJoin = 0;
    private boolean started = false;

    public JoinPoint() {
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.register(this);
        }
    }

    public int getToJoin() {
        return this.nbToJoin;
    }

    public synchronized void addToJoin(int nb) {
        this.nbToJoin += nb;
    }

    public synchronized void addToJoin(IAsync<? extends TError> sp) {
        ++this.nbToJoin;
        sp.onDone(() -> {
            if (sp.isCancelled()) {
                this.cancel(sp.getCancelEvent());
            } else if (sp.hasError()) {
                this.error(sp.getError());
            } else {
                this.joined();
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void addToJoin(IAsync<?> sp, Function<Exception, TError> errorConverter) {
        ++this.nbToJoin;
        sp.onDone(() -> {
            if (sp.isCancelled()) {
                this.cancel(sp.getCancelEvent());
            } else if (sp.hasError()) {
                this.error((Exception)errorConverter.apply((Exception)sp.getError()));
            } else {
                this.joined();
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void addToJoin(Task<?, ? extends TError> task) {
        this.addToJoin(task.getOutput());
    }

    public synchronized void addToJoinNoException(IAsync<?> sp) {
        ++this.nbToJoin;
        sp.onDone(this::joined);
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void addToJoinDoNotCancel(IAsync<? extends TError> sp) {
        ++this.nbToJoin;
        sp.onDone(() -> {
            if (sp.hasError()) {
                this.error(sp.getError());
            } else {
                this.joined();
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void start() {
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.started(this);
        }
        this.started = true;
        if (this.nbToJoin == 0) {
            this.unblock();
        }
    }

    public synchronized void joined() {
        if (this.nbToJoin == 0) {
            LCCore.getApplication().getDefaultLogger().error("JoinPoint: nbToJoin already 0", new Exception());
            return;
        }
        if (this.isDone()) {
            --this.nbToJoin;
            if (!this.hasError() && !this.isCancelled()) {
                LCCore.getApplication().getDefaultLogger().error("JoinPoint: joined after timeout", new Exception());
            }
            return;
        }
        if (--this.nbToJoin <= 0 && this.started) {
            this.unblock();
        }
    }

    public synchronized void timeout(long millis, Runnable callback) {
        if (callback == null) {
            this.listenTime(millis, this::unblock);
        } else {
            this.listenTime(millis, () -> {
                try {
                    callback.run();
                }
                catch (Exception t) {
                    LCCore.getApplication().getDefaultLogger().error("Error in callback of JoinPoint timeout", t);
                }
                this.unblock();
            });
        }
    }

    public synchronized void listenTime(long timeout, final Runnable callback) {
        if (this.isDone()) {
            return;
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("JoinPoint timeout", 5){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                JoinPoint joinPoint = JoinPoint.this;
                synchronized (joinPoint) {
                    if (JoinPoint.this.isDone()) {
                        return null;
                    }
                    if (callback != null) {
                        try {
                            callback.run();
                        }
                        catch (Exception t) {
                            LCCore.getApplication().getDefaultLogger().error("Error in callback of JoinPoint time listener", t);
                        }
                    }
                    return null;
                }
            }
        };
        task.executeIn(timeout);
        if (this.isDone()) {
            return;
        }
        task.start();
    }

    public static JoinPoint<Exception> from(IAsync<?> ... synchPoints) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (int i = 0; i < synchPoints.length; ++i) {
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> from(Collection<? extends IAsync<?>> synchPoints) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (IAsync<?> sp : synchPoints) {
            jp.addToJoin(sp);
        }
        jp.start();
        return jp;
    }

    @SafeVarargs
    public static <T extends Exception> JoinPoint<T> fromSimilarError(IAsync<T> ... synchPoints) {
        JoinPoint<T> jp = new JoinPoint<T>();
        for (int i = 0; i < synchPoints.length; ++i) {
            if (synchPoints[i] == null) continue;
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> fromTasks(Task<?, ?> ... tasks) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (Task<?, ?> task : tasks) {
            jp.addToJoin(task.getOutput());
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> fromTasks(Collection<? extends Task<?, ?>> tasks) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (Task<?, ?> task : tasks) {
            jp.addToJoin(task.getOutput());
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<NoException> fromTasksNoErrorOrCancel(Collection<? extends Task<?, ?>> tasks) {
        JoinPoint<NoException> jp = new JoinPoint<NoException>();
        jp.addToJoin(tasks.size());
        Runnable jpr = jp::joined;
        jp.start();
        for (Task<?, ?> t : tasks) {
            t.getOutput().onDone(jpr);
        }
        return jp;
    }

    public static void joinThenDo(Runnable listener, IAsync<?> ... synchPoints) {
        JoinPoint jp = new JoinPoint();
        for (int i = 0; i < synchPoints.length; ++i) {
            if (synchPoints[i] == null) continue;
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        jp.onDone(listener);
    }

    public static void joinOnDoneThenDo(Runnable listener, IAsync<?> ... synchPoints) {
        JoinPoint jp = new JoinPoint();
        jp.addToJoin(synchPoints.length);
        Runnable jpr = jp::joined;
        for (int i = 0; i < synchPoints.length; ++i) {
            synchPoints[i].onDone(jpr);
        }
        jp.start();
        jp.onDone(listener);
    }
}

