/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.ArrayList;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.AbstractLock;
import net.lecousin.framework.concurrent.async.Async;

public class MutualExclusion<TError extends Exception>
extends AbstractLock<TError> {
    private Thread lockingThread = null;
    private int lockedTimes = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        if (this.cancel != null) {
            return;
        }
        if (this.error != null) {
            return;
        }
        Thread t = Thread.currentThread();
        if (t == this.lockingThread) {
            ++this.lockedTimes;
            return;
        }
        BlockedThreadHandler blockedHandler = null;
        while (true) {
            MutualExclusion mutualExclusion = this;
            synchronized (mutualExclusion) {
                if (this.lockingThread == null) {
                    this.lockingThread = t;
                    this.lockedTimes = 1;
                    return;
                }
                if (blockedHandler == null) {
                    blockedHandler = Threading.getBlockedThreadHandler(t);
                }
                if (blockedHandler == null) {
                    try {
                        this.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            blockedHandler.blocked(this, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        ArrayList list;
        Thread t = Thread.currentThread();
        Object object = this;
        synchronized (object) {
            if (t != this.lockingThread) {
                return;
            }
            if (--this.lockedTimes > 0) {
                return;
            }
            this.lockingThread = null;
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable r : list) {
                r.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isDone() {
        return this.lockingThread == null;
    }

    @Override
    public boolean blockPauseCondition() {
        return this.lockingThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDone(Runnable r) {
        MutualExclusion mutualExclusion = this;
        synchronized (mutualExclusion) {
            if (this.lockingThread == null) {
                r.run();
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(r);
            }
        }
    }

    @Override
    public void block(long timeout) {
        if (this.lockingThread == null) {
            return;
        }
        Async sp = new Async();
        this.onDone(sp::unblock);
        sp.block(timeout);
    }
}

