/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.ArrayList;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.AbstractLock;
import net.lecousin.framework.util.ThreadUtil;

public class WaitingDataQueueSynchronizationPoint<DataType, TError extends Exception>
extends AbstractLock<TError> {
    private TurnArray<DataType> waitingData = new TurnArray();
    private boolean end = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType waitForData(long timeout) {
        long start = System.currentTimeMillis();
        do {
            BlockedThreadHandler blockedHandler;
            WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
            synchronized (waitingDataQueueSynchronizationPoint) {
                if (this.cancel != null) {
                    return null;
                }
                if (this.error != null) {
                    return null;
                }
                if (!this.waitingData.isEmpty()) {
                    return this.waitingData.removeFirst();
                }
                if (this.end) {
                    return null;
                }
                Thread t = Thread.currentThread();
                blockedHandler = Threading.getBlockedThreadHandler(t);
                if (blockedHandler == null && !ThreadUtil.wait(this, timeout)) {
                    return null;
                }
            }
            if (blockedHandler == null) continue;
            blockedHandler.blocked(this, timeout);
        } while (timeout <= 0L || System.currentTimeMillis() - start < timeout);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDataReady(DataType data) {
        ArrayList list;
        Object object = this;
        synchronized (object) {
            if (this.end) {
                throw new IllegalStateException("method endOfData already called, method newDataReady is not allowed anymore");
            }
            this.waitingData.addLast(data);
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfData() {
        ArrayList list = null;
        Object object = this;
        synchronized (object) {
            this.end = true;
            if (this.waitingData.isEmpty()) {
                list = this.listeners;
                this.listeners = null;
            }
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isDone() {
        return !this.waitingData.isEmpty() || this.cancel != null || this.error != null || this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(long timeout) {
        long start = System.currentTimeMillis();
        do {
            BlockedThreadHandler blockedHandler;
            WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
            synchronized (waitingDataQueueSynchronizationPoint) {
                if (this.cancel != null) {
                    return;
                }
                if (this.error != null) {
                    return;
                }
                if (!this.waitingData.isEmpty()) {
                    return;
                }
                if (this.end) {
                    return;
                }
                Thread t = Thread.currentThread();
                blockedHandler = Threading.getBlockedThreadHandler(t);
                if (blockedHandler == null && !ThreadUtil.wait(this, timeout)) {
                    return;
                }
            }
            if (blockedHandler == null) continue;
            blockedHandler.blocked(this, timeout);
        } while (timeout <= 0L || System.currentTimeMillis() - start < timeout);
    }

    @Override
    public boolean blockPauseCondition() {
        return this.cancel == null && this.error == null && !this.end && this.waitingData.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDone(Runnable listener) {
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            if (this.waitingData.isEmpty() && !this.end) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(listener);
                return;
            }
        }
        listener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unlock() {
        ArrayList list;
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            this.notify();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
    }
}

