/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.ICharacterStream;

public class SavePropertiesFileTask
extends Task.Cpu<Void, IOException> {
    private Properties properties;
    private ICharacterStream.Writable.Buffered output;
    private boolean closeStreamAtEnd;

    public static IAsync<IOException> savePropertiesFile(Properties properties, File file, Charset charset, byte priority) {
        FileIO.ReadWrite io = new FileIO.ReadWrite(file, priority);
        IAsync resize = io.setSizeAsync(0L);
        Async<IOException> result = new Async<IOException>();
        ((AsyncSupplier)resize).onDone(() -> SavePropertiesFileTask.lambda$savePropertiesFile$0((AsyncSupplier)resize, result, io, properties, charset, priority));
        return result;
    }

    public static IAsync<IOException> savePropertiesFile(Properties properties, IO.Writable output, Charset charset, byte priority, boolean closeIOAtEnd) {
        BufferedWritableCharacterStream stream = new BufferedWritableCharacterStream(output, charset, 4096);
        return SavePropertiesFileTask.savePropertiesFile(properties, stream, priority, closeIOAtEnd);
    }

    public static IAsync<IOException> savePropertiesFile(Properties properties, ICharacterStream.Writable.Buffered output, byte priority, boolean closeStreamAtEnd) {
        SavePropertiesFileTask task = new SavePropertiesFileTask(properties, output, priority, closeStreamAtEnd);
        task.start();
        return task.getOutput();
    }

    public SavePropertiesFileTask(Properties properties, ICharacterStream.Writable.Buffered output, byte priority, boolean closeStreamAtEnd) {
        super("Save properties file", priority);
        this.properties = properties;
        this.output = output;
        this.closeStreamAtEnd = closeStreamAtEnd;
    }

    @Override
    public Void run() throws IOException, CancelException {
        try {
            for (Map.Entry<Object, Object> p : this.properties.entrySet()) {
                this.output.writeSync(p.getKey().toString());
                this.output.writeSync('=');
                this.output.writeSync(p.getValue().toString());
                this.output.writeSync('\n');
            }
            this.output.flush().blockThrow(0L);
            Iterator<Map.Entry<Object, Object>> iterator = null;
            return iterator;
        }
        finally {
            if (this.closeStreamAtEnd) {
                try {
                    this.output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static /* synthetic */ void lambda$savePropertiesFile$0(AsyncSupplier resize, Async result, FileIO.ReadWrite io, Properties properties, Charset charset, byte priority) {
        if (resize.hasError()) {
            result.error(resize.getError());
            io.closeAsync();
            return;
        }
        SavePropertiesFileTask.savePropertiesFile(properties, io, charset, priority, true).onDone(result);
    }
}

