/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.Task;

public class CreateDirectoryTask
extends Task.OnFile<Void, IOException> {
    private File dir;
    private boolean recursive;
    private boolean failIfExists;

    public CreateDirectoryTask(File dir, boolean recursive, boolean failIfExists, byte priority) {
        super(dir, "Create directory", priority);
        this.dir = dir;
        this.recursive = recursive;
        this.failIfExists = failIfExists;
    }

    @Override
    public Void run() throws IOException {
        boolean created = this.recursive ? this.dir.mkdirs() : this.dir.mkdir();
        if (!this.dir.exists()) {
            throw new IOException("Directory not created");
        }
        if (!created && this.failIfExists) {
            throw new IOException("Directory already exists");
        }
        return null;
    }
}

