/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.io.util.FileInfo;
import net.lecousin.framework.progress.WorkProgress;

public class DirectoryReader
extends Task.OnFile<Result, AccessDeniedException> {
    protected File dir;
    protected Request request;
    protected WorkProgress progress;

    public DirectoryReader(TaskManager taskManager, File dir, byte priority, Request request, WorkProgress progress) {
        super(taskManager, "Reading directory " + dir.getAbsolutePath(), priority);
        this.dir = dir;
        this.request = request;
        this.progress = progress;
        if (progress != null) {
            WorkProgress.linkTo(progress, this);
        }
    }

    public DirectoryReader(File dir, byte priority, Request request, WorkProgress progress) {
        super(dir, "Reading directory " + dir.getAbsolutePath(), priority);
        this.dir = dir;
        this.request = request;
        this.progress = progress;
        if (progress != null) {
            WorkProgress.linkTo(progress, this);
        }
    }

    public DirectoryReader(TaskManager taskManager, File dir, byte priority, Request request) {
        this(taskManager, dir, priority, request, null);
    }

    public DirectoryReader(File dir, byte priority, Request request) {
        this(dir, priority, request, null);
    }

    public File getDirectory() {
        return this.dir;
    }

    @Override
    public Result run() throws AccessDeniedException {
        File[] list = this.dir.listFiles();
        if (list == null) {
            throw new AccessDeniedException("Directory " + this.dir.getAbsolutePath());
        }
        if (this.progress != null) {
            this.progress.progress(this.progress.getRemainingWork() / 2L);
        }
        Result result = new Result();
        int len = list.length;
        if (len == 0) {
            Result.access$002(result, new FileInfo[0]);
            return result;
        }
        Result.access$002(result, new FileInfo[list.length]);
        long work = this.progress != null ? this.progress.getRemainingWork() : 0L;
        int nb = list.length;
        for (int i = 0; i < list.length; ++i) {
            FileInfo f;
            long step = work / (long)nb--;
            work -= step;
            ((Result)result).files[i] = f = new FileInfo();
            f.file = list[i];
            this.readFile(f, result);
            if (this.progress == null) continue;
            this.progress.progress(step);
        }
        return result;
    }

    private void readFile(FileInfo f, Result result) {
        BasicFileAttributes attr;
        f.path = f.file.toPath();
        try {
            attr = Files.readAttributes(f.path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            this.getApplication().getDefaultLogger().error("Cannot get basic file attributes on " + f.file.getAbsolutePath(), e);
            return;
        }
        if (attr.isDirectory()) {
            f.isDirectory = true;
            result.nbDirectories++;
        } else {
            f.isDirectory = false;
            result.nbFiles++;
            if (this.request != null && this.request.readSize) {
                f.size = attr.size();
            }
        }
        if (this.request != null) {
            if (this.request.readLastModified) {
                f.lastModified = attr.lastModifiedTime().toMillis();
            }
            if (this.request.readLastAccess) {
                f.lastAccess = attr.lastAccessTime().toMillis();
            }
            if (this.request.readCreation) {
                f.creation = attr.creationTime().toMillis();
            }
            if (this.request.readIsSymbolicLink) {
                f.isSymbolicLink = attr.isSymbolicLink();
            }
        }
    }

    public static class ListSubDirectories
    extends Task.OnFile<ArrayList<File>, AccessDeniedException> {
        private File dir;

        public ListSubDirectories(File dir, byte priority) {
            super(dir, "Listing sub directories", priority);
            this.dir = dir;
        }

        @Override
        public ArrayList<File> run() throws AccessDeniedException {
            String[] names = this.dir.list();
            if (names == null) {
                throw new AccessDeniedException("Directory " + this.dir.getAbsolutePath());
            }
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < names.length; ++i) {
                File f = new File(this.dir, names[i]);
                if (!f.isDirectory()) continue;
                result.add(f);
            }
            return result;
        }
    }

    public static class Result {
        private int nbDirectories = 0;
        private int nbFiles = 0;
        private FileInfo[] files;

        public int getNbDirectories() {
            return this.nbDirectories;
        }

        public int getNbFiles() {
            return this.nbFiles;
        }

        public FileInfo[] getFiles() {
            return this.files;
        }

        static /* synthetic */ FileInfo[] access$002(Result x0, FileInfo[] x1) {
            x0.files = x1;
            return x1;
        }
    }

    public static class Request {
        private boolean readLastModified = false;
        private boolean readLastAccess = false;
        private boolean readCreation = false;
        private boolean readIsSymbolicLink = false;
        private boolean readSize = false;

        public Request readLastModified() {
            this.readLastModified = true;
            return this;
        }

        public Request readLastAccess() {
            this.readLastAccess = true;
            return this;
        }

        public Request readCreation() {
            this.readCreation = true;
            return this;
        }

        public Request readIsSymbolicLink() {
            this.readIsSymbolicLink = true;
            return this;
        }

        public Request readSize() {
            this.readSize = true;
            return this;
        }
    }
}

