/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.exception.NoException;

public class DriveOperationsSequence
extends Task<Void, IOException> {
    private boolean autoStart;
    private TurnArray<Operation> operations = new TurnArray(10);
    private boolean waiting = false;
    private Async<NoException> sp;
    private boolean end = false;

    public DriveOperationsSequence(TaskManager manager, String description, byte priority, boolean autoStart) {
        super(manager, description, priority);
        this.autoStart = autoStart;
        if (autoStart) {
            this.sp = new Async();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Operation operation) {
        TurnArray<Operation> turnArray = this.operations;
        synchronized (turnArray) {
            this.operations.addLast(operation);
            if (this.waiting) {
                this.sp.unblock();
            }
        }
        if (this.autoStart && this.operations.size() == 1 && this.getStatus() == 0) {
            this.start();
        }
    }

    public void endOfOperations() {
        this.end = true;
        if (this.sp != null) {
            this.sp.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void run() throws IOException {
        while (true) {
            Operation op;
            TurnArray<Operation> turnArray = this.operations;
            synchronized (turnArray) {
                op = this.operations.pollFirst();
                if (op == null) {
                    if (this.autoStart && !this.end) {
                        this.waiting = true;
                    } else {
                        break;
                    }
                }
            }
            if (op != null) {
                op.execute();
                continue;
            }
            if (this.getApplication().isDebugMode()) {
                this.getApplication().getDefaultLogger().debug("DriveOperationsSequence is blocked, consider not using autoStart");
            }
            this.sp.block(0L);
            this.waiting = false;
            this.sp.reset();
        }
        return null;
    }

    public static class WriteIntegerOperation
    extends WriteOperation {
        private FileAccess file;
        private long position;
        private int value;
        private ByteBuffer buffer;

        public WriteIntegerOperation(FileAccess file, long position, int value, ByteBuffer usingBuffer) {
            this.file = file;
            this.position = position;
            this.value = value;
            this.buffer = usingBuffer;
        }

        @Override
        public FileAccess getFile() {
            return this.file;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public ByteBuffer getBuffer() {
            this.buffer.clear();
            this.buffer.putInt(this.value);
            this.buffer.flip();
            return this.buffer;
        }
    }

    public static class WriteLongOperation
    extends WriteOperation {
        private FileAccess file;
        private long position;
        private long value;
        private ByteBuffer buffer;

        public WriteLongOperation(FileAccess file, long position, long value, ByteBuffer usingBuffer) {
            this.file = file;
            this.position = position;
            this.value = value;
            this.buffer = usingBuffer;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public FileAccess getFile() {
            return this.file;
        }

        @Override
        public ByteBuffer getBuffer() {
            this.buffer.clear();
            this.buffer.putLong(this.value);
            this.buffer.flip();
            return this.buffer;
        }
    }

    public static class WriteOperationSubBuffer
    extends WriteOperation {
        private FileAccess file;
        private long position;
        private ByteBuffer buffer;
        private int offset;
        private int len;

        public WriteOperationSubBuffer(FileAccess file, long position, ByteBuffer buffer, int offset, int len) {
            this.file = file;
            this.position = position;
            this.buffer = buffer;
            this.offset = offset;
            this.len = len;
        }

        @Override
        public FileAccess getFile() {
            return this.file;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public ByteBuffer getBuffer() {
            this.buffer.position(this.offset);
            this.buffer.limit(this.offset + this.len);
            return this.buffer;
        }
    }

    public static abstract class ReadOperation
    implements PositionOperation {
        public abstract ByteBuffer getBuffer();

        @Override
        public void execute() throws IOException {
            FileAccess file = this.getFile();
            long pos = this.getPosition();
            ByteBuffer buf = this.getBuffer();
            if (pos < 0L) {
                int nb;
                while (buf.hasRemaining() && (nb = file.channel.read(buf)) > 0) {
                }
            } else {
                int nb;
                while (buf.hasRemaining() && (nb = file.channel.read(buf, pos)) > 0) {
                    pos += (long)nb;
                }
            }
        }
    }

    public static abstract class WriteOperation
    implements PositionOperation {
        public abstract ByteBuffer getBuffer();

        @Override
        public void execute() throws IOException {
            FileAccess file = this.getFile();
            long pos = this.getPosition();
            if (pos < 0L) {
                file.channel.write(this.getBuffer());
            } else {
                file.channel.write(this.getBuffer(), pos);
            }
            file.size = file.channel.size();
        }
    }

    public static interface PositionOperation
    extends Operation {
        public long getPosition();
    }

    public static interface Operation {
        public FileAccess getFile();

        public void execute() throws IOException;
    }
}

