/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.progress.WorkProgress;

public class RemoveDirectoryContentTask
extends Task.OnFile<Long, IOException> {
    private File dir;
    private WorkProgress progress;
    private long work;
    private boolean calculateSize;

    public RemoveDirectoryContentTask(File dir, WorkProgress progress, long work, byte priority, boolean calculateSize) {
        super(dir, "Removing directory", priority);
        this.dir = dir;
        this.progress = progress;
        this.work = work;
        this.calculateSize = calculateSize;
    }

    @Override
    public Long run() throws IOException {
        return RemoveDirectoryContentTask.removeDirectoryContent(this.dir, this.progress, this.work, this.calculateSize);
    }

    static long removeDirectoryContent(File dir, WorkProgress progress, long work, boolean calculateSize) throws IOException {
        return RemoveDirectoryContentTask.remove(dir, progress, work, calculateSize, false);
    }

    static long deleteDirectory(File dir, WorkProgress progress, long work, boolean calculateSize) throws IOException {
        return RemoveDirectoryContentTask.remove(dir, progress, work, calculateSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long remove(File dir, WorkProgress progress, long work, boolean calculateSize, boolean deleteDir) throws IOException {
        try {
            if (!dir.exists()) {
                long l = 0L;
                return l;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                throw new AccessDeniedException(dir.getAbsolutePath());
            }
            long size = 0L;
            int nb = files.length;
            if (deleteDir) {
                ++nb;
            }
            for (File f : files) {
                long step = work / (long)nb--;
                work -= step;
                if (f.isDirectory()) {
                    size += RemoveDirectoryContentTask.remove(f, progress, step, calculateSize, true);
                    continue;
                }
                if (calculateSize) {
                    size += f.length();
                }
                try {
                    Files.delete(f.toPath());
                }
                finally {
                    if (progress != null) {
                        progress.progress(step);
                    }
                }
                if (progress == null || step <= 0L) continue;
                progress.progress(step);
            }
            if (deleteDir) {
                Files.delete(dir.toPath());
            }
            long l = size;
            return l;
        }
        finally {
            if (progress != null && work > 0L) {
                progress.progress(work);
            }
        }
    }
}

