/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFileTask;
import net.lecousin.framework.io.IOUtil;

public class RenameFileTask
extends Task.OnFile<Void, IOException> {
    private File source;
    private File destination;

    public static IAsync<IOException> rename(File source, File destination, byte priority) {
        String partitionDest;
        String partitionSource = Threading.getDrivesTaskManager().getPartitionPath(source);
        if (Objects.equals(partitionSource, partitionDest = Threading.getDrivesTaskManager().getPartitionPath(destination))) {
            return new RenameFileTask(Threading.getDrivesTaskManager().getTaskManager(partitionSource), source, destination, priority).start().getOutput();
        }
        AsyncSupplier<Long, IOException> copy = IOUtil.copy(source, destination, priority, source.length(), null, 0L, null);
        Async<IOException> result = new Async<IOException>();
        copy.onDone(() -> new RemoveFileTask(source, priority).start().getOutput().onDone(result), result);
        return result;
    }

    private RenameFileTask(TaskManager tm, File source, File destination, byte priority) {
        super(tm, "Rename file", priority);
        this.source = source;
        this.destination = destination;
    }

    @Override
    public Void run() throws IOException {
        if (this.destination.exists()) {
            throw new IOException("Unable to rename file " + this.source.getAbsolutePath() + " into " + this.destination.getAbsolutePath() + " because the destination already exists");
        }
        if (!this.source.renameTo(this.destination)) {
            throw new IOException("Unable to rename file " + this.source.getAbsolutePath() + " into " + this.destination.getAbsolutePath());
        }
        return null;
    }
}

