/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.util.Pair;

class WriteFileTask
extends Task.OnFile<Integer, IOException> {
    private FileAccess file;
    private long pos;
    private ByteBuffer buffer;

    public WriteFileTask(FileAccess file, long pos, ByteBuffer buffer, byte priority, Consumer<Pair<Integer, IOException>> ondone) {
        super(file.manager, "Write to file " + file.path, priority, ondone);
        this.file = file;
        this.pos = pos;
        this.buffer = buffer;
        file.openTask.ondone(this, false);
    }

    @Override
    public Integer run() throws IOException, CancelException {
        try {
            if (this.pos >= 0L) {
                this.file.channel.position(this.pos);
            }
            int nb = this.file.channel.write(this.buffer);
            this.file.size = this.file.channel.size();
            if (this.buffer.remaining() > 0) {
                throw new IOException("Only " + nb + " byte(s) written, " + this.buffer.remaining() + " remaining");
            }
            return nb;
        }
        catch (ClosedChannelException e) {
            throw new CancelException("File has been closed");
        }
    }
}

