/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import java.io.IOException;
import java.util.function.Consumer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Pair;

public class LimitAsyncOperations<InputType, OutputResultType, OutputErrorType extends Exception> {
    private Executor<InputType, OutputResultType, OutputErrorType> executor;
    private Consumer<InputType> onWritten;
    private TurnArray<Pair<InputType, AsyncSupplier<OutputResultType, OutputErrorType>>> waiting;
    private Async<NoException> lock = null;
    private AsyncSupplier<OutputResultType, OutputErrorType> lastWrite = new AsyncSupplier<Object, Object>(null, null);
    private CancelException cancelled = null;
    private OutputErrorType error = null;
    private boolean isReady = true;

    public LimitAsyncOperations(int maxOperations, Executor<InputType, OutputResultType, OutputErrorType> executor, Consumer<InputType> onWritten) {
        this.waiting = new TurnArray(maxOperations);
        this.executor = executor;
        this.onWritten = onWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncSupplier<OutputResultType, OutputErrorType> write(InputType data) throws IOException {
        while (true) {
            Async<NoException> lk;
            TurnArray<Pair<InputType, AsyncSupplier<OutputResultType, OutputErrorType>>> turnArray = this.waiting;
            synchronized (turnArray) {
                if (this.error != null) {
                    return new AsyncSupplier<Object, OutputErrorType>(null, this.error);
                }
                if (this.cancelled != null) {
                    return new AsyncSupplier<Object, Object>(null, null, this.cancelled);
                }
                if (this.isReady) {
                    this.isReady = false;
                    this.lastWrite = this.executor.execute(data);
                    AsyncSupplier<OutputResultType, OutputErrorType> op = this.lastWrite;
                    this.lastWrite.onDone(new WriteListener(data, op, null));
                    return op;
                }
                if (!this.waiting.isFull()) {
                    AsyncSupplier op = new AsyncSupplier();
                    this.waiting.addLast(new Pair(data, op));
                    this.lastWrite = op;
                    return op;
                }
                if (this.lock != null) {
                    throw new IOException("Concurrent write");
                }
                lk = this.lock = new Async();
            }
            lk.block(0L);
        }
    }

    public AsyncSupplier<OutputResultType, OutputErrorType> getLastPendingOperation() {
        return this.lastWrite.isDone() ? null : this.lastWrite;
    }

    public IAsync<OutputErrorType> flush() {
        final Async sp = new Async();
        Runnable callback = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncSupplier last = null;
                TurnArray turnArray = LimitAsyncOperations.this.waiting;
                synchronized (turnArray) {
                    if (LimitAsyncOperations.this.error != null) {
                        sp.error(LimitAsyncOperations.this.error);
                    } else if (LimitAsyncOperations.this.cancelled != null) {
                        sp.cancel(LimitAsyncOperations.this.cancelled);
                    } else if (LimitAsyncOperations.this.isReady) {
                        sp.unblock();
                    } else {
                        last = LimitAsyncOperations.this.lastWrite;
                    }
                }
                if (last != null) {
                    last.onDone(this);
                }
            }
        };
        callback.run();
        return sp;
    }

    private class WriteListener
    implements Runnable {
        private InputType data;
        private AsyncSupplier<OutputResultType, OutputErrorType> op;
        private AsyncSupplier<OutputResultType, OutputErrorType> result;

        public WriteListener(InputType data, AsyncSupplier<OutputResultType, OutputErrorType> op, AsyncSupplier<OutputResultType, OutputErrorType> result) {
            this.data = data;
            this.op = op;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Async lk = null;
            TurnArray turnArray = LimitAsyncOperations.this.waiting;
            synchronized (turnArray) {
                if (LimitAsyncOperations.this.lock != null) {
                    lk = LimitAsyncOperations.this.lock;
                    LimitAsyncOperations.this.lock = null;
                }
                if (this.op.hasError()) {
                    LimitAsyncOperations.this.error = this.op.getError();
                } else if (this.op.isCancelled()) {
                    LimitAsyncOperations.this.cancelled = this.op.getCancelEvent();
                } else {
                    Pair b = (Pair)LimitAsyncOperations.this.waiting.pollFirst();
                    if (b != null) {
                        AsyncSupplier newOp = LimitAsyncOperations.this.executor.execute(b.getValue1());
                        LimitAsyncOperations.this.lastWrite = newOp;
                        newOp.onDone(new WriteListener(b.getValue1(), newOp, (AsyncSupplier)b.getValue2()));
                    } else {
                        LimitAsyncOperations.this.isReady = true;
                    }
                }
            }
            if (this.result != null) {
                this.op.forward(this.result);
            }
            if (lk != null) {
                lk.unblock();
            }
            if (LimitAsyncOperations.this.onWritten != null) {
                LimitAsyncOperations.this.onWritten.accept(this.data);
            }
        }
    }

    public static interface Executor<InputType, OutputResultType, OutputErrorType extends Exception> {
        public AsyncSupplier<OutputResultType, OutputErrorType> execute(InputType var1);
    }
}

