/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding;

import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.encoding.BytesDecoder;
import net.lecousin.framework.encoding.BytesEncoder;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.HexaDecimalEncoding;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.memory.ByteArrayCache;

public final class QuotedPrintable {
    public static final int MAX_LINE_CHARACTERS = 76;

    private QuotedPrintable() {
    }

    public static class EncoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private AsyncConsumer<Bytes.Readable, TError> encodedConsumer;
        private ByteArrayCache cache;
        private int bufferSize;
        private Encoder encoder;

        public EncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer, int bufferSize) {
            this(encodedConsumer, bufferSize, new Encoder());
        }

        public EncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer, int bufferSize, Encoder encoder) {
            this.encodedConsumer = encodedConsumer;
            this.cache = ByteArrayCache.getInstance();
            this.bufferSize = bufferSize;
            this.encoder = encoder;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            Async result = new Async();
            this.continueEncoding(data, result);
            return result;
        }

        private void continueEncoding(Bytes.Readable data, Async<TError> result) {
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(this.bufferSize > 16 ? this.bufferSize : data.remaining() + 32, true), true);
            this.encoder.encode(data, output, false);
            if (output.hasRemaining() || !data.hasRemaining()) {
                data.free();
                output.flip();
                this.encodedConsumer.consume(output).onDone(result);
                return;
            }
            output.flip();
            this.encodedConsumer.consume(output).thenStart("Encoding quoted-printable data", (byte)4, () -> this.continueEncoding(data, result), result);
        }

        @Override
        public IAsync<TError> end() {
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(32, true), true);
            this.encoder.encode(new ByteArray(new byte[0]), output, true);
            if (output.position() > 0) {
                Async result = new Async();
                output.flip();
                this.encodedConsumer.consume(output).onDone(() -> this.encodedConsumer.end().onDone(result), result);
                return result;
            }
            return this.encodedConsumer.end();
        }

        @Override
        public void error(TError error) {
            this.encodedConsumer.error(error);
        }
    }

    public static class Encoder
    implements BytesEncoder {
        private int linePos = 0;
        private int softBreak = 0;
        private int toEncode = -1;
        private int encodePos = 0;
        private byte[] spaces = new byte[76];
        private int nbSpaces = 0;
        private int finalSpacePos = 0;
        private int finalSpacesPos = 0;

        @Override
        public void encode(Bytes.Readable input, Bytes.Writable output, boolean end) {
            while ((this.toEncode != -1 || input.hasRemaining()) && output.hasRemaining()) {
                if (this.encodeLoop(input, output)) continue;
                return;
            }
            if (!input.hasRemaining() && output.hasRemaining() && end && this.nbSpaces > this.finalSpacesPos) {
                this.finalSpaces(output);
            }
        }

        private boolean encodeLoop(Bytes.Readable input, Bytes.Writable output) {
            byte b;
            if (this.softBreak != 0) {
                this.addSoftBreak(output);
                return true;
            }
            if (this.linePos + this.nbSpaces >= 75) {
                return this.flushSpacesEndOfLines(output);
            }
            if (this.toEncode != -1) {
                if (this.encodePos > 0) {
                    this.continueEncodeByte(output);
                    return true;
                }
                b = (byte)this.toEncode;
                this.toEncode = -1;
            } else {
                b = input.get();
                if (b == 32 || b == 9) {
                    return this.addSpace(b, output);
                }
            }
            if (!this.flushSpaces(output)) {
                this.toEncode = b;
                return false;
            }
            if (b >= 33 && b <= 60 || b >= 62 && b <= 126) {
                output.put(b);
                ++this.linePos;
                if (this.linePos == 75) {
                    this.softBreak = 1;
                    this.linePos = 0;
                }
                return true;
            }
            if (this.linePos > 72) {
                this.toEncode = b & 0xFF;
                this.linePos = 0;
                this.softBreak = 1;
                return true;
            }
            return this.encodeByte(b, output);
        }

        private void addSoftBreak(Bytes.Writable output) {
            do {
                switch (this.softBreak) {
                    case 1: {
                        output.put((byte)61);
                        ++this.softBreak;
                        break;
                    }
                    case 2: {
                        output.put((byte)13);
                        ++this.softBreak;
                        break;
                    }
                    case 3: {
                        output.put((byte)10);
                        this.softBreak = 0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            } while (output.hasRemaining());
        }

        private boolean encodeByte(byte b, Bytes.Writable output) {
            output.put((byte)61);
            ++this.linePos;
            if (output.remaining() >= 2) {
                output.put((byte)HexaDecimalEncoding.encodeDigit((b & 0xF0) >> 4));
                output.put((byte)HexaDecimalEncoding.encodeDigit(b & 0xF));
                this.linePos += 2;
                return true;
            }
            if (output.hasRemaining()) {
                output.put((byte)HexaDecimalEncoding.encodeDigit((b & 0xF0) >> 4));
                ++this.linePos;
                this.encodePos = 2;
                this.toEncode = b & 0xFF;
                return false;
            }
            this.encodePos = 1;
            this.toEncode = b & 0xFF;
            return false;
        }

        private void continueEncodeByte(Bytes.Writable output) {
            if (this.encodePos == 1) {
                output.put((byte)HexaDecimalEncoding.encodeDigit((this.toEncode & 0xF0) >> 4));
                ++this.linePos;
                ++this.encodePos;
                if (!output.hasRemaining()) {
                    return;
                }
            }
            output.put((byte)HexaDecimalEncoding.encodeDigit(this.toEncode & 0xF));
            ++this.linePos;
            this.encodePos = 0;
            this.toEncode = -1;
        }

        private boolean addSpace(byte b, Bytes.Writable output) {
            this.spaces[this.nbSpaces++] = b;
            if (this.linePos + this.nbSpaces >= 75) {
                return this.flushSpacesEndOfLines(output);
            }
            return true;
        }

        private boolean flushSpacesEndOfLines(Bytes.Writable output) {
            int l = 75 - this.linePos;
            l = Math.min(l, output.remaining());
            output.put(this.spaces, 0, l);
            this.nbSpaces -= l;
            if (this.nbSpaces > 0) {
                System.arraycopy(this.spaces, l, this.spaces, 0, this.nbSpaces);
            }
            this.linePos += l;
            if (this.linePos == 75) {
                this.softBreak = 1;
                this.linePos = 0;
            }
            return output.hasRemaining();
        }

        private boolean flushSpaces(Bytes.Writable output) {
            if (this.nbSpaces == 0) {
                return true;
            }
            int l = Math.min(this.nbSpaces, output.remaining());
            output.put(this.spaces, 0, l);
            this.nbSpaces -= l;
            if (this.nbSpaces > 0) {
                System.arraycopy(this.spaces, l, this.spaces, 0, this.nbSpaces);
            }
            this.linePos += l;
            return output.hasRemaining();
        }

        private void finalSpaces(Bytes.Writable output) {
            block4: do {
                if (this.softBreak != 0) {
                    this.addSoftBreak(output);
                    continue;
                }
                if (this.linePos > 72) {
                    this.linePos = 0;
                    this.softBreak = 1;
                    continue;
                }
                switch (this.finalSpacePos) {
                    case 0: {
                        output.put((byte)61);
                        ++this.finalSpacePos;
                        break;
                    }
                    case 1: {
                        output.put((byte)48);
                        ++this.finalSpacePos;
                        break;
                    }
                    default: {
                        output.put((byte)HexaDecimalEncoding.encodeDigit(this.spaces[this.finalSpacesPos++] & 0xF));
                        if (this.finalSpacesPos != this.nbSpaces) continue block4;
                        return;
                    }
                }
            } while (output.hasRemaining());
        }

        @Override
        public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createEncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer, Function<EncodingException, TError> errorConverter) {
            return new EncoderConsumer<TError>(encodedConsumer, 0, this);
        }
    }

    public static class DecoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private AsyncConsumer<Bytes.Readable, TError> decodedConsumer;
        private ByteArrayCache cache;
        private int bufferSize;
        private Function<EncodingException, TError> errorConverter;
        private Decoder decoder;

        public DecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedConsumer, int bufferSize, Function<EncodingException, TError> errorConverter) {
            this(decodedConsumer, bufferSize, errorConverter, new Decoder());
        }

        public DecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedConsumer, int bufferSize, Function<EncodingException, TError> errorConverter, Decoder decoder) {
            this.decodedConsumer = decodedConsumer;
            this.cache = ByteArrayCache.getInstance();
            this.bufferSize = bufferSize;
            this.errorConverter = errorConverter;
            this.decoder = decoder;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            Async result = new Async();
            this.continueDecoding(data, result);
            return result;
        }

        private void continueDecoding(Bytes.Readable data, Async<TError> result) {
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(this.bufferSize > 16 ? this.bufferSize : Math.max(data.remaining(), 128), true), true);
            try {
                this.decoder.decode(data, output, false);
            }
            catch (EncodingException e) {
                EncodingException err = this.errorConverter != null ? (Exception)this.errorConverter.apply(e) : e;
                this.decodedConsumer.error(err);
                result.error(err);
                return;
            }
            if (output.hasRemaining() || !data.hasRemaining()) {
                data.free();
                output.flip();
                this.decodedConsumer.consume(output).onDone(result);
                return;
            }
            output.flip();
            this.decodedConsumer.consume(output).onDone(() -> this.continueDecoding(data, result), result);
        }

        @Override
        public IAsync<TError> end() {
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(this.bufferSize, true), true);
            try {
                this.decoder.decode(new ByteArray(new byte[0]), output, true);
            }
            catch (EncodingException e) {
                EncodingException err = this.errorConverter != null ? (Exception)this.errorConverter.apply(e) : e;
                this.decodedConsumer.error(err);
                return new Async<EncodingException>(err);
            }
            return this.decodedConsumer.end();
        }

        @Override
        public void error(TError error) {
            this.decodedConsumer.error(error);
        }
    }

    public static class Decoder
    implements BytesDecoder {
        private byte[] spaces;
        private int nbSpaces;
        private int decodedByte = -1;
        private int hexa = -2;

        @Override
        public void decode(Bytes.Readable input, Bytes.Writable output, boolean end) throws EncodingException {
            if (this.decodedByte != -1) {
                this.flushSpaces(output);
                if (!output.hasRemaining()) {
                    return;
                }
                output.put((byte)this.decodedByte);
                this.decodedByte = -1;
            }
            if (this.hexa != -2) {
                if (!this.flushSpaces(output) || !this.decodeHexa(input, output, end)) {
                    return;
                }
                this.hexa = -2;
            }
            block6: while (input.hasRemaining() && output.hasRemaining()) {
                byte b = input.get();
                if (b >= 33 && b <= 60 || b >= 62 && b <= 126) {
                    if (!this.flushSpaces(output)) {
                        this.decodedByte = b;
                        return;
                    }
                    output.put(b);
                    continue;
                }
                switch (b) {
                    case 61: {
                        if (!this.flushSpaces(output)) {
                            this.hexa = -1;
                            return;
                        }
                        if (this.decodeHexa(input, output, end)) continue block6;
                        return;
                    }
                    case 9: 
                    case 32: {
                        this.addSpace(b);
                        continue block6;
                    }
                    case 13: {
                        continue block6;
                    }
                    case 10: {
                        this.nbSpaces = 0;
                        continue block6;
                    }
                }
                throw new InvalidQuotedPrintableByte(b, input.position());
            }
        }

        private boolean decodeHexa(Bytes.Readable input, Bytes.Writable output, boolean end) throws InvalidQuotedPrintableHexadecimalValue {
            int j;
            int i;
            char c2;
            char c1;
            if (this.hexa >= 0) {
                if (!input.hasRemaining()) {
                    if (end) {
                        input.goToEnd();
                    }
                    return false;
                }
                c1 = (char)this.hexa;
                c2 = (char)(input.get() & 0xFF);
            } else {
                if (input.remaining() < 2) {
                    if (end) {
                        input.goToEnd();
                    } else {
                        this.hexa = input.hasRemaining() ? input.get() & 0xFF : -1;
                    }
                    return false;
                }
                c1 = (char)(input.get() & 0xFF);
                c2 = (char)(input.get() & 0xFF);
            }
            if (c1 == '\r' && c2 == '\n') {
                this.nbSpaces = 0;
                return true;
            }
            try {
                i = HexaDecimalEncoding.decodeChar(c1);
            }
            catch (EncodingException e) {
                throw new InvalidQuotedPrintableHexadecimalValue(c1);
            }
            try {
                j = HexaDecimalEncoding.decodeChar(c2);
            }
            catch (EncodingException e) {
                throw new InvalidQuotedPrintableHexadecimalValue(c2);
            }
            output.put((byte)(i << 4 | j));
            return true;
        }

        private void addSpace(byte space) {
            if (this.spaces == null) {
                this.spaces = new byte[16];
            } else if (this.nbSpaces == this.spaces.length) {
                byte[] s = new byte[this.spaces.length * 2];
                System.arraycopy(this.spaces, 0, s, 0, this.spaces.length);
                this.spaces = s;
            }
            this.spaces[this.nbSpaces++] = space;
        }

        private boolean flushSpaces(Bytes.Writable output) {
            if (this.nbSpaces == 0) {
                return output.hasRemaining();
            }
            int pos = 0;
            while (output.hasRemaining() && pos < this.nbSpaces) {
                output.put(this.spaces[pos++]);
            }
            if (pos == this.nbSpaces) {
                this.nbSpaces = 0;
            } else {
                System.arraycopy(this.spaces, pos, this.spaces, 0, this.nbSpaces - pos);
                this.nbSpaces -= pos;
            }
            return output.hasRemaining();
        }

        @Override
        public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createDecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedConsumer, Function<EncodingException, TError> errorConverter) {
            return new DecoderConsumer<TError>(decodedConsumer, 0, errorConverter, this);
        }
    }

    public static class InvalidQuotedPrintableByte
    extends EncodingException {
        private static final long serialVersionUID = 1L;

        public InvalidQuotedPrintableByte(byte b, int pos) {
            super("Invalid byte in quoted-printable: " + (b & 0xFF) + " at position " + pos);
        }
    }

    public static class InvalidQuotedPrintableHexadecimalValue
    extends EncodingException {
        private static final long serialVersionUID = 1L;

        public InvalidQuotedPrintableHexadecimalValue(char c) {
            super("Invalid hexadecimal value in quoted-printable: " + c);
        }
    }
}

