/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.exception;

import java.io.Serializable;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;

public class LocalizableException
extends Exception {
    private final ILocalizableString string;

    public LocalizableException(ILocalizableString string, Throwable cause) {
        super(cause);
        this.string = string;
    }

    public LocalizableException(ILocalizableString string) {
        this(string, null);
    }

    public LocalizableException(String namespace, String string, Object ... values) {
        this(new LocalizableString(namespace, string, new Serializable[]{values}), null);
    }

    public LocalizableException(String message, Throwable cause) {
        super(message, cause);
        this.string = null;
    }

    public LocalizableException(String message) {
        super(message);
        this.string = null;
    }

    @Override
    public String getMessage() {
        if (this.string == null) {
            return super.getMessage();
        }
        return this.string.localizeSync(LCCore.getApplication().getLanguageTag());
    }

    public ILocalizableString getLocalizable() {
        return this.string;
    }
}

