/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.IConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public interface IO
extends IConcurrentCloseable<IOException> {
    public String getSourceDescription();

    public IO getWrappedIO();

    public byte getPriority();

    public void setPriority(byte var1);

    public TaskManager getTaskManager();

    public static IOException error(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    public static IOException errorCancelled(CancelException e) {
        return new IOException("Cancelled", e);
    }

    public static CancelException cancelClosed() {
        return new CancelException("IO closed");
    }

    public static interface OutputToInput
    extends Readable,
    Writable {
        public void endOfData();

        public void signalErrorBeforeEndOfData(IOException var1);

        public boolean isFullDataAvailable();

        public long getAvailableDataSize();

        default public AsyncConsumer<ByteBuffer, IOException> createConsumer() {
            return this.createConsumer(this::endOfData, this::signalErrorBeforeEndOfData);
        }
    }

    public static interface WritableByteStream
    extends IO {
        public void write(byte var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        default public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        public IAsync<IOException> canStartWriting();
    }

    public static interface ReadableByteStream
    extends IO {
        public IAsync<IOException> canStartReading();

        public int read() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;

        public int readFully(byte[] var1) throws IOException;

        default public byte readByte() throws IOException {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            return (byte)b;
        }

        public int skip(int var1) throws IOException;
    }

    public static interface Resizable
    extends KnownSize {
        public void setSizeSync(long var1) throws IOException;

        public IAsync<IOException> setSizeAsync(long var1);
    }

    public static interface KnownSize
    extends IO {
        public long getSizeSync() throws IOException;

        public AsyncSupplier<Long, IOException> getSizeAsync();
    }

    public static interface Writable
    extends IO,
    WriterAsync {
        public IAsync<IOException> canStartWriting();

        public int writeSync(ByteBuffer var1) throws IOException;

        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer var1, Consumer<Pair<Integer, IOException>> var2);

        @Override
        default public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer) {
            return this.writeAsync(buffer, null);
        }

        public static interface Buffered
        extends Writable,
        WritableByteStream {
            public IAsync<IOException> flush();
        }

        public static interface Seekable
        extends Writable,
        net.lecousin.framework.io.IO$Seekable {
            public int writeSync(long var1, ByteBuffer var3) throws IOException;

            public AsyncSupplier<Integer, IOException> writeAsync(long var1, ByteBuffer var3, Consumer<Pair<Integer, IOException>> var4);

            default public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer) {
                return this.writeAsync(pos, buffer, null);
            }
        }
    }

    public static interface WriterAsync {
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer var1);

        default public AsyncConsumer<ByteBuffer, IOException> createConsumer(final Runnable onEnd, final Consumer<IOException> onError) {
            return new AsyncConsumer<ByteBuffer, IOException>(){

                @Override
                public IAsync<IOException> consume(ByteBuffer data) {
                    return this.writeAsync(data);
                }

                @Override
                public IAsync<IOException> end() {
                    onEnd.run();
                    return new Async<boolean>(true);
                }

                @Override
                public void error(IOException error) {
                    onError.accept(error);
                }
            };
        }
    }

    public static interface Readable
    extends IO {
        public IAsync<IOException> canStartReading();

        public int readSync(ByteBuffer var1) throws IOException;

        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer var1, Consumer<Pair<Integer, IOException>> var2);

        default public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer) {
            return this.readAsync(buffer, null);
        }

        public int readFullySync(ByteBuffer var1) throws IOException;

        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer var1, Consumer<Pair<Integer, IOException>> var2);

        default public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer) {
            return this.readFullyAsync(buffer, null);
        }

        public long skipSync(long var1) throws IOException;

        public AsyncSupplier<Long, IOException> skipAsync(long var1, Consumer<Pair<Long, IOException>> var3);

        default public AsyncSupplier<Long, IOException> skipAsync(long n) {
            return this.skipAsync(n, null);
        }

        default public AsyncProducer<ByteBuffer, IOException> createProducer(boolean closeOnEnd) {
            return this.createProducer(8192, false, closeOnEnd);
        }

        default public AsyncProducer<ByteBuffer, IOException> createProducer(int bufferSize, boolean readFully, boolean closeOnEnd) {
            ByteArrayCache cache = ByteArrayCache.getInstance();
            return () -> {
                ByteBuffer buffer = ByteBuffer.wrap((byte[])cache.get(bufferSize, true));
                AsyncSupplier<Integer, IOException> read = readFully ? this.readFullyAsync(buffer) : this.readAsync(buffer);
                AsyncSupplier production = new AsyncSupplier();
                read.onDone(nb -> {
                    if (nb <= 0) {
                        if (closeOnEnd) {
                            this.closeAsync();
                        }
                        production.unblockSuccess(null);
                        return;
                    }
                    production.unblockSuccess((ByteBuffer)buffer.flip());
                }, production);
                if (closeOnEnd) {
                    production.onError(error -> this.closeAsync());
                }
                return production;
            };
        }

        public static interface Buffered
        extends Readable,
        ReadableByteStream {
            public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> var1);

            default public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync() {
                return this.readNextBufferAsync(null);
            }

            public ByteBuffer readNextBuffer() throws IOException;

            public int readAsync() throws IOException;

            public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer var1, Consumer<Pair<Integer, IOException>> var2);

            default public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer) {
                return this.readFullySyncIfPossible(buffer, null);
            }

            @Override
            default public AsyncProducer<ByteBuffer, IOException> createProducer(boolean closeOnEnd) {
                return () -> {
                    AsyncSupplier<ByteBuffer, IOException> read = this.readNextBufferAsync();
                    if (closeOnEnd) {
                        read.onDone(() -> {
                            if (!read.isSuccessful() || read.getResult() == null) {
                                this.closeAsync();
                            }
                        });
                    }
                    return read;
                };
            }
        }

        public static interface Seekable
        extends Readable,
        net.lecousin.framework.io.IO$Seekable {
            public int readSync(long var1, ByteBuffer var3) throws IOException;

            public AsyncSupplier<Integer, IOException> readAsync(long var1, ByteBuffer var3, Consumer<Pair<Integer, IOException>> var4);

            default public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer) {
                return this.readAsync(pos, buffer, null);
            }

            public int readFullySync(long var1, ByteBuffer var3) throws IOException;

            public AsyncSupplier<Integer, IOException> readFullyAsync(long var1, ByteBuffer var3, Consumer<Pair<Integer, IOException>> var4);

            default public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer) {
                return this.readFullyAsync(pos, buffer, null);
            }
        }
    }

    public static interface Seekable
    extends PositionKnown {
        public long seekSync(SeekType var1, long var2) throws IOException;

        public AsyncSupplier<Long, IOException> seekAsync(SeekType var1, long var2, Consumer<Pair<Long, IOException>> var4);

        default public AsyncSupplier<Long, IOException> seekAsync(SeekType type, long move) {
            return this.seekAsync(type, move, null);
        }

        public static enum SeekType {
            FROM_BEGINNING,
            FROM_CURRENT,
            FROM_END;

        }
    }

    public static interface PositionKnown
    extends IO {
        public long getPosition() throws IOException;
    }

    public static enum OperationType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

