/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromOutputStream;

public abstract class IOAsOutputStream
extends OutputStream {
    public static OutputStream get(IO.Writable io) {
        if (io instanceof IOFromOutputStream) {
            return ((IOFromOutputStream)io).getOutputStream();
        }
        if (io instanceof IO.WritableByteStream) {
            return new ByteStream((IO.WritableByteStream)((Object)io));
        }
        return new Writable(io);
    }

    public abstract IO.Writable getWrappedIO();

    public static class ByteStream
    extends IOAsOutputStream {
        private IO.WritableByteStream io;

        public ByteStream(IO.WritableByteStream io) {
            this.io = io;
        }

        @Override
        public IO.Writable getWrappedIO() {
            return (IO.Writable)((Object)this.io);
        }

        @Override
        public void close() throws IOException {
            try {
                this.io.close();
            }
            catch (Exception e) {
                throw IO.error(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.io.write((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.io.write(b, off, len);
        }
    }

    public static class Writable
    extends IOAsOutputStream {
        private IO.Writable io;

        public Writable(IO.Writable io) {
            this.io = io;
        }

        @Override
        public IO.Writable getWrappedIO() {
            return this.io;
        }

        @Override
        public void close() throws IOException {
            try {
                this.io.close();
            }
            catch (Exception e) {
                throw IO.error(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)b);
            buffer.flip();
            this.io.writeSync(buffer);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            this.io.writeSync(buffer);
        }
    }
}

