/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.Pair;

public class IOFromInputStream
extends AbstractIO
implements IO.Readable {
    private InputStream stream;
    private TaskManager manager;

    public IOFromInputStream(InputStream stream, String sourceDescription, TaskManager manager, byte priority) {
        super(sourceDescription, priority);
        this.stream = stream;
        this.manager = manager;
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.manager;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return IOUtil.closeAsync(this.stream);
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.stream = null;
        ondone.unblock();
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        if (nb >= 0) {
            buffer.position(buffer.position() + nb);
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb;
        int total = 0;
        while ((nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position() + total, buffer.remaining() - total)) > 0 && (total += nb) < buffer.remaining()) {
        }
        buffer.position(buffer.position() + total);
        return total;
    }

    @Override
    public long skipSync(long n) throws IOException {
        int l;
        int nb;
        if (n <= 0L) {
            return 0L;
        }
        long total = 0L;
        byte[] b = new byte[n > 65536L ? 65536 : (int)n];
        while ((nb = this.stream.read(b, 0, l = n - total > 65536L ? 65536 : (int)(n - total))) > 0 && (total += (long)nb) < n) {
        }
        return total;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> t = new Task<Integer, IOException>(this.manager, "Read from InputStream", this.priority, ondone){

            @Override
            public Integer run() throws IOException, CancelException {
                try {
                    int nb = IOFromInputStream.this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    if (nb >= 0) {
                        buffer.position(buffer.position() + nb);
                    }
                    return nb;
                }
                catch (IOException e) {
                    if (IOFromInputStream.this.isClosing() || IOFromInputStream.this.isClosed()) {
                        throw IO.cancelClosed();
                    }
                    throw e;
                }
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> t = new Task<Integer, IOException>(this.manager, "Read from InputStream", this.priority, ondone){

            @Override
            public Integer run() throws IOException, CancelException {
                int nb;
                int total = 0;
                do {
                    try {
                        nb = IOFromInputStream.this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position() + total, buffer.remaining() - total);
                        if (nb <= 0) break;
                    }
                    catch (IOException e) {
                        if (IOFromInputStream.this.isClosing() || IOFromInputStream.this.isClosed()) {
                            throw IO.cancelClosed();
                        }
                        throw e;
                    }
                } while ((total += nb) < buffer.remaining());
                buffer.position(buffer.position() + total);
                return total;
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(final long n, Consumer<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(0L, null));
            }
            return new AsyncSupplier<Long, Object>(0L, null);
        }
        Task<Long, IOException> t = new Task<Long, IOException>(this.manager, "Skip from InputStream", this.priority, ondone){

            @Override
            public Long run() throws IOException, CancelException {
                int l;
                int nb;
                long total = 0L;
                byte[] b = new byte[n > 65536L ? 65536 : (int)n];
                do {
                    int n2 = l = n - total > 65536L ? 65536 : (int)(n - total);
                    if (!IOFromInputStream.this.isClosing() && !IOFromInputStream.this.isClosed()) continue;
                    throw IO.cancelClosed();
                } while ((nb = IOFromInputStream.this.stream.read(b, 0, l)) > 0 && (total += (long)nb) < n);
                return total;
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    public static class KnownSize
    extends IOFromInputStream
    implements IO.KnownSize {
        private long size;

        public KnownSize(InputStream stream, long size, String sourceDescription, TaskManager manager, byte priority) {
            super(stream, sourceDescription, manager, priority);
            this.size = size;
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncSupplier<Long, IOException> getSizeAsync() {
            return new AsyncSupplier<Long, Object>(this.size, null);
        }
    }
}

