/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.Pair;

public class IOFromOutputStream
extends AbstractIO
implements IO.Writable {
    private OutputStream stream;
    private TaskManager manager;

    public IOFromOutputStream(OutputStream stream, String sourceDescription, TaskManager manager, byte priority) {
        super(sourceDescription, priority);
        this.stream = stream;
        this.manager = manager;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.manager;
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb = buffer.remaining();
        if (buffer.hasArray()) {
            this.stream.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + nb);
        } else {
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            this.stream.write(buf);
        }
        return nb;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.writeAsyncUsingSync(this, buffer, ondone)).getOutput();
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return IOUtil.closeAsync(this.stream);
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.stream = null;
        ondone.unblock();
    }
}

