/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.tasks.drives.RemoveDirectoryTask;
import net.lecousin.framework.io.FileIO;

public final class TemporaryFiles {
    private Application app;
    private File tempDir;
    private String prefix;

    public static TemporaryFiles get() {
        return TemporaryFiles.get(LCCore.getApplication());
    }

    public static TemporaryFiles get(Application app) {
        TemporaryFiles instance = app.getInstance(TemporaryFiles.class);
        if (instance == null) {
            File dir = null;
            String path = app.getProperty("net.lecousin.application.tmpdir");
            if (path != null && !(dir = new File(path)).exists() && !dir.mkdirs()) {
                dir = null;
            }
            if (dir == null && (path = app.getProperty("java.io.tmpdir")) != null && !(dir = new File(path)).exists() && !dir.mkdirs()) {
                dir = null;
            }
            instance = new TemporaryFiles(app, dir);
        }
        return instance;
    }

    private TemporaryFiles(Application app, File dir) {
        block3: {
            this.app = app;
            this.tempDir = dir;
            try {
                this.prefix = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception t) {
                this.prefix = System.getenv("COMPUTERNAME");
                if (this.prefix == null || this.prefix.isEmpty()) {
                    this.prefix = System.getenv("HOSTNAME");
                }
                if (this.prefix != null) break block3;
                this.prefix = "";
            }
        }
        this.prefix = this.prefix.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
    }

    public void setTemporaryDirectory(File dir) throws IOException {
        if (!(dir == null || dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IOException("Unable to create temporary directory: " + dir.getAbsolutePath());
        }
        this.tempDir = dir;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public File createFileSync(String prefix, String suffix) throws IOException {
        File tmp = this.tempDir == null ? File.createTempFile(this.prefix + prefix, suffix) : File.createTempFile(this.prefix + prefix, suffix, this.tempDir);
        tmp.deleteOnExit();
        return tmp;
    }

    public AsyncSupplier<File, IOException> createFileAsync(final String prefix, final String suffix) {
        return new Task.OnFile<File, IOException>(this.tempDir, "Create temporary file", 4){

            @Override
            public File run() throws IOException {
                return TemporaryFiles.this.createFileSync(prefix, suffix);
            }
        }.start().getOutput();
    }

    public FileIO.ReadWrite createAndOpenFileSync(String prefix, String suffix) throws IOException {
        File f = this.createFileSync(prefix, suffix);
        return new FileIO.ReadWrite(f, 4);
    }

    public AsyncSupplier<FileIO.ReadWrite, IOException> createAndOpenFileAsync(final String prefix, final String suffix) {
        return new Task.OnFile<FileIO.ReadWrite, IOException>(this.tempDir, "Create temporary file", 4){

            @Override
            public FileIO.ReadWrite run() throws IOException {
                return TemporaryFiles.this.createAndOpenFileSync(prefix, suffix);
            }
        }.start().getOutput();
    }

    public File createDirectorySync(String prefix) throws IOException {
        Path path = Files.createTempDirectory(this.tempDir.toPath(), this.prefix + prefix, new FileAttribute[0]);
        File dir = path.toFile();
        this.app.toClose(() -> new RemoveDirectoryTask(dir, null, 0L, null, 4, false).start().getOutput());
        return dir;
    }

    public AsyncSupplier<File, IOException> createDirectoryAsync(final String prefix) {
        return new Task.OnFile<File, IOException>(this.tempDir, "Create temporary directory", 4){

            @Override
            public File run() throws IOException {
                return TemporaryFiles.this.createDirectorySync(prefix);
            }
        }.start().getOutput();
    }
}

