/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.map.LongMap;
import net.lecousin.framework.collections.map.LongMapRBT;
import net.lecousin.framework.collections.sort.OldestList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.async.ReadWriteLockPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.mutable.MutableBoolean;
import net.lecousin.framework.text.StringUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class BufferedIO
extends ConcurrentCloseable<IOException>
implements IO.Readable.Seekable,
IO.Readable.Buffered,
IO.KnownSize {
    protected MemoryManagement memory;
    protected IO.Readable.Seekable io;
    protected long position = 0L;
    protected long size;
    protected boolean closing = false;
    protected BufferTable bufferTable;
    protected boolean preLoadNextBuffer;
    protected int firstBufferSize;
    protected int bufferSize;

    public BufferedIO(IO.Readable.Seekable io, long size, int firstBufferSize, int nextBuffersSize, boolean preLoadNextBuffer) {
        this.io = io;
        try {
            this.position = io.getPosition();
        }
        catch (IOException e) {
            this.position = 0L;
        }
        this.memory = MemoryManagement.get();
        this.size = size;
        this.firstBufferSize = firstBufferSize;
        this.bufferSize = nextBuffersSize;
        this.preLoadNextBuffer = preLoadNextBuffer;
        long nbBuffers = size <= (long)firstBufferSize ? 1L : (size - (long)firstBufferSize) / (long)this.bufferSize + 2L;
        this.bufferTable = nbBuffers < 10000L ? new ArrayBufferTable((int)nbBuffers) : new MapBufferTable();
        if (preLoadNextBuffer) {
            this.preLoadBuffer(this.position);
        }
    }

    public BufferedIO(IO.Readable.Seekable io, int firstBufferSize, int nextBuffersSize, boolean preLoadNextBuffer) throws IOException {
        this(io, IOUtil.getSizeSync(io), firstBufferSize, nextBuffersSize, preLoadNextBuffer);
    }

    private void load(Buffer b) {
        int len;
        long pos = b.index == 0L ? 0L : (long)this.firstBufferSize + (long)this.bufferSize * (b.index - 1L);
        int n = len = this.size - pos < (long)b.data.length ? (int)(this.size - pos) : b.data.length;
        if (len == 0) {
            b.loaded.unblock();
            return;
        }
        AsyncSupplier<Integer, IOException> read = this.io.readFullyAsync(pos, ByteBuffer.wrap(b.data, 0, len));
        read.onDone(nb -> {
            if (nb != len) {
                b.loaded.error(new IOException("Only " + nb + " bytes read at " + pos + " but expected was " + len));
            } else {
                b.loaded.unblock();
            }
        }, (IAsync<IOException>)b.loaded);
    }

    protected long getBufferIndex(long pos) {
        if (pos < (long)this.firstBufferSize) {
            return 0L;
        }
        return (pos - (long)this.firstBufferSize) / (long)this.bufferSize + 1L;
    }

    protected int getBufferOffset(long pos) {
        if (pos < (long)this.firstBufferSize) {
            return (int)pos;
        }
        return (int)((pos - (long)this.firstBufferSize) % (long)this.bufferSize);
    }

    protected long getBufferPosition(long index) {
        if (index == 0L) {
            return 0L;
        }
        return (long)this.firstBufferSize + (index - 1L) * (long)this.bufferSize;
    }

    private IAsync<IOException> flush(Buffer b) {
        int len;
        long pos = this.getBufferPosition(b.index);
        if (pos + (long)(len = b.data.length) > this.size) {
            len = (int)(this.size - pos);
        }
        if (len == 0) {
            return new Async<boolean>(true);
        }
        return ((IO.Writable.Seekable)((Object)this.io)).writeAsync(pos, ByteBuffer.wrap(b.data, 0, len));
    }

    private IAsync<IOException> flush(LinkedList<Buffer> list, Predicate<Buffer> filter) {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        jp.addToJoin(list.size());
        this.flushNext(list, filter, jp, 0);
        jp.start();
        return jp;
    }

    private void flushNext(LinkedList<Buffer> list, Predicate<Buffer> filter, JoinPoint<IOException> jp, int recurs) {
        if (list.isEmpty()) {
            return;
        }
        Buffer b = list.removeFirst();
        Async<NoException> sp = b.usage.startWriteAsync();
        if (sp == null) {
            this.doFlush(b, jp, list, filter, recurs);
        } else {
            sp.thenStart(new Task.Cpu.FromRunnable("BufferedIO.flush", this.getPriority(), () -> this.doFlush(b, jp, list, filter, 0)), true);
        }
    }

    private void doFlush(Buffer b, JoinPoint<IOException> jp, LinkedList<Buffer> list, Predicate<Buffer> filter, int recurs) {
        if (!filter.test(b)) {
            b.usage.endWrite();
            jp.joined();
            this.flushNext(list, filter, jp, recurs + 1);
            return;
        }
        IAsync<IOException> flush = this.flush(b);
        flush.onDone(() -> {
            if (flush.isSuccessful()) {
                this.memory.flushed(b);
            }
            b.usage.endWrite();
            jp.joined();
        });
        if (recurs > 250) {
            new Task.Cpu.FromRunnable("BufferedIO.flush", this.getPriority(), () -> this.flushNext(list, filter, jp, 0)).start();
            return;
        }
        this.flushNext(list, filter, jp, recurs + 1);
    }

    protected void preLoadBuffer(long pos) {
        if (this.closing) {
            return;
        }
        if (pos == this.size) {
            return;
        }
        this.operation(new Task.Cpu.FromRunnable("Pre-load next buffer in BufferedIO", this.io.getPriority(), () -> {
            if (this.closing) {
                return;
            }
            long bufferIndex = this.getBufferIndex(pos);
            AsyncSupplier<Buffer, NoException> b = this.bufferTable.needBufferAsync(bufferIndex, false);
            b.onDone(() -> {
                ((Buffer)b.getResult()).lastRead = System.currentTimeMillis();
                ((Buffer)b.getResult()).usage.endRead();
            });
        })).start();
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        this.closing = true;
        Async<IOException> sp = new Async<IOException>();
        this.memory.close(this).onDone(() -> this.io.closeAsync().onDone(sp), sp);
        return sp;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        this.bufferTable = null;
        this.memory = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.io != null ? this.io.getPriority() : (byte)4;
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(this.size, null);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    private static boolean waitFor(Buffer b) throws IOException {
        b.loaded.block(0L);
        if (b.loaded.isCancelled()) {
            b.usage.endRead();
            return false;
        }
        if (b.loaded.hasError()) {
            b.usage.endRead();
            throw (IOException)b.loaded.getError();
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (this.position == this.size) {
            return -1;
        }
        long bufferIndex = this.getBufferIndex(this.position);
        Buffer b = this.bufferTable.needBufferSync(bufferIndex, false);
        if (!BufferedIO.waitFor(b)) {
            return -1;
        }
        byte r = b.data[this.getBufferOffset(this.position)];
        ++this.position;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (this.preLoadNextBuffer && this.position < this.size && this.getBufferIndex(this.position) != bufferIndex) {
            this.preLoadBuffer(this.position);
        }
        return r;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (this.position == this.size) {
            return -1;
        }
        long bufferIndex = this.getBufferIndex(this.position);
        Buffer b = this.bufferTable.needBufferSync(bufferIndex, false);
        if (!BufferedIO.waitFor(b)) {
            return -1;
        }
        int off = this.getBufferOffset(this.position);
        if (len > b.data.length - off) {
            len = b.data.length - off;
        }
        if (this.position + (long)len > this.size) {
            len = (int)(this.size - this.position);
        }
        System.arraycopy(b.data, off, buffer, offset, len);
        this.position += (long)len;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (this.preLoadNextBuffer && this.position < this.size && this.getBufferIndex(this.position) != bufferIndex) {
            this.preLoadBuffer(this.position);
        }
        return len;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (pos >= this.size) {
            return -1;
        }
        long bufferIndex = this.getBufferIndex(pos);
        Buffer b = this.bufferTable.needBufferSync(bufferIndex, false);
        if (!BufferedIO.waitFor(b)) {
            return -1;
        }
        int off = this.getBufferOffset(pos);
        int len = buffer.remaining();
        if (len > b.data.length - off) {
            len = b.data.length - off;
        }
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        buffer.put(b.data, off, len);
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (this.preLoadNextBuffer && (pos += (long)len) < this.size && this.getBufferIndex(pos) != bufferIndex) {
            this.preLoadBuffer(pos);
        }
        return len;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.readSync(this.position, buffer);
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (pos >= this.size) {
            return -1;
        }
        long bufferIndex = this.getBufferIndex(pos);
        Buffer b = this.bufferTable.needBufferSync(bufferIndex, false);
        if (!BufferedIO.waitFor(b)) {
            return -1;
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        long nextPos = pos + (long)(bufferIndex == 0L ? this.firstBufferSize : this.bufferSize);
        for (long count = 0L; nextPos < pos + (long)len && count < 5L; nextPos += (long)this.bufferSize, ++count) {
            this.preLoadBuffer(nextPos);
        }
        int off = this.getBufferOffset(pos);
        if (len > b.data.length - off) {
            len = b.data.length - off;
        }
        buffer.put(b.data, off, len);
        pos += (long)len;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (!buffer.hasRemaining()) {
            if (this.preLoadNextBuffer && pos + (long)len < this.size && this.getBufferIndex(pos + (long)len) != bufferIndex) {
                this.preLoadBuffer(pos + (long)len);
            }
            return len;
        }
        int total = len;
        while (pos != this.size) {
            bufferIndex = this.getBufferIndex(pos);
            b = this.bufferTable.needBufferSync(bufferIndex, false);
            if (!BufferedIO.waitFor(b)) {
                return total;
            }
            len = buffer.remaining();
            if (pos + (long)len > this.size) {
                len = (int)(this.size - pos);
            }
            off = this.getBufferOffset(pos);
            if (len > b.data.length - off) {
                len = b.data.length - off;
            }
            buffer.put(b.data, off, len);
            total += len;
            pos += (long)len;
            b.lastRead = System.currentTimeMillis();
            b.usage.endRead();
            if (buffer.hasRemaining()) continue;
        }
        if (this.preLoadNextBuffer && pos < this.size && this.getBufferIndex(pos) != bufferIndex) {
            this.preLoadBuffer(pos);
        }
        return total;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = this.readFullySync(this.position, buffer);
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        int nb = this.readFullySync(this.position, ByteBuffer.wrap(buffer));
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    @Override
    public IAsync<IOException> canStartReading() {
        if (this.position == this.size) {
            return new Async<boolean>(true);
        }
        if (this.closing) {
            return new Async<IOException>(new ClosedChannelException());
        }
        long bufferIndex = this.getBufferIndex(this.position);
        AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, false);
        if (getBuffer.isDone()) {
            Buffer b = getBuffer.getResult();
            b.usage.endRead();
            return b.loaded;
        }
        Async<IOException> sp = new Async<IOException>();
        getBuffer.onDone(() -> {
            Buffer b = (Buffer)getBuffer.getResult();
            b.lastRead = System.currentTimeMillis();
            b.loaded.onDone(sp);
            b.usage.endRead();
        });
        return sp;
    }

    private static <T> boolean checkLoaded(Buffer b, AsyncSupplier<T, IOException> result, Consumer<Pair<T, IOException>> ondone) {
        if (b.loaded.hasError()) {
            IOUtil.error(b.loaded.getError(), result, ondone);
            b.usage.endRead();
            return false;
        }
        if (b.loaded.isCancelled()) {
            result.cancel(b.loaded.getCancelEvent());
            b.usage.endRead();
            return false;
        }
        return true;
    }

    @Override
    public int readAsync() throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (this.position == this.size) {
            return -1;
        }
        long bufferIndex = this.getBufferIndex(this.position);
        AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, false);
        if (!getBuffer.isDone()) {
            getBuffer.onDone(() -> {
                Buffer b = (Buffer)getBuffer.getResult();
                b.lastRead = System.currentTimeMillis();
                b.usage.endRead();
            });
            return -2;
        }
        Buffer b = getBuffer.getResult();
        if (!b.loaded.isDone()) {
            b.lastRead = System.currentTimeMillis();
            b.usage.endRead();
            return -2;
        }
        if (b.loaded.isCancelled()) {
            b.usage.endRead();
            return -1;
        }
        if (b.loaded.hasError()) {
            b.usage.endRead();
            throw (IOException)b.loaded.getError();
        }
        byte r = b.data[this.getBufferOffset(this.position)];
        ++this.position;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (this.preLoadNextBuffer && this.position < this.size && this.getBufferIndex(this.position) != bufferIndex) {
            this.preLoadBuffer(this.position);
        }
        return r;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.closing) {
            return IOUtil.error(new ClosedChannelException(), ondone);
        }
        if (pos >= this.size) {
            return IOUtil.success(-1, ondone);
        }
        long bufferIndex = this.getBufferIndex(pos);
        AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, false);
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        this.readAsync(pos, buffer, getBuffer, ondone, result);
        return this.operation(result);
    }

    private void readAsync(long pos, ByteBuffer buffer, AsyncSupplier<Buffer, NoException> getBuffer, Consumer<Pair<Integer, IOException>> ondone, AsyncSupplier<Integer, IOException> result) {
        getBuffer.onDone(() -> {
            Buffer b = (Buffer)getBuffer.getResult();
            b.loaded.thenStart(new Task.Cpu.FromRunnable("BufferedIO.readAsync", this.io.getPriority(), () -> {
                if (!BufferedIO.checkLoaded(b, result, ondone)) {
                    return;
                }
                int off = this.getBufferOffset(pos);
                int len = buffer.remaining();
                long s = this.size;
                try {
                    if (len > b.data.length - off) {
                        len = b.data.length - off;
                    }
                    if (pos + (long)len > s) {
                        len = (int)(s - pos);
                    }
                    buffer.put(b.data, off, len);
                    b.lastRead = System.currentTimeMillis();
                }
                catch (Exception t) {
                    result.error(new IOException("Error reading from BufferedIO buffer at " + pos + " offset " + off + " len=" + len + " size=" + this.size + " (" + s + ") buffer len=" + (b.data != null ? Integer.toString(b.data.length) : null) + " remaining=" + buffer.remaining(), t));
                }
                finally {
                    b.usage.endRead();
                }
                if (this.preLoadNextBuffer && pos + (long)len < this.size && this.getBufferIndex(pos + (long)len) != b.index) {
                    this.preLoadBuffer(pos + (long)len);
                }
                Integer nb = len;
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(nb, null));
                }
                result.unblockSuccess(nb);
            }), true);
        });
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        if (this.closing) {
            return IOUtil.error(new ClosedChannelException(), ondone);
        }
        if (this.position >= this.size) {
            return IOUtil.success(null, ondone);
        }
        long bufferIndex = this.getBufferIndex(this.position);
        AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, false);
        AsyncSupplier<ByteBuffer, IOException> result = new AsyncSupplier<ByteBuffer, IOException>();
        this.readNextBufferAsync(getBuffer, ondone, result);
        return this.operation(result);
    }

    private void readNextBufferAsync(AsyncSupplier<Buffer, NoException> getBuffer, Consumer<Pair<ByteBuffer, IOException>> ondone, AsyncSupplier<ByteBuffer, IOException> result) {
        getBuffer.onDone(() -> {
            Buffer b = (Buffer)getBuffer.getResult();
            b.loaded.thenStart(new Task.Cpu.FromRunnable("BufferedIO.readNextBufferAsync", this.io.getPriority(), () -> {
                if (!BufferedIO.checkLoaded(b, result, ondone)) {
                    return;
                }
                ByteBuffer res = this.getBufferContent(b);
                if (ondone != null) {
                    ondone.accept(new Pair<ByteBuffer, Object>(res, null));
                }
                result.unblockSuccess(res);
            }), true);
        });
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (this.closing) {
            throw new ClosedChannelException();
        }
        if (this.position >= this.size) {
            return null;
        }
        long bufferIndex = this.getBufferIndex(this.position);
        Buffer b = this.bufferTable.needBufferSync(bufferIndex, false);
        try {
            b.loaded.blockThrow(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
        return this.getBufferContent(b);
    }

    private ByteBuffer getBufferContent(Buffer b) {
        long pos = this.position;
        int off = this.getBufferOffset(pos);
        int len = b.data.length - off;
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        ByteBuffer res = ByteBuffer.wrap(b.data, off, len).asReadOnlyBuffer();
        this.position = pos += (long)len;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (this.preLoadNextBuffer && pos < this.size && this.getBufferIndex(pos) != b.index) {
            this.preLoadBuffer(pos);
        }
        return res;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readFullySyncIfPossible(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.closing) {
            return IOUtil.error(new ClosedChannelException(), ondone);
        }
        if (pos >= this.size) {
            return IOUtil.success(-1, ondone);
        }
        long bufferIndex = this.getBufferIndex(pos);
        AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, false);
        if (!getBuffer.isDone()) {
            AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
            long p = pos;
            getBuffer.onDone(() -> {
                this.readFullyAsync(p, buffer, ondone).forward(result);
                Buffer b = (Buffer)getBuffer.getResult();
                b.usage.endRead();
            });
            return result;
        }
        Buffer b = getBuffer.getResult();
        if (!b.loaded.isDone()) {
            AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
            long p = pos;
            b.loaded.onDone(() -> {
                this.readFullyAsync(p, buffer, ondone).forward(result);
                b.usage.endRead();
            });
            return result;
        }
        if (b.loaded.hasError()) {
            IOException err = (IOException)b.loaded.getError();
            b.usage.endRead();
            return IOUtil.error(err, ondone);
        }
        if (b.loaded.isCancelled()) {
            AsyncSupplier<Object, Object> result = new AsyncSupplier<Object, Object>(null, null, b.loaded.getCancelEvent());
            b.usage.endRead();
            return result;
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        long nextPos = pos + (long)(bufferIndex == 0L ? this.firstBufferSize : this.bufferSize);
        for (long count = 0L; nextPos < pos + (long)len && count < 5L; nextPos += (long)this.bufferSize, ++count) {
            this.preLoadBuffer(nextPos);
        }
        int off = this.getBufferOffset(pos);
        if (len > b.data.length - off) {
            len = b.data.length - off;
        }
        buffer.put(b.data, off, len);
        pos += (long)len;
        b.lastRead = System.currentTimeMillis();
        b.usage.endRead();
        if (!buffer.hasRemaining()) {
            if (this.preLoadNextBuffer && pos < this.size && this.getBufferIndex(pos) != bufferIndex) {
                this.preLoadBuffer(pos);
            }
            Integer nb2 = len;
            if (ondone != null) {
                ondone.accept(new Pair<Integer, Object>(nb2, null));
            }
            return new AsyncSupplier<Integer, Object>(nb2, null);
        }
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        int l = len;
        this.readFullySyncIfPossible(pos, buffer, null).onDone(nb -> IOUtil.success(nb > 0 ? nb + l : l, result, ondone), error -> IOUtil.error(error, result, ondone), result::cancel);
        return result;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(this, pos, buffer, ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readFullyAsync(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public long skipSync(long n) {
        long prev = this.position;
        this.position += n;
        if (this.position > this.size) {
            this.position = this.size;
        }
        if (this.position < 0L) {
            this.position = 0L;
        }
        return this.position - prev;
    }

    @Override
    public int skip(int skip) {
        return (int)this.skipSync(skip);
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.skipSync(n), ondone);
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.position = move;
                break;
            }
            case FROM_END: {
                this.position = this.size - move;
                break;
            }
            case FROM_CURRENT: {
                this.position += move;
                break;
            }
        }
        if (this.position > this.size) {
            this.position = this.size;
        }
        if (this.position < 0L) {
            this.position = 0L;
        }
        return this.position;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.seekSync(type, move), ondone);
    }

    public static class ReadWrite
    extends BufferedIO
    implements IO.Writable.Seekable,
    IO.Writable.Buffered,
    IO.Resizable {
        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T io, long size, int firstBufferSize, int nextBuffersSize, boolean preLoadNextBuffer) {
            super(io, size, firstBufferSize, nextBuffersSize, preLoadNextBuffer);
        }

        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T io, int firstBufferSize, int nextBuffersSize, boolean preLoadNextBuffer) throws IOException {
            this(io, IOUtil.getSizeSync(io), firstBufferSize, nextBuffersSize, preLoadNextBuffer);
        }

        @Override
        public void write(byte value) throws IOException {
            if (this.closing) {
                throw new ClosedChannelException();
            }
            long bufferIndex = this.getBufferIndex(this.position);
            int off = this.getBufferOffset(this.position);
            Buffer b = this.bufferTable.needBufferSync(bufferIndex, this.position == this.size && off == 0);
            b.loaded.block(0L);
            if (b.loaded.hasError()) {
                throw (IOException)b.loaded.getError();
            }
            ((Buffer)b).data[off] = value;
            ++this.position;
            if (this.position > this.size) {
                this.size = this.position;
            }
            this.memory.toWrite(b);
            b.usage.endRead();
            if (this.preLoadNextBuffer && this.position < this.size && this.getBufferIndex(this.position) != bufferIndex) {
                this.preLoadBuffer(this.position);
            }
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            while (true) {
                if (this.closing) {
                    throw new ClosedChannelException();
                }
                long bufferIndex = this.getBufferIndex(this.position);
                int off = this.getBufferOffset(this.position);
                Buffer b = this.bufferTable.needBufferSync(bufferIndex, this.position == this.size && off == 0);
                b.loaded.block(0L);
                if (b.loaded.hasError()) {
                    throw (IOException)b.loaded.getError();
                }
                int len = b.data.length - off;
                if (len > length) {
                    len = length;
                }
                System.arraycopy(buffer, offset, b.data, off, len);
                this.position += (long)len;
                if (this.position > this.size) {
                    this.size = this.position;
                }
                this.memory.toWrite(b);
                b.usage.endRead();
                if (len == length) {
                    if (this.preLoadNextBuffer && this.position < this.size && this.getBufferIndex(this.position) != bufferIndex) {
                        this.preLoadBuffer(this.position);
                    }
                    return;
                }
                offset += len;
                length -= len;
            }
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            long bufferIndex;
            if (pos > this.size) {
                this.setSizeSync(pos);
            }
            int total = 0;
            do {
                if (this.closing) {
                    throw new ClosedChannelException();
                }
                bufferIndex = this.getBufferIndex(pos);
                int off = this.getBufferOffset(pos);
                Buffer b = this.bufferTable.needBufferSync(bufferIndex, pos == this.size && off == 0);
                b.loaded.block(0L);
                if (b.loaded.hasError()) {
                    throw (IOException)b.loaded.getError();
                }
                int len = buffer.remaining();
                if (len > b.data.length - off) {
                    len = b.data.length - off;
                }
                buffer.get(b.data, off, len);
                if ((pos += (long)len) > this.size) {
                    this.size = pos;
                }
                this.memory.toWrite(b);
                b.usage.endRead();
                total += len;
            } while (buffer.hasRemaining());
            if (this.preLoadNextBuffer && pos < this.size && this.getBufferIndex(pos) != bufferIndex) {
                this.preLoadBuffer(pos);
            }
            return total;
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            int nb = this.writeSync(this.position, buffer);
            if (nb > 0) {
                this.position += (long)nb;
            }
            return nb;
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return this.canStartReading();
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            if (this.closing) {
                return IOUtil.error(new ClosedChannelException(), ondone);
            }
            if (pos > this.size) {
                IAsync<IOException> resize = this.setSizeAsync(pos);
                AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
                resize.onDone(() -> {
                    if (resize.hasError()) {
                        IOUtil.error(resize.getError(), result, ondone);
                    } else {
                        this.writeAsync(pos, buffer, ondone).forward(result);
                    }
                });
                return result;
            }
            long bufferIndex = this.getBufferIndex(pos);
            AsyncSupplier<Buffer, NoException> getBuffer = this.bufferTable.needBufferAsync(bufferIndex, pos == this.size && this.getBufferOffset(pos) == 0);
            AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
            this.writeAsync(pos, buffer, getBuffer, ondone, result, 0);
            return this.operation(result);
        }

        private void writeAsync(long pos, ByteBuffer buffer, AsyncSupplier<Buffer, NoException> getBuffer, Consumer<Pair<Integer, IOException>> ondone, AsyncSupplier<Integer, IOException> result, int done) {
            getBuffer.onDone(() -> {
                Buffer b = (Buffer)getBuffer.getResult();
                b.loaded.thenStart(new Task.Cpu.FromRunnable("BufferedIO.writeAsync", this.io.getPriority(), () -> {
                    if (!BufferedIO.checkLoaded(b, result, ondone)) {
                        return;
                    }
                    int off = this.getBufferOffset(pos);
                    int len = buffer.remaining();
                    if (len > b.data.length - off) {
                        len = b.data.length - off;
                    }
                    buffer.get(b.data, off, len);
                    if (pos + (long)len > this.size) {
                        this.size = pos + (long)len;
                    }
                    this.memory.toWrite(b);
                    b.usage.endRead();
                    if (this.preLoadNextBuffer && pos + (long)len < this.size && this.getBufferIndex(pos + (long)len) != b.index) {
                        this.preLoadBuffer(pos + (long)len);
                    }
                    if (!buffer.hasRemaining()) {
                        IOUtil.success(len + done, result, ondone);
                    } else {
                        long bufferIndex = this.getBufferIndex(pos + (long)len);
                        AsyncSupplier<Buffer, NoException> getNextBuffer = this.bufferTable.needBufferAsync(bufferIndex, pos + (long)len == this.size && this.getBufferOffset(pos + (long)len) == 0);
                        this.writeAsync(pos + (long)len, buffer, getNextBuffer, ondone, result, done + len);
                    }
                }), true);
            });
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return this.writeAsync(this.position, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.position += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }

        @Override
        public void setSizeSync(long newSize) throws IOException {
            long nbBuffersAfter;
            long nbBuffersBefore = this.bufferTable.getNbBuffers();
            long l = nbBuffersAfter = newSize <= (long)this.firstBufferSize ? 1L : (newSize - (long)this.firstBufferSize) / (long)this.bufferSize + 2L;
            if (nbBuffersBefore == nbBuffersAfter) {
                if (newSize < this.size) {
                    Buffer b = this.bufferTable.needBufferSync(nbBuffersAfter - 1L, false);
                    b.usage.endRead();
                    b.usage.startWrite();
                    this.size = newSize;
                    b.usage.endWrite();
                } else {
                    this.size = newSize;
                }
                if (this.position > this.size) {
                    this.position = this.size;
                }
                ((IO.Resizable)((Object)this.io)).setSizeSync(newSize);
                return;
            }
            if (nbBuffersAfter > nbBuffersBefore) {
                ((IO.Resizable)((Object)this.io)).setSizeSync(newSize);
                this.size = newSize;
                this.bufferTable.setSize(nbBuffersAfter);
                if (this.position > this.size) {
                    this.position = this.size;
                }
                return;
            }
            this.bufferTable.setSize(nbBuffersAfter);
            this.size = newSize;
            ((IO.Resizable)((Object)this.io)).setSizeSync(newSize);
            if (this.position > this.size) {
                this.position = this.size;
            }
        }

        @Override
        public IAsync<IOException> setSizeAsync(long newSize) {
            long nbBuffersAfter;
            long nbBuffersBefore = this.bufferTable.getNbBuffers();
            long l = nbBuffersAfter = newSize <= (long)this.firstBufferSize ? 1L : (newSize - (long)this.firstBufferSize) / (long)this.bufferSize + 2L;
            if (nbBuffersBefore == nbBuffersAfter) {
                if (newSize < this.size) {
                    Buffer b = this.bufferTable.needBufferSync(nbBuffersAfter - 1L, false);
                    b.usage.endRead();
                    b.usage.startWrite();
                    this.size = newSize;
                    b.usage.endWrite();
                    if (this.position > this.size) {
                        this.position = this.size;
                    }
                    return ((IO.Resizable)((Object)this.io)).setSizeAsync(newSize);
                }
                this.size = newSize;
                if (this.position > this.size) {
                    this.position = this.size;
                }
                return ((IO.Resizable)((Object)this.io)).setSizeAsync(newSize);
            }
            if (nbBuffersAfter > nbBuffersBefore) {
                Async<IOException> sp = new Async<IOException>();
                ((IO.Resizable)((Object)this.io)).setSizeAsync(newSize).thenStart(new Task.Cpu.FromRunnable("BufferedIO.setSizeAsync", this.io.getPriority(), () -> {
                    this.size = newSize;
                    this.bufferTable.setSize(nbBuffersAfter);
                    if (this.position > this.size) {
                        this.position = this.size;
                    }
                    sp.unblock();
                }), sp);
                return sp;
            }
            Async<IOException> sp = new Async<IOException>();
            new Task.Cpu.FromRunnable("BufferedIO.setSizeAsync", this.io.getPriority(), () -> {
                this.bufferTable.setSize(nbBuffersAfter);
                ((IO.Resizable)((Object)this.io)).setSizeAsync(newSize).onDone(sp);
                this.size = newSize;
                if (this.position > this.size) {
                    this.position = this.size;
                }
                sp.unblock();
            }).start();
            return sp;
        }

        @Override
        public IAsync<IOException> flush() {
            return this.bufferTable.flush();
        }
    }

    private class MapBufferTable
    implements BufferTable {
        private LongMap<Buffer> map = new LongMapRBT<Buffer>(2500);
        private long nbBuffers = 0L;

        private MapBufferTable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Buffer initNeedBuffer(long index, boolean newAtTheEnd, MutableBoolean isNew) {
            Buffer b;
            MapBufferTable mapBufferTable = this;
            synchronized (mapBufferTable) {
                b = this.map.get(index);
                if (b == null) {
                    b = new Buffer();
                    b.owner = BufferedIO.this;
                    b.index = index;
                    Buffer.access$202(b, new byte[index == 0L ? BufferedIO.this.firstBufferSize : BufferedIO.this.bufferSize]);
                    b.usage.startRead();
                    this.map.put(index, b);
                    if (index + 1L > this.nbBuffers) {
                        this.nbBuffers = index + 1L;
                    }
                    isNew.set(true);
                } else {
                    b.lastRead = System.currentTimeMillis();
                }
            }
            if (isNew.get()) {
                BufferedIO.this.memory.newBuffer(b);
                if (newAtTheEnd) {
                    b.loaded.unblock();
                } else {
                    BufferedIO.this.load(b);
                }
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Buffer needBufferSync(long index, boolean newAtTheEnd) {
            MutableBoolean isNew = new MutableBoolean(false);
            Buffer b = this.initNeedBuffer(index, newAtTheEnd, isNew);
            if (isNew.get()) {
                return b;
            }
            b.usage.startRead();
            MapBufferTable mapBufferTable = this;
            synchronized (mapBufferTable) {
                if (this.map.get(index) == b) {
                    return b;
                }
            }
            b.usage.endRead();
            return this.needBufferSync(index, newAtTheEnd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncSupplier<Buffer, NoException> needBufferAsync(long index, boolean newAtTheEnd) {
            MutableBoolean isNew = new MutableBoolean(false);
            Buffer b = this.initNeedBuffer(index, newAtTheEnd, isNew);
            if (isNew.get()) {
                return new AsyncSupplier<Buffer, Object>(b, null);
            }
            Async<NoException> sp = b.usage.startReadAsync();
            if (sp == null || sp.isDone()) {
                MapBufferTable mapBufferTable = this;
                synchronized (mapBufferTable) {
                    if (this.map.get(index) == b) {
                        return new AsyncSupplier<Buffer, Object>(b, null);
                    }
                }
                b.usage.endRead();
                return this.needBufferAsync(index, newAtTheEnd);
            }
            AsyncSupplier<Buffer, NoException> result = new AsyncSupplier<Buffer, NoException>();
            sp.onDone(() -> {
                MapBufferTable mapBufferTable = this;
                synchronized (mapBufferTable) {
                    if (this.map.get(index) == b) {
                        result.unblockSuccess(b);
                        return;
                    }
                }
                b.usage.endRead();
                this.needBufferAsync(index, newAtTheEnd).forward(result);
            });
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Buffer buffer, boolean force) {
            while (true) {
                Async sp;
                MapBufferTable mapBufferTable = this;
                synchronized (mapBufferTable) {
                    if (this.map.get(buffer.index) != buffer) {
                        return true;
                    }
                    sp = buffer.usage.startWriteAsync();
                    if (sp == null) {
                        buffer.usage.endWrite();
                        sp = buffer.loaded;
                        if (sp.isDone()) {
                            if (buffer.lastWrite > 0L && !force) {
                                return false;
                            }
                            this.map.remove(buffer.index);
                            return true;
                        }
                        if (!force) {
                            return false;
                        }
                    } else {
                        sp.onDone(() -> buffer.usage.endWrite());
                        if (!force) {
                            return false;
                        }
                    }
                }
                sp.block(0L);
            }
        }

        @Override
        public long getNbBuffers() {
            return this.nbBuffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSize(long nbBuffersAfter) {
            Buffer lastPrevious;
            MapBufferTable mapBufferTable = this;
            synchronized (mapBufferTable) {
                if (nbBuffersAfter > this.nbBuffers) {
                    this.nbBuffers = nbBuffersAfter;
                    return;
                }
                lastPrevious = null;
                Iterator it = this.map.values();
                while (it.hasNext()) {
                    Buffer b = (Buffer)it.next();
                    if (b.index == nbBuffersAfter - 1L) {
                        lastPrevious = b;
                        continue;
                    }
                    if (b.index < nbBuffersAfter) continue;
                    this.remove(b, true);
                    BufferedIO.this.memory.removeReference(b);
                }
                this.nbBuffers = nbBuffersAfter;
            }
            if (lastPrevious != null) {
                lastPrevious.usage.startWrite();
                lastPrevious.usage.endWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsync<IOException> flush() {
            LinkedList<Buffer> toFlush = new LinkedList<Buffer>();
            MapBufferTable mapBufferTable = this;
            synchronized (mapBufferTable) {
                Iterator it = this.map.values();
                while (it.hasNext()) {
                    Buffer b2 = (Buffer)it.next();
                    if (b2.lastWrite <= 0L) continue;
                    toFlush.add(b2);
                }
            }
            return BufferedIO.this.flush(toFlush, b -> {
                MapBufferTable mapBufferTable = this;
                synchronized (mapBufferTable) {
                    return this.map.get(((Buffer)b).index) == b;
                }
            });
        }
    }

    private class ArrayBufferTable
    implements BufferTable {
        private Buffer[] buffers;

        private ArrayBufferTable(int nbBuffers) {
            this.buffers = new Buffer[nbBuffers];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Buffer initNeedBuffer(int i, boolean newAtTheEnd, MutableBoolean isNew) {
            Buffer b;
            ArrayBufferTable arrayBufferTable = this;
            synchronized (arrayBufferTable) {
                if (newAtTheEnd && i == this.buffers.length) {
                    Buffer[] newArray = new Buffer[i + 1];
                    System.arraycopy(this.buffers, 0, newArray, 0, this.buffers.length);
                    this.buffers = newArray;
                }
                if ((b = this.buffers[i]) == null) {
                    b = new Buffer();
                    b.owner = BufferedIO.this;
                    b.index = i;
                    Buffer.access$202(b, new byte[i == 0 ? BufferedIO.this.firstBufferSize : BufferedIO.this.bufferSize]);
                    b.usage.startRead();
                    this.buffers[i] = b;
                    isNew.set(true);
                } else {
                    b.lastRead = System.currentTimeMillis();
                }
            }
            if (isNew.get()) {
                BufferedIO.this.memory.newBuffer(b);
                if (newAtTheEnd) {
                    b.loaded.unblock();
                } else {
                    BufferedIO.this.load(b);
                }
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Buffer needBufferSync(long index, boolean newAtTheEnd) {
            int i = (int)index;
            MutableBoolean isNew = new MutableBoolean(false);
            Buffer b = this.initNeedBuffer(i, newAtTheEnd, isNew);
            if (isNew.get()) {
                return b;
            }
            b.usage.startRead();
            ArrayBufferTable arrayBufferTable = this;
            synchronized (arrayBufferTable) {
                if (this.buffers[i] == b) {
                    return b;
                }
            }
            b.usage.endRead();
            return this.needBufferSync(index, newAtTheEnd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncSupplier<Buffer, NoException> needBufferAsync(long index, boolean newAtTheEnd) {
            int i = (int)index;
            MutableBoolean isNew = new MutableBoolean(false);
            Buffer b = this.initNeedBuffer(i, newAtTheEnd, isNew);
            if (isNew.get()) {
                return new AsyncSupplier<Buffer, Object>(b, null);
            }
            Async<NoException> sp = b.usage.startReadAsync();
            if (sp == null || sp.isDone()) {
                ArrayBufferTable arrayBufferTable = this;
                synchronized (arrayBufferTable) {
                    if (this.buffers[i] == b) {
                        return new AsyncSupplier<Buffer, Object>(b, null);
                    }
                }
                b.usage.endRead();
                return this.needBufferAsync(index, newAtTheEnd);
            }
            AsyncSupplier<Buffer, NoException> result = new AsyncSupplier<Buffer, NoException>();
            sp.onDone(() -> {
                ArrayBufferTable arrayBufferTable = this;
                synchronized (arrayBufferTable) {
                    if (this.buffers[i] == b) {
                        result.unblockSuccess(b);
                        return;
                    }
                }
                b.usage.endRead();
                this.needBufferAsync(index, newAtTheEnd).forward(result);
            });
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Buffer buffer, boolean force) {
            while (true) {
                Async sp;
                ArrayBufferTable arrayBufferTable = this;
                synchronized (arrayBufferTable) {
                    int i = (int)buffer.index;
                    if (this.buffers[i] != buffer) {
                        return true;
                    }
                    sp = buffer.usage.startWriteAsync();
                    if (sp == null) {
                        buffer.usage.endWrite();
                        sp = buffer.loaded;
                        if (sp.isDone()) {
                            if (buffer.lastWrite > 0L && !force) {
                                return false;
                            }
                            this.buffers[i] = null;
                            return true;
                        }
                        if (!force) {
                            return false;
                        }
                    } else {
                        sp.onDone(() -> buffer.usage.endWrite());
                        if (!force) {
                            return false;
                        }
                    }
                }
                sp.block(0L);
            }
        }

        @Override
        public long getNbBuffers() {
            return this.buffers.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSize(long nbBuffersAfter) {
            int nbBuffersBefore = this.buffers.length;
            if (nbBuffersAfter > (long)nbBuffersBefore) {
                ArrayBufferTable arrayBufferTable = this;
                synchronized (arrayBufferTable) {
                    Buffer[] newArray = new Buffer[(int)nbBuffersAfter];
                    System.arraycopy(this.buffers, 0, newArray, 0, this.buffers.length);
                    this.buffers = newArray;
                }
                return;
            }
            ArrayBufferTable arrayBufferTable = this;
            synchronized (arrayBufferTable) {
                for (int i = (int)nbBuffersAfter; i < nbBuffersBefore; ++i) {
                    if (this.buffers[i] == null) continue;
                    Buffer b = this.buffers[i];
                    this.remove(b, true);
                    BufferedIO.this.memory.removeReference(b);
                }
                if (nbBuffersAfter > 0L && this.buffers[(int)(nbBuffersAfter - 1L)] != null) {
                    this.buffers[(int)(nbBuffersAfter - 1L)].usage.startWrite();
                }
                Buffer[] newArray = new Buffer[(int)nbBuffersAfter];
                System.arraycopy(this.buffers, 0, newArray, 0, newArray.length);
                this.buffers = newArray;
                if (nbBuffersAfter > 0L && this.buffers[(int)(nbBuffersAfter - 1L)] != null) {
                    this.buffers[(int)(nbBuffersAfter - 1L)].usage.endWrite();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsync<IOException> flush() {
            LinkedList<Buffer> toFlush = new LinkedList<Buffer>();
            ArrayBufferTable arrayBufferTable = this;
            synchronized (arrayBufferTable) {
                for (Buffer b2 : this.buffers) {
                    if (b2 == null || b2.lastWrite <= 0L) continue;
                    toFlush.add(b2);
                }
            }
            return BufferedIO.this.flush(toFlush, b -> {
                ArrayBufferTable arrayBufferTable = this;
                synchronized (arrayBufferTable) {
                    return this.buffers[(int)((Buffer)b).index] == b;
                }
            });
        }
    }

    private static interface BufferTable {
        public Buffer needBufferSync(long var1, boolean var3);

        public AsyncSupplier<Buffer, NoException> needBufferAsync(long var1, boolean var3);

        public boolean remove(Buffer var1, boolean var2);

        public void setSize(long var1);

        public long getNbBuffers();

        public IAsync<IOException> flush();
    }

    private static class Buffer {
        private BufferedIO owner;
        private long index;
        private byte[] data;
        private long lastRead = 0L;
        private long lastWrite = 0L;
        private Async<IOException> loaded = new Async();
        private ReadWriteLockPoint usage = new ReadWriteLockPoint();
        private Buffer next;
        private Buffer previous;

        private Buffer() {
        }

        static /* synthetic */ byte[] access$202(Buffer x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    public static class MemoryManagement
    implements IMemoryManageable {
        public static final int DEFAULT_MEMORY_THRESHOLD = 0x4800000;
        public static final int DEFAULT_MAX_MEMORY = 0x6000000;
        public static final int DEFAULT_TO_BE_WRITTEN_THRESHOLD = 0xC00000;
        private Background background = new Background();
        private Buffer head = null;
        private Buffer tail = null;
        private long usedMemory = 0L;
        private long maxMemory = 0x6000000L;
        private long memoryThreshold = 0x4800000L;
        private long toBeWritten = 0L;
        private long toBeWrittenThreshold = 0xC00000L;
        private long lastFree = 0L;

        public static long getMemoryThreshold() {
            return MemoryManagement.get().memoryThreshold;
        }

        public static long getMaxMemory() {
            return MemoryManagement.get().maxMemory;
        }

        public static long getToBeWrittenThreshold() {
            return MemoryManagement.get().toBeWrittenThreshold;
        }

        public static void setMemoryLimits(long memoryThreshold, long maxMemory, long toBeWrittenThreshold) {
            MemoryManagement instance = MemoryManagement.get();
            instance.maxMemory = maxMemory;
            instance.memoryThreshold = memoryThreshold;
            instance.toBeWrittenThreshold = toBeWrittenThreshold;
        }

        private static synchronized MemoryManagement get() {
            Application app = LCCore.getApplication();
            MemoryManagement instance = app.getInstance(MemoryManagement.class);
            if (instance == null) {
                instance = new MemoryManagement();
                app.setInstance(MemoryManagement.class, instance);
            }
            return instance;
        }

        private MemoryManagement() {
            this.background.start();
            MemoryManager.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newBuffer(Buffer b) {
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                if (this.head == null) {
                    this.head = this.tail = b;
                } else {
                    b.previous = this.tail;
                    this.tail.next = b;
                    this.tail = b;
                }
                this.usedMemory += (long)b.data.length;
                if (this.usedMemory > this.maxMemory) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastFree < 5000L) {
                        this.freeBuffers(50, true);
                    } else if (now - this.lastFree < 15000L) {
                        this.freeBuffers(25, true);
                    } else {
                        this.freeBuffers(10, true);
                    }
                    this.background.executeNextOccurenceNow((byte)3);
                } else if (this.usedMemory > this.memoryThreshold) {
                    this.background.executeNextOccurenceNow((byte)4);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toWrite(Buffer b) {
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                if (b.lastWrite == 0L) {
                    b.lastWrite = System.currentTimeMillis();
                    this.toBeWritten += (long)b.data.length;
                    if (this.toBeWritten >= this.toBeWrittenThreshold) {
                        this.background.executeNextOccurenceNow((byte)3);
                    }
                } else {
                    b.lastWrite = System.currentTimeMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IAsync<IOException> close(BufferedIO owner) {
            JoinPoint<IOException> jp = new JoinPoint<IOException>();
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                Buffer b = this.head;
                while (b != null) {
                    Buffer bb;
                    if (b.owner != owner) {
                        b = b.next;
                        continue;
                    }
                    if (b.previous == null) {
                        this.head = b.next;
                    } else {
                        b.previous.next = b.next;
                    }
                    if (b.next == null) {
                        this.tail = b.previous;
                    } else {
                        b.next.previous = b.previous;
                    }
                    jp.addToJoin(b.loaded);
                    Async<NoException> write = b.usage.startWriteAsync();
                    if (write == null) {
                        if (b.lastWrite == 0L) {
                            b.usage.endWrite();
                            this.usedMemory -= (long)b.data.length;
                        } else {
                            jp.addToJoin(1);
                            bb = b;
                            b.owner.flush(b).onDone(() -> {
                                bb.usage.endWrite();
                                MemoryManagement memoryManagement = this;
                                synchronized (memoryManagement) {
                                    this.usedMemory -= (long)bb.data.length;
                                }
                                jp.joined();
                            });
                        }
                    } else {
                        jp.addToJoin(1);
                        bb = b;
                        write.onDone(() -> {
                            if (bb.lastWrite == 0L) {
                                bb.usage.endWrite();
                                MemoryManagement memoryManagement = this;
                                synchronized (memoryManagement) {
                                    this.usedMemory -= (long)bb.data.length;
                                }
                                jp.joined();
                            } else {
                                bb.owner.flush(bb).onDone(() -> {
                                    bb.usage.endWrite();
                                    MemoryManagement memoryManagement = this;
                                    synchronized (memoryManagement) {
                                        this.usedMemory -= (long)bb.data.length;
                                    }
                                    jp.joined();
                                });
                            }
                        });
                    }
                    b = b.next;
                }
            }
            jp.start();
            return jp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void freeBuffers(int nb, boolean urgent) {
            long now = System.currentTimeMillis();
            OldestList<Buffer> oldest = new OldestList<Buffer>(nb);
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                Buffer b = this.head;
                while (b != null) {
                    if (!(((Buffer)b).owner.closing || b.usage.isUsed() || b.lastWrite > 0L || !urgent && now - b.lastRead < 2000L)) {
                        oldest.add(b.lastRead, b);
                    }
                    b = b.next;
                }
                for (Buffer b2 : oldest) {
                    if (((Buffer)b2).owner.closing || b2.usage.isUsed() || b2.lastWrite > 0L || !((Buffer)b2).owner.bufferTable.remove(b2, false)) continue;
                    if (b2.previous == null) {
                        this.head = b2.next;
                    } else {
                        b2.previous.next = b2.next;
                    }
                    if (b2.next == null) {
                        this.tail = b2.previous;
                    } else {
                        b2.next.previous = b2.previous;
                    }
                    this.usedMemory -= (long)b2.data.length;
                    Buffer.access$202(b2, null);
                }
                this.lastFree = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeReference(Buffer b) {
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                if (b.previous == null) {
                    this.head = b.next;
                } else {
                    b.previous.next = b.next;
                }
                if (b.next == null) {
                    this.tail = b.previous;
                } else {
                    b.next.previous = b.previous;
                }
                this.usedMemory -= (long)b.data.length;
                Buffer.access$202(b, null);
            }
        }

        @Override
        public String getDescription() {
            return "BufferedIO Memory Management";
        }

        @Override
        public List<String> getItemsDescription() {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add("Buffers: " + StringUtil.size(this.usedMemory));
            return list;
        }

        @Override
        public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
            this.background.executeNextOccurenceNow((byte)3);
            switch (level) {
                default: {
                    this.freeBuffers(5, false);
                    break;
                }
                case LOW: {
                    this.freeBuffers(10, false);
                    break;
                }
                case MEDIUM: {
                    this.freeBuffers(25, false);
                    break;
                }
                case URGENT: {
                    this.freeBuffers(200, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushed(Buffer b) {
            b.lastWrite = 0L;
            MemoryManagement memoryManagement = this;
            synchronized (memoryManagement) {
                this.toBeWritten -= (long)b.data.length;
            }
        }

        private class Background
        extends Task.Cpu<Void, NoException> {
            public Background() {
                super("BufferedIO Memory Management", (byte)6);
                this.executeEvery(30000L, 45000L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                this.setPriority((byte)6);
                long now = System.currentTimeMillis();
                int old1 = 0;
                int old2 = 0;
                OldestList<Buffer> oldestToBeWritten = null;
                if (MemoryManagement.this.toBeWritten >= MemoryManagement.this.toBeWrittenThreshold) {
                    oldestToBeWritten = new OldestList<Buffer>(32);
                }
                MemoryManagement memoryManagement = MemoryManagement.this;
                synchronized (memoryManagement) {
                    Buffer b = MemoryManagement.this.head;
                    while (b != null) {
                        if (!((Buffer)b).owner.closing && !b.usage.isUsed()) {
                            if (b.lastWrite > 0L) {
                                if (now - b.lastWrite >= 30000L) {
                                    this.flush(b);
                                } else if (oldestToBeWritten != null) {
                                    oldestToBeWritten.add(b.lastWrite, b);
                                }
                            } else if (now - b.lastRead > 300000L) {
                                ++old1;
                            } else if (now - b.lastRead > 900000L) {
                                ++old2;
                            }
                        }
                        b = b.next;
                    }
                }
                if (oldestToBeWritten != null) {
                    this.flushOldest(oldestToBeWritten);
                }
                if (now - MemoryManagement.this.lastFree > 300000L) {
                    MemoryManagement.this.freeBuffers(10, false);
                } else if (old2 > 0) {
                    MemoryManagement.this.freeBuffers(old2 > 10 ? old2 / 2 : 5, false);
                } else if (old1 > 5) {
                    MemoryManagement.this.freeBuffers(old1 / 2, false);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void flushOldest(OldestList<Buffer> oldestToBeWritten) {
                long target = MemoryManagement.this.toBeWritten - MemoryManagement.this.toBeWrittenThreshold + MemoryManagement.this.toBeWrittenThreshold / 10L;
                MemoryManagement memoryManagement = MemoryManagement.this;
                synchronized (memoryManagement) {
                    for (Buffer b : oldestToBeWritten) {
                        if (((Buffer)b).owner.closing || b.usage.isUsed() || b.lastWrite == 0L) continue;
                        if (this.flush(b)) {
                            target -= (long)b.data.length;
                        }
                        if (target >= 0L) continue;
                        break;
                    }
                }
            }

            private boolean flush(Buffer b) {
                Async<NoException> ready = b.usage.startWriteAsync();
                if (ready != null) {
                    ready.onDone(() -> b.usage.endWrite());
                    return false;
                }
                if (b.lastWrite == 0L) {
                    b.usage.endWrite();
                    return false;
                }
                IAsync flushing = b.owner.flush(b);
                flushing.onDone(() -> {
                    if (b.lastRead < b.lastWrite) {
                        b.lastRead = b.lastWrite;
                    }
                    if (flushing.isSuccessful()) {
                        MemoryManagement.this.flushed(b);
                    }
                    b.usage.endWrite();
                });
                return true;
            }
        }
    }
}

