/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.Pair;

public class ByteArrayIO
extends AbstractIO
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.Writable.Seekable,
IO.Writable.Buffered,
IO.KnownSize,
IO.Resizable {
    private byte[] array;
    private int pos;
    private int size;

    public ByteArrayIO(String description) {
        this(4096, description);
    }

    public ByteArrayIO(int initialSize, String description) {
        super(description, (byte)4);
        this.array = new byte[initialSize];
        this.size = 0;
        this.pos = 0;
    }

    public ByteArrayIO(byte[] data, String description) {
        super(description, (byte)4);
        this.array = data;
        this.pos = 0;
        this.size = data.length;
    }

    public ByteArrayIO(byte[] data, int bytesUsed, String description) {
        super(description, (byte)4);
        this.array = data;
        this.pos = 0;
        this.size = bytesUsed;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.size = 0;
        this.pos = 0;
        this.array = null;
        ondone.unblock();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(Long.valueOf(this.size), null);
    }

    @Override
    public int read() {
        if (this.pos == this.size) {
            return -1;
        }
        return this.array[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) {
        if (len > this.size - this.pos) {
            len = this.size - this.pos;
        }
        System.arraycopy(this.array, this.pos, buffer, offset, len);
        this.pos += len;
        return len;
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.pos == this.size) {
            throw new EOFException();
        }
        return this.array[this.pos++];
    }

    @Override
    public int readFully(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int readFullySync(ByteBuffer buffer) {
        int nb = this.readFullySync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) {
        int len;
        if (pos > (long)this.size) {
            pos = this.size;
        }
        if ((long)(len = buffer.remaining()) > (long)this.size - pos) {
            len = this.size - (int)pos;
        }
        if (len == 0) {
            return 0;
        }
        buffer.put(this.array, (int)pos, len);
        return len;
    }

    @Override
    public int readSync(ByteBuffer buffer) {
        return this.readFullySync(buffer);
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) {
        return this.readFullySync(pos, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.success(this.readFullySync(buffer), ondone);
    }

    @Override
    public int readAsync() {
        return this.read();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on ByteArrayIO", this.priority, ondone){

            @Override
            public Integer run() {
                return ByteArrayIO.this.readFullySync(buffer);
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on ByteArrayIO", this.priority, ondone){

            @Override
            public Integer run() {
                return ByteArrayIO.this.readFullySync(pos, buffer);
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(buffer, ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(pos, buffer, ondone);
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        if (this.pos == this.size) {
            return IOUtil.success(null, ondone);
        }
        Task.Cpu.FromSupplierThrows task = new Task.Cpu.FromSupplierThrows("Read remaining bytes from ByteArrayIO", this.getPriority(), ondone, this::readNextBuffer);
        this.operation(task.start());
        return this.operation(task.getOutput());
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (this.pos == this.size) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(this.array, this.pos, this.size - this.pos).asReadOnlyBuffer();
        this.pos = this.size;
        return buf;
    }

    public String getAsString(Charset charset) {
        return new String(this.array, 0, this.size, charset);
    }

    @Override
    public void write(byte b) {
        if (this.pos + 1 >= this.array.length) {
            byte[] a = new byte[Math.max(this.array.length * 2, this.pos + 1)];
            System.arraycopy(this.array, 0, a, 0, this.size);
            this.array = a;
        }
        this.array[this.pos++] = b;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int len) {
        if (this.pos + len > this.array.length) {
            int newSize;
            for (newSize = this.array.length * 2; newSize < this.pos + len; newSize *= 2) {
            }
            byte[] a = new byte[newSize];
            System.arraycopy(this.array, 0, a, 0, this.size);
            this.array = a;
        }
        System.arraycopy(buffer, offset, this.array, this.pos, len);
        this.pos += len;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    @Override
    public int writeSync(ByteBuffer buffer) {
        int len = buffer.remaining();
        if (this.pos + len > this.array.length) {
            int newSize;
            for (newSize = this.array.length * 2; newSize < this.pos + len; newSize *= 2) {
            }
            byte[] a = new byte[newSize];
            System.arraycopy(this.array, 0, a, 0, this.size);
            this.array = a;
        }
        buffer.get(this.array, this.pos, len);
        this.pos += len;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
        return len;
    }

    @Override
    public int writeSync(long pos, ByteBuffer buffer) {
        int len = buffer.remaining();
        if (pos + (long)len > (long)this.array.length) {
            int newSize = this.array.length * 2;
            while ((long)newSize < pos + (long)len) {
                newSize *= 2;
            }
            byte[] a = new byte[newSize];
            System.arraycopy(this.array, 0, a, 0, this.size);
            this.array = a;
        }
        buffer.get(this.array, (int)pos, len);
        if (pos + (long)len > (long)this.size) {
            this.size = (int)(pos + (long)len);
        }
        return len;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("writeAsync on ByteArrayIO", this.priority, ondone){

            @Override
            public Integer run() {
                return ByteArrayIO.this.writeSync(buffer);
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(final long pos, final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("writeAsync on ByteArrayIO", this.priority, ondone){

            @Override
            public Integer run() {
                return ByteArrayIO.this.writeSync(pos, buffer);
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public void setSizeSync(long newSize) {
        if (newSize <= (long)this.size) {
            this.size = (int)newSize;
            if (this.pos > this.size) {
                this.pos = this.size;
            }
        } else if (newSize <= (long)this.array.length) {
            this.size = (int)newSize;
        } else {
            byte[] a = new byte[(int)newSize];
            System.arraycopy(this.array, 0, a, 0, this.size);
            this.array = a;
            this.size = (int)newSize;
        }
    }

    public AsyncSupplier<Void, IOException> setSizeAsync(final long newSize) {
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("setSizeAsync on ByteArrayIO", this.priority){

            @Override
            public Void run() {
                ByteArrayIO.this.setSizeSync(newSize);
                return null;
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                if (move < 0L) {
                    move = 0L;
                }
                if (move > (long)this.size) {
                    this.pos = this.size;
                    break;
                }
                this.pos = (int)move;
                break;
            }
            case FROM_END: {
                if (move < 0L) {
                    move = 0L;
                }
                if (move > (long)this.size) {
                    this.pos = 0;
                    break;
                }
                this.pos = (int)((long)this.size - move);
                break;
            }
            case FROM_CURRENT: {
                this.pos += (int)move;
                if (this.pos < 0) {
                    this.pos = 0;
                    break;
                }
                if (this.pos <= this.size) break;
                this.pos = this.size;
                break;
            }
        }
        return this.pos;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.seekSync(type, move), ondone);
    }

    @Override
    public int skip(int skip) {
        if (skip < 0) {
            if (this.pos + skip < 0) {
                int done = this.pos;
                this.pos = 0;
                return -done;
            }
            this.pos += skip;
            return skip;
        }
        if (this.pos + skip > this.size) {
            int done = this.size - this.pos;
            this.pos = this.size;
            return done;
        }
        this.pos += skip;
        return skip;
    }

    @Override
    public long skipSync(long n) {
        return this.skip((int)n);
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.skipSync(n), ondone);
    }

    public byte[] getArray() {
        return this.array;
    }

    public int getCapacity() {
        return this.array.length;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.array, 0, this.size);
    }

    @Override
    public IAsync<IOException> flush() {
        return new Async<boolean>(true);
    }
}

