/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.TemporaryFiles;
import net.lecousin.framework.mutable.Mutable;
import net.lecousin.framework.util.Pair;

public class IOInMemoryOrFile
extends AbstractIO
implements IO.Readable.Seekable,
IO.Writable.Seekable,
IO.KnownSize,
IO.Resizable {
    private static final int BUFFER_SIZE = 8192;
    private int maxSizeInMemory;
    private long pos = 0L;
    private long size = 0L;
    private byte[][] memory;
    private FileIO.ReadWrite file = null;

    public IOInMemoryOrFile(int maxSizeInMemory, byte priority, String sourceDescription) {
        super(sourceDescription, priority);
        int nbBuffers = maxSizeInMemory / 8192;
        if (maxSizeInMemory % 8192 > 0) {
            ++nbBuffers;
        }
        this.maxSizeInMemory = nbBuffers * 8192;
        this.memory = new byte[nbBuffers][];
    }

    private void createFileSync() throws IOException {
        this.file = TemporaryFiles.get().createAndOpenFileSync("net.lecousin.framework", "tempIO");
    }

    private Async<IOException> createFileAsync() {
        Async<IOException> sp = new Async<IOException>();
        TemporaryFiles.get().createAndOpenFileAsync("net.lecousin.framework", "tempIO").onDone(f -> {
            this.file = f;
            sp.unblock();
        }, sp);
        return sp;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    public int getMaxInMemory() {
        return this.memory.length * 8192;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        if (this.file != null) {
            Async<IOException> sp = new Async<IOException>();
            this.file.closeAsync().onDone(() -> {
                if (!this.file.getFile().delete()) {
                    LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file: " + this.file.getFile().getAbsolutePath());
                }
                sp.unblock();
            }, sp);
            return sp;
        }
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.file = null;
        this.memory = null;
        ondone.unblock();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.pos = move;
                break;
            }
            case FROM_CURRENT: {
                this.pos += move;
                break;
            }
            case FROM_END: {
                this.pos = this.size - move;
                break;
            }
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        return this.pos;
    }

    @Override
    public long skipSync(long n) {
        long prevPos = this.pos;
        this.pos += n;
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        return this.pos - prevPos;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        this.seekSync(type, move);
        return IOUtil.success(this.pos, ondone);
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.skipSync(n), ondone);
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(this.size, null);
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb = this.writeSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += (long)nb;
        }
        return nb;
    }

    @Override
    public int writeSync(long pos, ByteBuffer buffer) throws IOException {
        int nb;
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            this.setSizeSync(pos);
        }
        int len = buffer.remaining();
        if (pos < (long)this.maxSizeInMemory) {
            int inFil;
            int l;
            int inMem = pos + (long)len <= (long)this.maxSizeInMemory ? len : (int)((long)this.maxSizeInMemory - pos);
            int p = (int)pos;
            int rem = inMem;
            do {
                int i = p / 8192;
                l = rem;
                int j = p % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (this.memory[i] == null) {
                    this.memory[i] = new byte[8192];
                }
                buffer.get(this.memory[i], j, l);
                p += l;
            } while ((rem -= l) > 0);
            if (pos + (long)len <= (long)this.maxSizeInMemory) {
                if ((long)p > this.size) {
                    this.size = p;
                }
                return len;
            }
            if (this.file == null) {
                this.createFileSync();
            }
            if ((inFil = this.file.writeSync(0L, buffer)) < len - inMem) {
                len = inMem + inFil;
            }
            if (pos + (long)len > this.size) {
                this.size = pos + (long)len;
            }
            return len;
        }
        if (this.file == null) {
            this.createFileSync();
        }
        if (pos + (long)(nb = this.file.writeSync(pos - (long)this.maxSizeInMemory, buffer)) > this.size) {
            this.size = pos + (long)nb;
        }
        return nb;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            IAsync resize = this.setSizeAsync(pos);
            AsyncSupplier result = new AsyncSupplier();
            long p = pos;
            IOUtil.listenOnDone(resize, res -> this.writeAsync(p, buffer, ondone).forward(result), result, ondone);
            return this.operation(result);
        }
        int len = buffer.remaining();
        if (pos < (long)this.maxSizeInMemory) {
            AsyncSupplier memReady;
            if (pos + (long)len <= (long)this.maxSizeInMemory) {
                WriteInMemory task = new WriteInMemory((int)pos, buffer, len, ondone);
                if (pos + (long)len > this.size) {
                    this.size = pos + (long)len;
                }
                task.start();
                return this.operation(task.getOutput());
            }
            WriteInMemory mem = new WriteInMemory((int)pos, buffer, (int)((long)this.maxSizeInMemory - pos), null);
            mem.start();
            if (this.file == null) {
                memReady = new AsyncSupplier();
                Async<IOException> createFile = this.createFileAsync();
                JoinPoint.fromSimilarError(mem.getOutput(), createFile).onDone(() -> memReady.unblockSuccess(mem.getOutput().getResult()), memReady);
            } else {
                memReady = mem.getOutput();
            }
            AsyncSupplier sp = new AsyncSupplier();
            Mutable<Object> fil = new Mutable<Object>(null);
            if (pos + (long)len > this.size) {
                this.size = pos + (long)len;
            }
            IOUtil.listenOnDone(memReady, res -> {
                fil.set(this.file.writeAsync(0L, buffer));
                IOUtil.listenOnDone((AsyncSupplier)fil.get(), result -> {
                    Integer r = (Integer)mem.getResult() + result;
                    if (ondone != null) {
                        ondone.accept(new Pair<Integer, Object>(r, null));
                    }
                    sp.unblockSuccess(r);
                }, (IAsync<IOException>)sp, ondone);
            }, sp, ondone);
            sp.onCancel(event -> {
                mem.cancel((CancelException)event);
                if (fil.get() != null) {
                    ((AsyncSupplier)fil.get()).unblockCancel((CancelException)event);
                }
            });
            return this.operation(sp);
        }
        if (this.file != null) {
            if (pos + (long)len > this.size) {
                this.size = pos + (long)len;
            }
            AsyncSupplier<Integer, IOException> task = this.file.writeAsync(pos - (long)this.maxSizeInMemory, buffer, ondone);
            return this.operation(task);
        }
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        long p = pos;
        this.createFileAsync().onDone(() -> {
            if (p + (long)len > this.size) {
                this.size = p + (long)len;
            }
            AsyncSupplier<Integer, IOException> task = this.file.writeAsync(p - (long)this.maxSizeInMemory, buffer, ondone);
            this.operation(task).forward(result);
        }, result);
        return result;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.writeAsync(this.pos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.pos += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public void setSizeSync(long newSize) throws IOException {
        if (newSize == this.size) {
            return;
        }
        if (newSize < this.size) {
            if (newSize <= (long)this.maxSizeInMemory) {
                if (this.file != null) {
                    File f = this.file.getFile();
                    this.file.closeAsync().onDone(() -> {
                        if (!f.delete()) {
                            LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file " + f.getAbsolutePath());
                        }
                    });
                    this.file = null;
                }
            } else {
                this.file.setSizeSync(newSize - (long)this.maxSizeInMemory);
            }
            this.size = newSize;
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            return;
        }
        if (this.size < (long)this.maxSizeInMemory) {
            int nbBuf = (int)(newSize / 8192L);
            if (newSize % 8192L != 0L) {
                ++nbBuf;
            }
            if (nbBuf > this.memory.length) {
                byte[][] n = new byte[nbBuf][];
                System.arraycopy(this.memory, 0, n, 0, this.memory.length);
                this.memory = n;
                for (int i = 0; i < this.memory.length; ++i) {
                    if (this.memory[i] != null) continue;
                    this.memory[i] = new byte[8192];
                }
            }
        }
        if (newSize > (long)this.maxSizeInMemory) {
            if (this.file == null) {
                this.createFileSync();
            }
            this.file.setSizeSync(newSize - (long)this.maxSizeInMemory);
        }
        this.size = newSize;
    }

    public AsyncSupplier<Void, IOException> setSizeAsync(long newSize) {
        if (newSize == this.size) {
            return new AsyncSupplier<Object, Object>(null, null);
        }
        if (newSize < this.size) {
            return this.shrinkSizeAsync(newSize);
        }
        return this.enlargeSizeAsync(newSize);
    }

    private AsyncSupplier<Void, IOException> shrinkSizeAsync(final long newSize) {
        if (newSize <= (long)this.maxSizeInMemory) {
            if (this.file != null) {
                File f = this.file.getFile();
                this.file.closeAsync().onDone(() -> {
                    if (!f.delete()) {
                        LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file " + f.getAbsolutePath());
                    }
                });
                this.file = null;
            }
            Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Shrink memory of IOInMemoryOrFile", this.getPriority()){

                @Override
                public Void run() {
                    int nbBuf = (int)(newSize / 8192L);
                    if (newSize % 8192L != 0L) {
                        ++nbBuf;
                    }
                    if (IOInMemoryOrFile.this.memory.length > nbBuf) {
                        byte[][] newMem = new byte[nbBuf][];
                        System.arraycopy(IOInMemoryOrFile.this.memory, 0, newMem, 0, nbBuf);
                        IOInMemoryOrFile.access$102(IOInMemoryOrFile.this, newMem);
                    }
                    IOInMemoryOrFile.this.size = newSize;
                    if (IOInMemoryOrFile.this.pos > IOInMemoryOrFile.this.size) {
                        IOInMemoryOrFile.this.pos = IOInMemoryOrFile.this.size;
                    }
                    return null;
                }
            };
            this.operation(task);
            task.start();
            return task.getOutput();
        }
        AsyncSupplier<Void, IOException> result = new AsyncSupplier<Void, IOException>();
        AsyncSupplier resize = (AsyncSupplier)this.operation(this.file.setSizeAsync(newSize - (long)this.maxSizeInMemory));
        resize.onDone(() -> {
            this.size = newSize;
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            result.unblockSuccess(null);
        }, result);
        return result;
    }

    private AsyncSupplier<Void, IOException> enlargeSizeAsync(final long newSize) {
        AsyncSupplier taskFile;
        AsyncSupplier taskMemory = null;
        if (this.size < (long)this.maxSizeInMemory) {
            Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Enlarge memory of IOInMemoryOrFile", this.getPriority()){

                @Override
                public Void run() {
                    int nbBuf = (int)(newSize / 8192L);
                    if (newSize % 8192L != 0L) {
                        ++nbBuf;
                    }
                    if (nbBuf > IOInMemoryOrFile.this.memory.length) {
                        byte[][] n = new byte[nbBuf][];
                        System.arraycopy(IOInMemoryOrFile.this.memory, 0, n, 0, IOInMemoryOrFile.this.memory.length);
                        IOInMemoryOrFile.access$102(IOInMemoryOrFile.this, n);
                        for (int i = 0; i < IOInMemoryOrFile.this.memory.length; ++i) {
                            if (IOInMemoryOrFile.this.memory[i] != null) continue;
                            ((IOInMemoryOrFile)IOInMemoryOrFile.this).memory[i] = new byte[8192];
                        }
                    }
                    return null;
                }
            };
            task.start();
            taskMemory = this.operation(task.getOutput());
        }
        if (newSize > (long)this.maxSizeInMemory) {
            if (this.file != null) {
                taskFile = (AsyncSupplier)this.operation(this.file.setSizeAsync(newSize - (long)this.maxSizeInMemory));
            } else {
                taskFile = new AsyncSupplier();
                this.createFileAsync().onDone(() -> ((AsyncSupplier)this.operation(this.file.setSizeAsync(newSize - (long)this.maxSizeInMemory))).forward(taskFile), taskFile);
            }
        } else {
            taskFile = null;
        }
        AsyncSupplier<Void, IOException> result = new AsyncSupplier<Void, IOException>();
        JoinPoint.fromSimilarError(taskMemory, taskFile).onDone(() -> {
            this.size = newSize;
            result.unblockSuccess(null);
        }, result);
        return result;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.readSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += (long)nb;
        }
        return nb;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        int nb;
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            return 0;
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        if (pos < (long)this.maxSizeInMemory) {
            int l;
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                len = (int)((long)this.maxSizeInMemory - pos);
            }
            int p = (int)pos;
            int rem = len;
            do {
                int i = p / 8192;
                l = rem;
                int j = p % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (this.memory[i] == null) {
                    throw new IOException("Try to read at " + pos + " but it was not written before !");
                }
                buffer.put(this.memory[i], j, l);
                p += l;
            } while ((rem -= l) > 0 && buffer.remaining() > 0);
            return len;
        }
        if (len < buffer.remaining()) {
            int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            nb = this.file.readSync(pos - (long)this.maxSizeInMemory, buffer);
            buffer.limit(limit);
        } else {
            nb = this.file.readSync(pos - (long)this.maxSizeInMemory, buffer);
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = this.readFullySync(this.pos, buffer);
        if (nb > 0) {
            this.pos += (long)nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return IOUtil.readFullySync(this, pos, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> task;
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            return IOUtil.success(0, ondone);
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        if (pos < (long)this.maxSizeInMemory) {
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                len = (int)((long)this.maxSizeInMemory - pos);
            }
            ReadInMemory task2 = new ReadInMemory((int)pos, len, buffer, ondone);
            this.operation(task2);
            task2.start();
            return task2.getOutput();
        }
        if (len < buffer.remaining()) {
            int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            task = this.file.readAsync(pos - (long)this.maxSizeInMemory, buffer, param -> {
                buffer.limit(limit);
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)param);
                }
            });
        } else {
            task = this.file.readAsync(pos - (long)this.maxSizeInMemory, buffer, ondone);
        }
        return this.operation(task);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.pos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.pos += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            return IOUtil.success(0, ondone);
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        Task mem = null;
        if (pos < (long)this.maxSizeInMemory) {
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                mem = new ReadInMemory((int)pos, (int)((long)this.maxSizeInMemory - pos), buffer, null);
                pos = this.maxSizeInMemory;
                len -= (int)((long)this.maxSizeInMemory - pos);
                this.operation(mem.start());
            } else {
                mem = this.operation(new ReadInMemory((int)pos, len, buffer, ondone));
                mem.start();
                return mem.getOutput();
            }
        }
        if (mem == null) {
            return this.readFromFile(pos - (long)this.maxSizeInMemory, len, buffer, ondone);
        }
        AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
        int l = len;
        Mutable<Object> fil = new Mutable<Object>(null);
        IOUtil.listenOnDone(mem.getOutput(), result -> {
            fil.set(this.operation(this.readFromFile(0L, l, buffer, null)));
            IOUtil.listenOnDone((AsyncSupplier)fil.get(), result2 -> {
                Integer r = result + result2;
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(r, null));
                }
                sp.unblockSuccess(r);
            }, (IAsync<IOException>)sp, ondone);
        }, sp, ondone);
        Task mm = mem;
        sp.onCancel(arg_0 -> IOInMemoryOrFile.lambda$readFullyAsync$18((ReadInMemory)mm, fil, arg_0));
        return sp;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readFullyAsync(this.pos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.pos += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    private AsyncSupplier<Integer, IOException> readFromFile(long pos, int len, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> task;
        if (len < buffer.remaining()) {
            int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            task = this.file.readFullyAsync(pos, buffer, param -> {
                buffer.limit(limit);
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)param);
                }
            });
        } else {
            task = this.file.readFullyAsync(pos, buffer, ondone);
        }
        return this.operation(task);
    }

    private static /* synthetic */ void lambda$readFullyAsync$18(ReadInMemory mm, Mutable fil, CancelException event) {
        mm.cancel(event);
        if (fil.get() != null) {
            ((AsyncSupplier)fil.get()).unblockCancel(event);
        }
    }

    static /* synthetic */ byte[][] access$102(IOInMemoryOrFile x0, byte[][] x1) {
        x0.memory = x1;
        return x1;
    }

    private class WriteInMemory
    extends Task.Cpu<Integer, IOException> {
        private int pos;
        private int len;
        private ByteBuffer buf;

        private WriteInMemory(int pos, ByteBuffer buf, int len, Consumer<Pair<Integer, IOException>> ondone) {
            super("IOInMemoryOrFile: writing in memory", IOInMemoryOrFile.this.priority, ondone);
            this.pos = pos;
            this.len = len;
            this.buf = buf;
        }

        @Override
        public Integer run() throws IOException {
            if (IOInMemoryOrFile.this.memory == null) {
                throw new IOException("IOInMemoryOrFile is already closed: " + IOInMemoryOrFile.this.getSourceDescription());
            }
            Integer result = this.len;
            do {
                int i = this.pos / 8192;
                int l = this.len;
                int j = this.pos % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (IOInMemoryOrFile.this.memory[i] == null) {
                    ((IOInMemoryOrFile)IOInMemoryOrFile.this).memory[i] = new byte[8192];
                }
                this.buf.get(IOInMemoryOrFile.this.memory[i], j, l);
                this.len -= l;
                this.pos += l;
            } while (this.len > 0);
            return result;
        }
    }

    private class ReadInMemory
    extends Task.Cpu<Integer, IOException> {
        private int pos;
        private int len;
        private ByteBuffer buf;

        private ReadInMemory(int pos, int len, ByteBuffer buf, Consumer<Pair<Integer, IOException>> ondone) {
            super("IOInMemoryOrFile: reading in memory", IOInMemoryOrFile.this.priority, ondone);
            this.pos = pos;
            this.len = len;
            this.buf = buf;
        }

        @Override
        public Integer run() throws IOException {
            if (IOInMemoryOrFile.this.memory == null) {
                throw new IOException("IOInMemoryOrFile is already closed: " + IOInMemoryOrFile.this.getSourceDescription());
            }
            Integer result = this.len;
            do {
                int i = this.pos / 8192;
                int l = this.len;
                int j = this.pos % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (IOInMemoryOrFile.this.memory[i] == null) {
                    throw new IOException("Try to read at " + this.pos + " but it was not written before !");
                }
                this.buf.put(IOInMemoryOrFile.this.memory[i], j, l);
                this.len -= l;
                this.pos += l;
            } while (this.len > 0 && this.buf.remaining() > 0);
            return result;
        }
    }
}

