/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.TwoBuffersIO;
import net.lecousin.framework.util.Pair;

public class MemoryIO
extends AbstractIO
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.Writable.Seekable,
IO.Writable.Buffered,
IO.KnownSize,
IO.Resizable {
    private int bufferSize;
    private byte[][] buffers = new byte[10][];
    private int pos = 0;
    private int size = 0;

    public MemoryIO(int bufferSize, String description) {
        super(description, (byte)4);
        this.bufferSize = bufferSize;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.size = -1;
        this.pos = -1;
        this.buffers = null;
        ondone.unblock();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public int read() {
        if (this.pos == this.size) {
            return -1;
        }
        int c = this.buffers[this.pos / this.bufferSize][this.pos % this.bufferSize] & 0xFF;
        ++this.pos;
        return c;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) {
        int index = this.pos / this.bufferSize;
        int bufferPos = this.pos % this.bufferSize;
        if (len > this.size - this.pos) {
            len = this.size - this.pos;
        }
        if (len > this.bufferSize - bufferPos) {
            len = this.bufferSize - bufferPos;
        }
        if (len == 0) {
            return 0;
        }
        System.arraycopy(this.buffers[index], bufferPos, buffer, offset, len);
        this.pos += len;
        return len;
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.pos == this.size) {
            throw new EOFException();
        }
        byte b = this.buffers[this.pos / this.bufferSize][this.pos % this.bufferSize];
        ++this.pos;
        return b;
    }

    @Override
    public int readFully(byte[] buffer) {
        if (this.pos == this.size) {
            return 0;
        }
        int index = this.pos / this.bufferSize;
        int bufferPos = this.pos % this.bufferSize;
        int remaining = buffer.length;
        int offset = 0;
        while (true) {
            int len;
            if ((len = remaining) > this.size - this.pos) {
                len = this.size - this.pos;
            }
            if (len > this.bufferSize - bufferPos) {
                len = this.bufferSize - bufferPos;
            }
            if (len == 0) {
                return offset;
            }
            System.arraycopy(this.buffers[index], bufferPos, buffer, offset, len);
            offset += len;
            this.pos += len;
            if (len == remaining || this.pos == this.size) {
                return offset;
            }
            remaining -= len;
            ++index;
            bufferPos = 0;
        }
    }

    @Override
    public int readSync(ByteBuffer buffer) {
        int nb = this.readSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) {
        int p = (int)pos;
        if (p > this.size) {
            p = this.size;
        }
        if (p == this.size) {
            return 0;
        }
        int index = p / this.bufferSize;
        int bufferPos = p % this.bufferSize;
        int len = buffer.remaining();
        if (len > this.size - p) {
            len = this.size - p;
        }
        if (len > this.bufferSize - bufferPos) {
            len = this.bufferSize - bufferPos;
        }
        buffer.put(this.buffers[index], bufferPos, len);
        return len;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) {
        int nb = this.readFullySync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) {
        int p = (int)pos;
        if (p > this.size) {
            p = this.size;
        }
        if (p == this.size) {
            return 0;
        }
        int index = p / this.bufferSize;
        int bufferPos = p % this.bufferSize;
        int offset = 0;
        while (true) {
            int len;
            if ((len = buffer.remaining()) > this.size - p) {
                len = this.size - p;
            }
            if (len > this.bufferSize - bufferPos) {
                len = this.bufferSize - bufferPos;
            }
            buffer.put(this.buffers[index], bufferPos, len);
            offset += len;
            if (buffer.remaining() == 0 || (p += len) == this.size) {
                return offset;
            }
            ++index;
            bufferPos = 0;
        }
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.success(this.readFullySync(buffer), ondone);
    }

    @Override
    public int readAsync() {
        return this.read();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone).getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, pos, buffer, ondone).getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsyncUsingSync(this, buffer, ondone).getOutput());
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsyncUsingSync(this, pos, buffer, ondone).getOutput());
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        if (this.pos == this.size) {
            return IOUtil.success(null, ondone);
        }
        Task.Cpu.FromSupplierThrows task = new Task.Cpu.FromSupplierThrows("Read next buffer", this.getPriority(), ondone, this::readNextBuffer);
        task.start();
        this.operation(task);
        return task.getOutput();
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (this.pos == this.size) {
            return null;
        }
        int index = this.pos / this.bufferSize;
        int len = this.size - this.pos;
        int bufferPos = this.pos % this.bufferSize;
        if (len > this.bufferSize - bufferPos) {
            len = this.bufferSize - bufferPos;
        }
        ByteBuffer buf = ByteBuffer.wrap(this.buffers[index], bufferPos, len).asReadOnlyBuffer();
        this.pos += len;
        return buf;
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(Long.valueOf(this.size), null);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                if (move < 0L) {
                    this.pos = 0;
                    break;
                }
                if (move > (long)this.size) {
                    this.pos = this.size;
                    break;
                }
                this.pos = (int)move;
                break;
            }
            case FROM_END: {
                if (move < 0L) {
                    this.pos = this.size;
                    break;
                }
                if (move > (long)this.size) {
                    this.pos = 0;
                    break;
                }
                this.pos = this.size - (int)move;
                break;
            }
            case FROM_CURRENT: {
                if (move < 0L) {
                    if ((long)this.pos + move < 0L) {
                        this.pos = 0;
                        break;
                    }
                    this.pos += (int)move;
                    break;
                }
                if ((long)this.pos + move > (long)this.size) {
                    this.pos = this.size;
                    break;
                }
                this.pos += (int)move;
                break;
            }
        }
        return this.pos;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.seekSync(type, move), ondone);
    }

    @Override
    public int skip(int skip) {
        if (skip < 0) {
            if (this.pos + skip < 0) {
                int done = -this.pos;
                this.pos = 0;
                return done;
            }
            this.pos += skip;
            return skip;
        }
        if (this.pos + skip > this.size) {
            int done = this.size - this.pos;
            this.pos = this.size;
            return done;
        }
        this.pos += skip;
        return skip;
    }

    @Override
    public long skipSync(long n) {
        if (n < 0L && n < Integer.MIN_VALUE) {
            n = Integer.MIN_VALUE;
        }
        if (n > 0L && n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        return this.skip((int)n);
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.skipSync(n), ondone);
    }

    private void increaseBuffers(int min) {
        byte[][] b = new byte[min >= this.buffers.length * 2 - 10 ? min + 10 : this.buffers.length * 2][];
        System.arraycopy(this.buffers, 0, b, 0, this.buffers.length);
        this.buffers = b;
    }

    @Override
    public void write(byte byt) {
        int index = this.pos / this.bufferSize;
        int bufferPos = this.pos % this.bufferSize;
        if (index >= this.buffers.length) {
            this.increaseBuffers(index);
        }
        if (this.buffers[index] == null) {
            for (int i = index; i >= 0 && this.buffers[i] == null; --i) {
                this.buffers[i] = new byte[this.bufferSize];
            }
        }
        this.buffers[index][bufferPos] = byt;
        if (++this.pos > this.size) {
            this.size = this.pos;
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        while (length > 0) {
            int len;
            int index = this.pos / this.bufferSize;
            int bufferPos = this.pos % this.bufferSize;
            if (index >= this.buffers.length) {
                this.increaseBuffers(index);
            }
            if (this.buffers[index] == null) {
                for (int i = index; i >= 0 && this.buffers[i] == null; --i) {
                    this.buffers[i] = new byte[this.bufferSize];
                }
            }
            if ((len = length) > this.bufferSize - bufferPos) {
                len = this.bufferSize - bufferPos;
            }
            System.arraycopy(buffer, offset, this.buffers[index], bufferPos, len);
            this.pos += len;
            offset += len;
            length -= len;
            if (this.pos <= this.size) continue;
            this.size = this.pos;
        }
    }

    @Override
    public int writeSync(ByteBuffer buffer) {
        int nb = this.writeSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int writeSync(long pos, ByteBuffer buffer) {
        int p = (int)pos;
        int done = 0;
        while (buffer.remaining() > 0) {
            int len;
            int index = p / this.bufferSize;
            int bufferPos = p % this.bufferSize;
            if (index >= this.buffers.length) {
                this.increaseBuffers(index);
            }
            if (this.buffers[index] == null) {
                for (int i = index; i >= 0 && this.buffers[i] == null; --i) {
                    this.buffers[i] = new byte[this.bufferSize];
                }
            }
            if ((len = buffer.remaining()) > this.bufferSize - bufferPos) {
                len = this.bufferSize - bufferPos;
            }
            buffer.get(this.buffers[index], bufferPos, len);
            done += len;
            if ((p += len) <= this.size) continue;
            this.size = p;
        }
        return done;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.writeAsyncUsingSync(this, buffer, ondone)).getOutput();
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.writeAsyncUsingSync(this, pos, buffer, ondone)).getOutput();
    }

    @Override
    public void setSizeSync(long newSize) {
        if (newSize == (long)this.size) {
            return;
        }
        if (newSize > (long)this.size) {
            this.size = (int)newSize;
            int index = this.size / this.bufferSize;
            if (index >= this.buffers.length) {
                this.increaseBuffers(index);
            }
            for (int i = index; i >= 0 && this.buffers[i] == null; --i) {
                this.buffers[i] = new byte[this.bufferSize];
            }
        } else {
            this.size = newSize < 0L ? 0 : (int)newSize;
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            int nbBuffers = this.size / this.bufferSize;
            if (this.size % this.bufferSize != 0) {
                ++nbBuffers;
            }
            for (int i = this.buffers.length - 1; i >= nbBuffers; --i) {
                this.buffers[i] = null;
            }
        }
    }

    public AsyncSupplier<Void, IOException> setSizeAsync(long newSize) {
        return this.operation(IOUtil.setSizeAsyncUsingSync(this, newSize, this.priority)).getOutput();
    }

    public static AsyncSupplier<IO.Readable.Seekable, IOException> from(IO.Readable io) {
        AsyncSupplier<IO.Readable.Seekable, IOException> sp = new AsyncSupplier<IO.Readable.Seekable, IOException>();
        if (io instanceof IO.KnownSize) {
            ((IO.KnownSize)((Object)io)).getSizeAsync().onDone(result -> {
                long size = result;
                TwoBuffersIO.DeterminedSize buf = new TwoBuffersIO.DeterminedSize(io, (int)size, 0);
                buf.canStartReading().onDone(() -> sp.unblockSuccess(buf));
            }, sp);
            return sp;
        }
        MemoryIO mem = new MemoryIO(32768, "MemoryIO: " + io.getSourceDescription());
        IOUtil.copy(io, mem, -1L, false, null, 0L).onDone(result -> {
            mem.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
            sp.unblockSuccess(mem);
        }, sp);
        return sp;
    }

    @Override
    public IAsync<IOException> flush() {
        return new Async<boolean>(true);
    }

    public Async<IOException> writeAsyncTo(IO.Writable io) {
        Async<IOException> sp = new Async<IOException>();
        this.writeAsyncTo(io, sp, 0);
        this.operation(sp);
        return sp;
    }

    private void writeAsyncTo(IO.Writable io, Async<IOException> sp, int bufferIndex) {
        int lastIndex = this.size / this.bufferSize;
        while (bufferIndex < lastIndex) {
            AsyncSupplier<Integer, IOException> write = io.writeAsync(ByteBuffer.wrap(this.buffers[bufferIndex]));
            if (!write.isDone()) {
                int i = bufferIndex;
                write.onDone(() -> {
                    if (write.hasError()) {
                        sp.error((IOException)write.getError());
                    } else if (write.isCancelled()) {
                        sp.cancel(write.getCancelEvent());
                    } else {
                        this.writeAsyncTo(io, sp, i + 1);
                    }
                });
                return;
            }
            if (write.hasError()) {
                sp.error(write.getError());
            } else if (write.isCancelled()) {
                sp.cancel(write.getCancelEvent());
            }
            if (sp.isDone()) {
                return;
            }
            ++bufferIndex;
        }
        int bufferPos = this.size % this.bufferSize;
        if (bufferPos == 0) {
            sp.unblock();
            return;
        }
        io.writeAsync(ByteBuffer.wrap(this.buffers[bufferIndex], 0, bufferPos)).onDone(sp);
    }
}

