/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFileTask;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.BufferedIO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class ReadableToSeekable
extends ConcurrentCloseable<IOException>
implements IO.Readable.Seekable,
IO.Readable.Buffered,
IO.KnownSize {
    private IO.Readable.Buffered io;
    private long ioPos = 0L;
    private long pos = 0L;
    private long knownSize = -1L;
    private File file;
    private BufferedIO.ReadWrite buffered;
    private AsyncSupplier<Boolean, IOException> buffering;
    private int bufferSize;

    public ReadableToSeekable(IO.Readable io, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        if (io instanceof IO.KnownSize) {
            this.knownSize = ((IO.KnownSize)((Object)io)).getSizeSync();
        }
        this.io = !(io instanceof IO.Readable.Buffered) ? new PreBufferedReadable(io, 512, io.getPriority(), bufferSize, io.getPriority(), 3) : (IO.Readable.Buffered)io;
        this.file = File.createTempFile("net.lecousin.framework", "ReedableToSeekable");
        this.file.deleteOnExit();
        FileIO.ReadWrite fio = new FileIO.ReadWrite(this.file, io.getPriority());
        this.buffered = new BufferedIO.ReadWrite(fio, 0L, 512, bufferSize, false);
        this.nextBuffer();
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        this.buffering.unblockCancel(new CancelException("IO closed"));
        jp.addToJoin(this.buffered.closeAsync());
        jp.addToJoin(this.io.closeAsync());
        jp.start();
        jp.thenStart(new RemoveFileTask(this.file, 6), true);
        return jp;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        this.buffered = null;
        ondone.unblock();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        if (this.pos < this.ioPos) {
            return this.buffered.canStartReading();
        }
        return this.buffering;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeSync() throws IOException {
        if (this.knownSize >= 0L) {
            return this.knownSize;
        }
        do {
            ReadableToSeekable readableToSeekable = this;
            synchronized (readableToSeekable) {
                if (this.knownSize >= 0L) {
                    return this.knownSize;
                }
                if (this.buffering.isDone()) {
                    this.nextBuffer();
                }
            }
            this.buffering.block(0L);
            if (!this.buffering.isCancelled()) continue;
            throw new IOException("IO closed");
        } while (this.buffering.isSuccessful());
        throw this.buffering.getError();
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        if (this.knownSize >= 0L) {
            sp.unblockSuccess(this.knownSize);
            return sp;
        }
        AsyncSupplier<Long, IOException> seek = this.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
        seek.onDone(result -> sp.unblockSuccess(this.knownSize), sp);
        sp.onCancel(seek::unblockCancel);
        return this.operation(seek);
    }

    private void nextBuffer() {
        if (this.knownSize == this.ioPos) {
            this.buffering = new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
            return;
        }
        this.buffering = new AsyncSupplier();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        AsyncSupplier<Integer, IOException> read = this.io.readFullyAsync(buffer);
        this.operation(read).onDone(result -> {
            if (result <= 0) {
                this.knownSize = this.ioPos;
                this.buffering.unblockSuccess(Boolean.TRUE);
                return;
            }
            buffer.flip();
            AsyncSupplier<Integer, IOException> write = this.buffered.writeAsync(this.ioPos, buffer);
            this.operation(write).onDone(result2 -> {
                int nb = result2;
                if (nb != result) {
                    this.buffering.unblockError(new IOException("Only " + nb + " bytes written in BufferedIO, " + result + " expected"));
                    return;
                }
                ReadableToSeekable readableToSeekable = this;
                synchronized (readableToSeekable) {
                    this.ioPos += (long)nb;
                    if (nb < 8192) {
                        if (this.knownSize >= 0L && this.knownSize != this.ioPos) {
                            LCCore.getApplication().getDefaultLogger().error("Unexpected end on ReadableToSeekable: known size is " + this.knownSize + ", but end reached at " + this.ioPos + " (" + nb + "/8192 bytes read)");
                        }
                        this.knownSize = this.ioPos;
                    }
                }
                this.buffering.unblockSuccess(nb < 8192);
            }, this.buffering);
        }, this.buffering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitPosition(long pos) throws IOException {
        while (pos >= this.ioPos) {
            if (this.knownSize == this.ioPos) {
                return false;
            }
            this.buffering.block(0L);
            if (pos < this.ioPos) break;
            ReadableToSeekable readableToSeekable = this;
            synchronized (readableToSeekable) {
                if (this.buffering.isDone()) {
                    if (this.buffering.isCancelled()) {
                        return false;
                    }
                    if (!this.buffering.isSuccessful()) {
                        throw this.buffering.getError();
                    }
                    if (this.buffering.getResult().booleanValue()) {
                        if (pos >= this.ioPos) {
                            return false;
                        }
                        break;
                    }
                    this.nextBuffer();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncSupplier<Boolean, IOException> bufferizeTo(final long pos) {
        if (pos < this.ioPos) {
            return null;
        }
        ReadableToSeekable readableToSeekable = this;
        synchronized (readableToSeekable) {
            if (pos < this.ioPos) {
                return null;
            }
            if (!this.buffering.isDone()) {
                if (pos < this.ioPos + 8192L) {
                    return this.buffering;
                }
            } else {
                boolean nextEnough = pos < this.ioPos + 8192L;
                this.nextBuffer();
                if (nextEnough) {
                    return this.buffering;
                }
            }
        }
        final AsyncSupplier sp = new AsyncSupplier();
        this.buffering.onDone(result -> {
            if (result.booleanValue()) {
                sp.unblockSuccess(null);
                return;
            }
            this.operation(new Task.Cpu<Void, NoException>("Bufferize in ReadableToSeekable", this.io.getPriority()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    ReadableToSeekable readableToSeekable = ReadableToSeekable.this;
                    synchronized (readableToSeekable) {
                        if (ReadableToSeekable.this.buffering.isDone()) {
                            ReadableToSeekable.this.nextBuffer();
                        }
                    }
                    AsyncSupplier next = ReadableToSeekable.this.bufferizeTo(pos);
                    if (next == null) {
                        sp.unblockSuccess(null);
                    } else {
                        next.onDone(result -> sp.unblockSuccess(null), sp);
                    }
                    return null;
                }
            }.start());
        }, sp);
        return this.operation(sp);
    }

    @Override
    public int read() throws IOException {
        if (!this.waitPosition(this.pos)) {
            return -1;
        }
        byte[] b = new byte[1];
        this.buffered.readSync(this.pos, ByteBuffer.wrap(b));
        ++this.pos;
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (!this.waitPosition(this.pos)) {
            return -1;
        }
        this.waitPosition(this.pos + (long)len - 1L);
        int nb = this.buffered.readFullySync(this.pos, ByteBuffer.wrap(buffer, offset, len));
        this.pos += (long)nb;
        return nb;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        this.readFullySyncIfPossible(buffer, 0, result, ondone);
        return result;
    }

    private void readFullySyncIfPossible(ByteBuffer buffer, int done, AsyncSupplier<Integer, IOException> result, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.knownSize >= 0L && this.pos >= this.knownSize) {
            IOUtil.success(done > 0 ? done : -1, result, ondone);
            return;
        }
        if (this.pos >= this.ioPos) {
            this.bufferizeTo(this.pos);
            if (done == 0) {
                this.readFullyAsync(buffer, ondone).forward(result);
                return;
            }
            this.readFullyAsync(buffer).onDone(read -> IOUtil.success(done + read, result, ondone), result);
            return;
        }
        AsyncSupplier<Integer, IOException> read2 = this.buffered.readFullySyncIfPossible(this.pos, buffer, null);
        read2.onDone(nb -> {
            this.pos += (long)nb.intValue();
            if (!buffer.hasRemaining()) {
                IOUtil.success(done + nb, result, ondone);
            } else {
                this.readFullySyncIfPossible(buffer, done + nb, result, ondone);
            }
        }, result);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.pos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.pos += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public int readAsync() throws IOException {
        if (this.knownSize >= 0L && this.pos >= this.knownSize) {
            return -1;
        }
        if (this.pos >= this.ioPos) {
            AsyncSupplier<Boolean, IOException> b = this.bufferizeTo(this.pos);
            if (b != null && b.hasError()) {
                throw b.getError();
            }
            return -2;
        }
        byte[] b = new byte[1];
        AsyncSupplier<Integer, IOException> r = this.buffered.readFullySyncIfPossible(this.pos, ByteBuffer.wrap(b), null);
        if (!r.isDone()) {
            return -2;
        }
        if (r.hasError()) {
            throw r.getError();
        }
        if (r.isCancelled()) {
            return -1;
        }
        if (r.getResult() <= 0) {
            return -1;
        }
        ++this.pos;
        return b[0] & 0xFF;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier result = new AsyncSupplier();
        AsyncSupplier<Boolean, IOException> bufferize = this.bufferizeTo(pos);
        Runnable onBuffered = () -> {
            if (bufferize != null) {
                if (bufferize.isCancelled()) {
                    result.unblockCancel(bufferize.getCancelEvent());
                    return;
                }
                if (bufferize.hasError()) {
                    IOUtil.error(bufferize.getError(), result, ondone);
                    return;
                }
            }
            AsyncSupplier<Integer, IOException> read = this.buffered.readAsync(pos, buffer);
            IOUtil.listenOnDone(read, res -> {
                int nb = res;
                if (nb <= 0 && this.knownSize >= 0L && pos < this.knownSize) {
                    LCCore.getApplication().getDefaultLogger().error("Unexpected end on ReadableToSeekable: no byte read at " + pos + " but knownSize is " + this.knownSize);
                }
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>((Integer)res, null));
                }
                result.unblockSuccess(res);
            }, (IAsync<IOException>)result, ondone);
        };
        if (bufferize == null) {
            onBuffered.run();
        } else {
            bufferize.onDone(onBuffered);
        }
        return this.operation(result);
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(final Consumer<Pair<ByteBuffer, IOException>> ondone) {
        final AsyncSupplier<ByteBuffer, IOException> result = new AsyncSupplier<ByteBuffer, IOException>();
        final AsyncSupplier<Boolean, IOException> bufferize = this.bufferizeTo(this.pos);
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Read next buffer", this.getPriority()){

            @Override
            public Void run() {
                if (bufferize != null) {
                    if (bufferize.isCancelled()) {
                        result.unblockCancel(bufferize.getCancelEvent());
                        return null;
                    }
                    if (!bufferize.isSuccessful()) {
                        IOUtil.error(bufferize.getError(), result, ondone);
                        return null;
                    }
                }
                ByteBuffer buffer = ByteBuffer.allocate(ReadableToSeekable.this.bufferSize);
                AsyncSupplier<Integer, IOException> read = ReadableToSeekable.this.buffered.readAsync(ReadableToSeekable.this.pos, buffer);
                IOUtil.listenOnDone(read, res -> {
                    int nb = res;
                    if (nb > 0) {
                        ReadableToSeekable.this.pos = ReadableToSeekable.this.pos + (long)nb;
                        buffer.flip();
                        if (ondone != null) {
                            ondone.accept(new Pair<ByteBuffer, Object>(buffer, null));
                        }
                        result.unblockSuccess(buffer);
                    } else {
                        if (ondone != null) {
                            ondone.accept(new Pair<Object, Object>(null, null));
                        }
                        result.unblockSuccess(null);
                    }
                }, (IAsync<IOException>)result, ondone);
                return null;
            }
        };
        this.operation(task);
        if (bufferize == null) {
            task.start();
        } else {
            bufferize.thenStart(task, true);
        }
        return result;
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (!this.waitPosition(this.pos)) {
            return null;
        }
        ByteBuffer buf = this.buffered.readNextBuffer();
        if (buf != null) {
            this.pos += (long)buf.remaining();
        }
        return buf;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(this, buffer, ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(this, pos, buffer, ondone);
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = this.readFullySync(this.pos, buffer);
        if (nb > 0) {
            this.pos += (long)nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        int len = buffer.remaining();
        if (this.knownSize != -1L && pos + (long)len > this.knownSize) {
            len = (int)(this.knownSize - pos);
        }
        this.waitPosition(pos + (long)len - 1L);
        if (pos >= this.ioPos) {
            return -1;
        }
        return this.buffered.readFullySync(pos, buffer);
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.readSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += (long)nb;
        }
        return nb;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (!this.waitPosition(pos)) {
            return -1;
        }
        return this.buffered.readSync(pos, buffer);
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(final IO.Seekable.SeekType type, final long move, Consumer<Pair<Long, IOException>> ondone) {
        Task.Cpu<Long, IOException> task = new Task.Cpu<Long, IOException>("Seeking in non-seekable", this.io.getPriority(), ondone){

            @Override
            public Long run() throws IOException {
                return ReadableToSeekable.this.seekSync(type, move);
            }

            @Override
            public long getMaxBlockingTimeInNanoBeforeToLog() {
                return Long.MAX_VALUE;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_BEGINNING: {
                if (move < 0L) {
                    move = 0L;
                }
                this.waitPosition(move);
                if (move > this.ioPos) {
                    this.pos = this.ioPos;
                    break;
                }
                this.pos = move;
                break;
            }
            case FROM_CURRENT: {
                long newPos = this.pos + move;
                if (newPos < 0L) {
                    newPos = 0L;
                }
                this.waitPosition(newPos);
                if (newPos > this.ioPos) {
                    this.pos = this.ioPos;
                    break;
                }
                this.pos = newPos;
                break;
            }
            case FROM_END: {
                long newPos;
                if (move < 0L) {
                    move = 0L;
                }
                if (this.knownSize < 0L) {
                    this.getSizeSync();
                }
                if ((newPos = this.knownSize - move) < 0L) {
                    newPos = 0L;
                }
                if (newPos > this.knownSize) {
                    newPos = this.knownSize;
                }
                this.waitPosition(newPos);
                if (newPos > this.ioPos) {
                    this.pos = this.ioPos;
                    break;
                }
                this.pos = newPos;
                break;
            }
        }
        return this.pos;
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    @Override
    public long skipSync(long n) throws IOException {
        long prevPos = this.pos;
        long newPos = this.pos + n;
        if (newPos < 0L) {
            newPos = 0L;
        }
        this.waitPosition(newPos);
        this.pos = newPos > this.ioPos ? this.ioPos : newPos;
        return this.pos - prevPos;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(final long move, Consumer<Pair<Long, IOException>> ondone) {
        Task.Cpu<Long, IOException> task = new Task.Cpu<Long, IOException>("Seeking in non-seekable", this.io.getPriority(), ondone){

            @Override
            public Long run() throws IOException {
                return ReadableToSeekable.this.skipSync(move);
            }

            @Override
            public long getMaxBlockingTimeInNanoBeforeToLog() {
                return Long.MAX_VALUE;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }
}

