/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.ThreadUtil;

public class TwoBuffersIO
extends ConcurrentCloseable<IOException>
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.KnownSize {
    private IO.Readable io;
    protected byte[] buf1;
    protected byte[] buf2;
    private int nb1 = -1;
    private int nb2 = -1;
    private AsyncSupplier<Integer, IOException> read1;
    private AsyncSupplier<Integer, IOException> read2;
    protected int pos = 0;

    public TwoBuffersIO(IO.Readable io, int firstBuffer, int secondBuffer) {
        this.io = io;
        this.buf1 = new byte[firstBuffer];
        this.read1 = io.readFullyAsync(ByteBuffer.wrap(this.buf1));
        this.operation(this.read1);
        if (secondBuffer > 0) {
            this.buf2 = new byte[secondBuffer];
            this.read1.onSuccess(() -> {
                int nb = this.read1.getResult();
                int n = this.nb1 = nb > 0 ? nb : 0;
                if (nb < this.buf1.length) {
                    this.buf2 = null;
                    this.nb2 = 0;
                    this.read2 = new AsyncSupplier<Integer, Object>(0, null);
                } else {
                    this.read2 = io.readFullyAsync(ByteBuffer.wrap(this.buf2));
                    this.operation(this.read2);
                }
                byte[] byArray = this.buf1;
                synchronized (this.buf1) {
                    this.buf1.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            });
        }
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        this.buf1 = null;
        this.buf2 = null;
        ondone.unblock();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        if (this.nb1 < 0 || this.pos < this.nb1 || this.buf2 == null) {
            return this.read1;
        }
        if (this.read2 == null) {
            this.waitRead2();
        }
        return this.read2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRead2() {
        byte[] byArray = this.buf1;
        synchronized (this.buf1) {
            while (this.read2 == null && ThreadUtil.wait(this.buf1, 0L)) {
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void needRead1() throws IOException {
        if (!this.read1.isDone()) {
            this.read1.block(0L);
        }
        if (!this.read1.isSuccessful()) {
            if (this.read1.isCancelled()) {
                throw IO.errorCancelled(this.read1.getCancelEvent());
            }
            throw this.read1.getError();
        }
        this.nb1 = this.read1.getResult();
        if (this.nb1 < 0) {
            this.nb1 = 0;
        }
    }

    private void needRead2() throws IOException {
        if (this.read2 == null) {
            this.waitRead2();
        }
        if (!this.read2.isDone()) {
            this.read2.block(0L);
        }
        if (!this.read2.isSuccessful()) {
            if (this.read2.isCancelled()) {
                throw IO.errorCancelled(this.read2.getCancelEvent());
            }
            throw this.read2.getError();
        }
        this.nb2 = this.read2.getResult();
        if (this.nb2 < 0) {
            this.nb2 = 0;
        }
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            return this.buf1[this.pos++] & 0xFF;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        return this.buf2[this.pos++ - this.nb1] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            int l = this.nb1 - this.pos;
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.buf1, this.pos, buffer, offset, l);
            this.pos += l;
            return l;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        int l = this.nb1 + this.nb2 - this.pos;
        if (l > len) {
            l = len;
        }
        System.arraycopy(this.buf2, this.pos - this.nb1, buffer, offset, l);
        this.pos += l;
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        int l;
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.length;
        int offset = 0;
        int done = 0;
        if (this.pos < this.nb1) {
            l = this.nb1 - this.pos;
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.buf1, this.pos, buffer, 0, l);
            this.pos += l;
            if (l == len) {
                return l;
            }
            offset += l;
            len -= l;
            done = l;
        }
        if (this.buf2 == null) {
            return done > 0 ? done : -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return done > 0 ? done : -1;
        }
        l = this.nb1 + this.nb2 - this.pos;
        if (l > len) {
            l = len;
        }
        System.arraycopy(this.buf2, this.pos - this.nb1, buffer, offset, l);
        this.pos += l;
        return l + done;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.readSync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.remaining();
        if (pos < (long)this.nb1) {
            int l = this.nb1 - (int)pos;
            if (l > len) {
                l = len;
            }
            buffer.put(this.buf1, (int)pos, l);
            return l;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            return -1;
        }
        int l = this.nb1 + this.nb2 - (int)pos;
        if (l > len) {
            l = len;
        }
        buffer.put(this.buf2, (int)pos - this.nb1, l);
        return l;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        int l;
        if (this.nb1 < 0) {
            return this.readFullyAsync(buffer, ondone);
        }
        int len = buffer.remaining();
        int done = 0;
        if (this.pos < this.nb1) {
            l = this.nb1 - this.pos;
            if (l > len) {
                l = len;
            }
            buffer.put(this.buf1, this.pos, l);
            this.pos += l;
            if (l == len) {
                return IOUtil.success(l, ondone);
            }
            len -= l;
            done = l;
        }
        if (this.buf2 == null) {
            return IOUtil.success(done > 0 ? done : -1, ondone);
        }
        if (this.nb2 < 0) {
            if (done == 0) {
                return this.readFullyAsync(buffer, ondone);
            }
            AsyncSupplier<Integer, IOException> r = new AsyncSupplier<Integer, IOException>();
            int d = done;
            this.readFullyAsync(buffer, (Pair<Integer, IOException> res) -> {
                if (ondone != null) {
                    if (res.getValue1() != null) {
                        ondone.accept(new Pair<Integer, Object>(d + (Integer)res.getValue1(), null));
                    } else {
                        ondone.accept(res);
                    }
                }
            }).onDone(nb -> r.unblockSuccess(nb + d), r);
            return r;
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return IOUtil.success(done > 0 ? done : -1, ondone);
        }
        l = this.nb1 + this.nb2 - this.pos;
        if (l > len) {
            l = len;
        }
        buffer.put(this.buf2, this.pos - this.nb1, l);
        this.pos += l;
        return IOUtil.success(l + done, ondone);
    }

    private <T> AsyncSupplier<T, IOException> needRead1Async(Callable<T> onReady, Consumer<Pair<T, IOException>> ondone) {
        if (!this.read1.isDone()) {
            AsyncSupplier sp = new AsyncSupplier();
            IOUtil.listenOnDone(this.read1, new Task.Cpu.FromRunnable("TwoBuffersIO.needRead1Async", this.io.getPriority(), () -> {
                try {
                    IOUtil.success(onReady.call(), sp, ondone);
                }
                catch (Exception e) {
                    IOUtil.error(IO.error(e), sp, ondone);
                }
            }), sp, ondone);
            return this.operation(sp);
        }
        if (!this.read1.isSuccessful()) {
            IOException e = this.read1.isCancelled() ? IO.error(this.read1.getCancelEvent()) : this.read1.getError();
            return IOUtil.error(e, ondone);
        }
        this.nb1 = this.read1.getResult();
        if (this.nb1 < 0) {
            this.nb1 = 0;
        }
        return null;
    }

    private <T> AsyncSupplier<T, IOException> needRead2Async(Callable<T> onReady, Consumer<Pair<T, IOException>> ondone) {
        if (!this.read1.isDone() || this.read2 == null) {
            AsyncSupplier sp = new AsyncSupplier();
            IOUtil.listenOnDone(this.read1, new Task.Cpu.FromRunnable("TwoBuffersIO.needRead2Async", this.io.getPriority(), () -> {
                try {
                    IOUtil.success(onReady.call(), sp, ondone);
                }
                catch (Exception e) {
                    IOUtil.error(IO.error(e), sp, ondone);
                }
            }), sp, ondone);
            return this.operation(sp);
        }
        if (!this.read2.isDone()) {
            AsyncSupplier sp = new AsyncSupplier();
            IOUtil.listenOnDone(this.read2, new Task.Cpu.FromRunnable("TwoBuffersIO", this.io.getPriority(), () -> {
                try {
                    IOUtil.success(onReady.call(), sp, ondone);
                }
                catch (Exception e) {
                    IOUtil.error(IO.error(e), sp, ondone);
                }
            }), sp, ondone);
            return this.operation(sp);
        }
        if (!this.read2.isSuccessful()) {
            IOException e = this.read2.isCancelled() ? IO.error(this.read2.getCancelEvent()) : this.read2.getError();
            return IOUtil.error(e, ondone);
        }
        this.nb2 = this.read2.getResult();
        if (this.nb2 < 0) {
            this.nb2 = 0;
        }
        return null;
    }

    @Override
    public int readAsync() throws IOException {
        if (this.nb1 < 0) {
            if (!this.read1.isDone()) {
                return -2;
            }
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            return this.buf1[this.pos++] & 0xFF;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            if (this.read2 == null) {
                this.waitRead2();
            }
            if (!this.read2.isDone()) {
                return -2;
            }
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        return this.buf2[this.pos++ - this.nb1] & 0xFF;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.pos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.pos += ((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> res;
        AsyncSupplier<Integer, IOException> res2;
        if (this.nb1 < 0 && (res2 = this.needRead1Async(() -> {
            if (this.nb1 == 0) {
                return -1;
            }
            return this.readSync(pos, buffer);
        }, ondone)) != null) {
            return res2;
        }
        final int len = buffer.remaining();
        if (pos < (long)this.nb1) {
            Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on FullyBufferedIO", this.getPriority(), ondone){

                @Override
                public Integer run() {
                    int l = TwoBuffersIO.this.nb1 - (int)pos;
                    if (l > len) {
                        l = len;
                    }
                    buffer.put(TwoBuffersIO.this.buf1, (int)pos, l);
                    return l;
                }
            };
            this.operation(task).start();
            return task.getOutput();
        }
        if (this.buf2 == null) {
            return IOUtil.success(-1, ondone);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.readSync(pos, buffer), ondone)) != null) {
            return res;
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            return IOUtil.success(-1, ondone);
        }
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on TwoBuffersIO", this.getPriority(), ondone){

            @Override
            public Integer run() {
                int l = TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2 - (int)pos;
                if (l > len) {
                    l = len;
                }
                buffer.put(TwoBuffersIO.this.buf2, (int)pos - TwoBuffersIO.this.nb1, l);
                return l;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        ReadNextBufferTask task = new ReadNextBufferTask(ondone);
        if (this.nb1 < 0) {
            if (!this.read1.isDone()) {
                this.read1.thenStart(task, true);
                return this.operation(task).getOutput();
            }
            if (this.read1.hasError()) {
                return IOUtil.error(this.read1.getError(), ondone);
            }
            if (this.read1.isCancelled()) {
                return new AsyncSupplier<Object, Object>(null, null, this.read1.getCancelEvent());
            }
            this.nb1 = this.read1.getResult();
            if (this.nb1 < 0) {
                this.nb1 = 0;
            }
            if (this.nb1 == 0) {
                return IOUtil.success(null, ondone);
            }
        }
        if (this.pos < this.nb1) {
            this.operation(task.start());
            return task.getOutput();
        }
        if (this.buf2 == null) {
            return IOUtil.success(null, ondone);
        }
        if (this.nb2 < 0) {
            if (!this.read1.isDone()) {
                this.read1.thenStart(task, true);
                return this.operation(task).getOutput();
            }
            if (this.read1.hasError()) {
                return IOUtil.error(this.read1.getError(), ondone);
            }
            if (this.read1.isCancelled()) {
                return new AsyncSupplier<Object, Object>(null, null, this.read1.getCancelEvent());
            }
            if (this.read2 == null) {
                this.operation(task.start());
                return task.getOutput();
            }
            if (!this.read2.isDone()) {
                this.read2.thenStart(task, true);
                return this.operation(task).getOutput();
            }
            if (this.read2.hasError()) {
                return IOUtil.error(this.read2.getError(), ondone);
            }
            if (this.read2.isCancelled()) {
                return new AsyncSupplier<Object, Object>(null, null, this.read2.getCancelEvent());
            }
            this.nb2 = this.read2.getResult();
            if (this.nb2 < 0) {
                this.nb2 = 0;
            }
            if (this.nb2 == 0) {
                return IOUtil.success(null, ondone);
            }
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return IOUtil.success(null, ondone);
        }
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
            if (this.nb1 == 0) {
                return null;
            }
        }
        if (this.pos < this.nb1) {
            return this.getRemainingBuf1();
        }
        if (this.buf2 == null) {
            return null;
        }
        if (this.nb2 < 0) {
            this.needRead2();
            if (this.nb2 == 0) {
                return null;
            }
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return null;
        }
        return this.getRemainingBuf2();
    }

    private ByteBuffer getRemainingBuf1() {
        ByteBuffer buf = ByteBuffer.wrap(this.buf1, this.pos, this.nb1 - this.pos).asReadOnlyBuffer();
        this.pos = this.nb1;
        return buf;
    }

    private ByteBuffer getRemainingBuf2() {
        ByteBuffer buf = ByteBuffer.wrap(this.buf2, this.pos - this.nb1, this.nb2 - (this.pos - this.nb1)).asReadOnlyBuffer();
        this.pos = this.nb1 + this.nb2;
        return buf;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = this.readFullySync(this.pos, buffer);
        if (nb > 0) {
            this.pos += nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        int l;
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.remaining();
        int done = 0;
        if (pos < (long)this.nb1) {
            l = this.nb1 - (int)pos;
            if (l > len) {
                l = len;
            }
            buffer.put(this.buf1, (int)pos, l);
            if (l == len) {
                return l;
            }
            pos += (long)l;
            len -= l;
            done = l;
        }
        if (this.buf2 == null) {
            return done > 0 ? done : -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            return done > 0 ? done : -1;
        }
        l = this.nb1 + this.nb2 - (int)pos;
        if (l > len) {
            l = len;
        }
        buffer.put(this.buf2, (int)pos - this.nb1, l);
        return l + done;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync((IO.Readable)this, buffer, 0, ondone));
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
    }

    @Override
    public long skipSync(long n) throws IOException {
        return this.skip((int)n);
    }

    @Override
    public int skip(int skip) throws IOException {
        if (skip == 0) {
            return 0;
        }
        if (skip < 0) {
            if (-skip > this.pos) {
                skip = -this.pos;
            }
            this.pos += skip;
            return skip;
        }
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int done = 0;
        if (this.pos < this.nb1) {
            if (this.pos + skip <= this.nb1) {
                this.pos += skip;
                return skip;
            }
            done = this.nb1 - this.pos;
            this.pos = this.nb1;
            skip -= done;
        }
        if (this.buf2 == null) {
            return done;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return done;
        }
        if (this.pos + skip <= this.nb1 + this.nb2) {
            this.pos += skip;
            return skip + done;
        }
        this.pos = this.nb1 + this.nb2;
        return done += this.nb1 + this.nb2 - this.pos;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long skip, Consumer<Pair<Long, IOException>> ondone) {
        long d;
        long s;
        AsyncSupplier<Long, IOException> res;
        long s2;
        AsyncSupplier<Long, IOException> res2;
        if (skip < 0L) {
            if (-skip > (long)this.pos) {
                skip = -this.pos;
            }
            this.pos = (int)((long)this.pos + skip);
            return IOUtil.success(skip, ondone);
        }
        if (skip == 0L) {
            return IOUtil.success(0L, ondone);
        }
        if (this.nb1 < 0 && (res2 = this.needRead1Async(() -> this.lambda$skipAsync$9(s2 = skip), ondone)) != null) {
            return res2;
        }
        int done = 0;
        if (this.pos < this.nb1) {
            if ((long)this.pos + skip <= (long)this.nb1) {
                this.pos = (int)((long)this.pos + skip);
                return IOUtil.success(skip, ondone);
            }
            done = this.nb1 - this.pos;
            this.pos = this.nb1;
            skip -= (long)done;
        }
        if (this.buf2 == null) {
            return IOUtil.success(Long.valueOf(done), ondone);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.lambda$skipAsync$10(s = skip, d = (long)done), ondone)) != null) {
            return res;
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return IOUtil.success(Long.valueOf(done), ondone);
        }
        if ((long)this.pos + skip <= (long)(this.nb1 + this.nb2)) {
            this.pos = (int)((long)this.pos + skip);
            return IOUtil.success(skip + (long)done, ondone);
        }
        this.pos = this.nb1 + this.nb2;
        return IOUtil.success(Long.valueOf(done += this.nb1 + this.nb2 - this.pos), ondone);
    }

    @Override
    public long getSizeSync() throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.buf2 == null) {
            return this.nb1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        return (long)this.nb1 + (long)this.nb2;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        AsyncSupplier<Long, IOException> res;
        if (this.nb1 < 0 && (res = this.needRead1Async(() -> this.getSizeSync(), null)) != null) {
            return res;
        }
        if (this.buf2 == null) {
            return new AsyncSupplier<Long, Object>(Long.valueOf(this.nb1), null);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.getSizeSync(), null)) != null) {
            return res;
        }
        return new AsyncSupplier<Long, Object>((long)this.nb1 + (long)this.nb2, null);
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_CURRENT: {
                this.skipSync(move);
                return this.pos;
            }
            case FROM_BEGINNING: {
                this.pos = 0;
                this.skipSync(move);
                return this.pos;
            }
            case FROM_END: {
                this.pos = (int)this.getSizeSync();
                this.skipSync(-move);
                return this.pos;
            }
        }
        return 0L;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.seekAsyncUsingSync(this, type, move, ondone)).getOutput();
    }

    private /* synthetic */ Long lambda$skipAsync$10(long s, long d) throws Exception {
        return this.skipSync(s) + d;
    }

    private /* synthetic */ Long lambda$skipAsync$9(long s) throws Exception {
        if (this.nb1 == 0) {
            return 0L;
        }
        return this.skipSync(s);
    }

    private class ReadNextBufferTask
    extends Task.Cpu<ByteBuffer, IOException> {
        private ReadNextBufferTask(Consumer<Pair<ByteBuffer, IOException>> ondone) {
            super("Read next buffer", TwoBuffersIO.this.getPriority(), ondone);
        }

        @Override
        public ByteBuffer run() throws IOException {
            if (TwoBuffersIO.this.nb1 < 0) {
                if (TwoBuffersIO.this.read1.hasError()) {
                    throw (IOException)TwoBuffersIO.this.read1.getError();
                }
                if (TwoBuffersIO.this.read1.isCancelled()) {
                    throw IO.errorCancelled(TwoBuffersIO.this.read1.getCancelEvent());
                }
                TwoBuffersIO.this.nb1 = (Integer)TwoBuffersIO.this.read1.getResult();
                if (TwoBuffersIO.this.nb1 < 0) {
                    TwoBuffersIO.this.nb1 = 0;
                }
                if (TwoBuffersIO.this.nb1 == 0) {
                    return null;
                }
            }
            if (TwoBuffersIO.this.pos < TwoBuffersIO.this.nb1) {
                return TwoBuffersIO.this.getRemainingBuf1();
            }
            if (TwoBuffersIO.this.buf2 == null) {
                return null;
            }
            if (TwoBuffersIO.this.nb2 < 0) {
                if (TwoBuffersIO.this.read1.hasError()) {
                    throw (IOException)TwoBuffersIO.this.read1.getError();
                }
                if (TwoBuffersIO.this.read1.isCancelled()) {
                    throw IO.errorCancelled(TwoBuffersIO.this.read1.getCancelEvent());
                }
                if (TwoBuffersIO.this.read2 == null) {
                    TwoBuffersIO.this.waitRead2();
                }
                if (TwoBuffersIO.this.read2.hasError()) {
                    throw (IOException)TwoBuffersIO.this.read2.getError();
                }
                if (TwoBuffersIO.this.read2.isCancelled()) {
                    throw IO.errorCancelled(TwoBuffersIO.this.read2.getCancelEvent());
                }
                TwoBuffersIO.this.nb2 = (Integer)TwoBuffersIO.this.read2.getResult();
                if (TwoBuffersIO.this.nb2 < 0) {
                    TwoBuffersIO.this.nb2 = 0;
                }
                if (TwoBuffersIO.this.nb2 == 0) {
                    return null;
                }
            }
            if (TwoBuffersIO.this.pos >= TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2) {
                return null;
            }
            return TwoBuffersIO.this.getRemainingBuf2();
        }
    }

    public static class DeterminedSize
    extends TwoBuffersIO
    implements IO.KnownSize {
        public DeterminedSize(IO.Readable io, int firstBuffer, int secondBuffer) {
            super(io, firstBuffer, secondBuffer);
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n) {
            return new AsyncSupplier<Long, Object>(Long.valueOf(this.skip((int)n)), null);
        }

        @Override
        public int skip(int skip) {
            if (skip == 0) {
                return 0;
            }
            if (skip < 0) {
                if (-skip > this.pos) {
                    skip = -this.pos;
                }
                this.pos += skip;
                return skip;
            }
            int max = this.buf1.length + (this.buf2 == null ? 0 : this.buf2.length);
            if (this.pos + skip > max) {
                skip = max - this.pos;
            }
            this.pos += skip;
            return skip;
        }

        @Override
        public long getSizeSync() {
            return (long)this.buf1.length + (long)(this.buf2 == null ? 0 : this.buf2.length);
        }

        @Override
        public AsyncSupplier<Long, IOException> getSizeAsync() {
            return new AsyncSupplier<Long, Object>((long)this.buf1.length + (long)(this.buf2 == null ? 0 : this.buf2.length), null);
        }

        @Override
        public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
            try {
                return IOUtil.success(this.seekSync(type, move), ondone);
            }
            catch (IOException e) {
                return IOUtil.error(e, ondone);
            }
        }
    }
}

