/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import net.lecousin.framework.io.data.BitsBuffer;
import net.lecousin.framework.io.data.Bytes;

public interface BytesBitsBuffer
extends BitsBuffer {

    public static interface Writable
    extends BytesBitsBuffer,
    BitsBuffer.Writable {

        public static class LittleEndian
        implements Writable,
        BitsBuffer.LittleEndian {
            private Bytes.Writable bytes;
            private byte b = 0;
            private int bit = 0;

            public LittleEndian(Bytes.Writable bytes) {
                this.bytes = bytes;
            }

            @Override
            public boolean hasRemaining() {
                return this.bytes.hasRemaining();
            }

            @Override
            public int remaining() {
                return (this.bytes.remaining() - 1) * 8 + (8 - this.bit);
            }

            @Override
            public void alignToNextByte(boolean fillBit) {
                if (this.bit == 0) {
                    return;
                }
                if (fillBit) {
                    for (int i = this.bit; i < 8; ++i) {
                        this.b = (byte)(this.b | 1 << i);
                    }
                }
                this.bytes.put(this.b);
                this.bit = 0;
                this.b = 0;
            }

            @Override
            public void put(boolean bit) {
                if (bit) {
                    this.b = (byte)(this.b | 1 << this.bit);
                }
                if (++this.bit == 8) {
                    this.bytes.put(this.b);
                    this.bit = 0;
                    this.b = 0;
                }
            }
        }

        public static class BigEndian
        implements Writable,
        BitsBuffer.BigEndian {
            private Bytes.Writable bytes;
            private byte b = 0;
            private int bit = 7;

            public BigEndian(Bytes.Writable bytes) {
                this.bytes = bytes;
            }

            @Override
            public boolean hasRemaining() {
                return this.bytes.hasRemaining();
            }

            @Override
            public int remaining() {
                return (this.bytes.remaining() - 1) * 8 + this.bit + 1;
            }

            @Override
            public void alignToNextByte(boolean fillBit) {
                if (this.bit == 7) {
                    return;
                }
                if (fillBit) {
                    for (int i = this.bit; i >= 0; --i) {
                        this.b = (byte)(this.b | 1 << i);
                    }
                }
                this.bit = 7;
                this.bytes.put(this.b);
                this.b = 0;
            }

            @Override
            public void put(boolean bit) {
                if (bit) {
                    this.b = (byte)(this.b | 1 << this.bit);
                }
                if (--this.bit < 0) {
                    this.bytes.put(this.b);
                    this.bit = 7;
                    this.b = 0;
                }
            }
        }
    }

    public static interface Readable
    extends BytesBitsBuffer,
    BitsBuffer.Readable {

        public static class LittleEndian
        implements Readable,
        BitsBuffer.LittleEndian {
            private Bytes.Readable bytes;
            private byte b;
            private int mask = 256;

            public LittleEndian(Bytes.Readable bytes) {
                this.bytes = bytes;
            }

            @Override
            public boolean get() {
                if (this.mask == 256) {
                    this.b = this.bytes.get();
                    this.mask = 1;
                }
                boolean bit = (this.b & this.mask) != 0;
                this.mask <<= 1;
                return bit;
            }

            @Override
            public boolean hasRemaining() {
                return this.mask != 256 || this.bytes.hasRemaining();
            }

            @Override
            public int remaining() {
                int r = this.bytes.remaining() * 8;
                switch (this.mask) {
                    case 128: {
                        return r + 1;
                    }
                    case 64: {
                        return r + 2;
                    }
                    case 32: {
                        return r + 3;
                    }
                    case 16: {
                        return r + 4;
                    }
                    case 8: {
                        return r + 5;
                    }
                    case 4: {
                        return r + 6;
                    }
                    case 2: {
                        return r + 7;
                    }
                }
                return r + 0;
            }

            @Override
            public void alignToNextByte() {
                this.mask = 256;
            }
        }

        public static class BigEndian
        implements Readable,
        BitsBuffer.BigEndian {
            private Bytes.Readable bytes;
            private byte b;
            private int mask = 0;

            public BigEndian(Bytes.Readable bytes) {
                this.bytes = bytes;
            }

            @Override
            public boolean get() {
                if (this.mask == 0) {
                    this.b = this.bytes.get();
                    this.mask = 128;
                }
                boolean bit = (this.b & this.mask) != 0;
                this.mask >>= 1;
                return bit;
            }

            @Override
            public boolean hasRemaining() {
                return this.mask != 0 || this.bytes.hasRemaining();
            }

            @Override
            public int remaining() {
                int r = this.bytes.remaining() * 8;
                switch (this.mask) {
                    case 64: {
                        return r + 7;
                    }
                    case 32: {
                        return r + 6;
                    }
                    case 16: {
                        return r + 5;
                    }
                    case 8: {
                        return r + 4;
                    }
                    case 4: {
                        return r + 3;
                    }
                    case 2: {
                        return r + 2;
                    }
                    case 1: {
                        return r + 1;
                    }
                }
                return r + 0;
            }

            @Override
            public void alignToNextByte() {
                this.mask = 0;
            }
        }
    }
}

