/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.CharBuffer;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.IString;

public class CharsFromIso8859Bytes
implements Chars.Readable {
    protected Bytes.Readable bytes;
    protected boolean free;

    public CharsFromIso8859Bytes(Bytes.Readable bytes, boolean free) {
        this.bytes = bytes;
        this.free = free;
    }

    @Override
    public int length() {
        return this.bytes.length();
    }

    @Override
    public int remaining() {
        return this.bytes.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.bytes.hasRemaining();
    }

    @Override
    public int position() {
        return this.bytes.position();
    }

    @Override
    public void setPosition(int position) {
        this.bytes.setPosition(position);
    }

    @Override
    public void moveForward(int offset) {
        this.bytes.moveForward(offset);
    }

    @Override
    public void goToEnd() {
        this.bytes.goToEnd();
    }

    @Override
    public char get() {
        return (char)(this.bytes.get() & 0xFF);
    }

    @Override
    public void get(char[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = (char)(this.bytes.get() & 0xFF);
        }
    }

    @Override
    public void get(IString string, int length) {
        byte[] b = new byte[length];
        this.bytes.get(b, 0, length);
        string.append(new ByteArrayStringIso8859(b, 0, length, length));
    }

    @Override
    public char getForward(int offset) {
        return (char)(this.bytes.getForward(offset) & 0xFF);
    }

    @Override
    public CharBuffer toCharBuffer() {
        int pos = this.bytes.position();
        int len = this.bytes.remaining();
        this.bytes.setPosition(0);
        char[] chars = new char[len];
        this.get(chars, 0, len);
        this.bytes.setPosition(pos);
        return CharBuffer.wrap(chars);
    }

    @Override
    public void free() {
        if (this.free) {
            this.bytes.free();
        }
    }

    @Override
    public CharsFromIso8859Bytes subBuffer(int startPosition, int length) {
        return new CharsFromIso8859Bytes(this.bytes.subBuffer(startPosition, length), false);
    }
}

