/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.CharBuffer;
import java.util.List;
import net.lecousin.framework.io.data.AbstractComposite;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.text.IString;

public abstract class CompositeChars<T extends Chars>
extends AbstractComposite<T>
implements Chars {
    public CompositeChars() {
    }

    @SafeVarargs
    public CompositeChars(T ... chars) {
        super(chars);
    }

    public CompositeChars(List<T> chars) {
        super(chars);
    }

    public static class Writable
    extends CompositeChars<Chars.Writable>
    implements Chars.Writable {
        public Writable() {
        }

        public Writable(Chars.Writable ... chars) {
            super((Chars[])chars);
        }

        public Writable(List<Chars.Writable> chars) {
            super(chars);
        }

        @Override
        public void put(char b) {
            Chars.Writable chars = (Chars.Writable)this.list.get(this.index);
            chars.put(b);
            ++this.position;
            if (!chars.hasRemaining()) {
                ++this.index;
            }
        }

        @Override
        public void put(char[] buffer, int offset, int length) {
            while (length > 0) {
                Chars.Writable chars = (Chars.Writable)this.list.get(this.index);
                int r = chars.remaining();
                if (length < r) {
                    chars.put(buffer, offset, length);
                    this.position += length;
                    return;
                }
                chars.put(buffer, offset, r);
                this.position += r;
                offset += r;
                length -= r;
                ++this.index;
            }
        }

        @Override
        public CharBuffer toCharBuffer() {
            char[] buf = new char[this.length];
            int off = 0;
            for (Chars.Writable chars : this.list) {
                int p = chars.position();
                chars.setPosition(0);
                int l = chars.remaining();
                if (!(chars instanceof Chars.Readable)) {
                    throw new UnsupportedOperationException("Cannot convert a write-only Chars to CharBuffer");
                }
                ((Chars.Readable)((Object)chars)).get(buf, off, l);
                chars.setPosition(p);
                off += l;
            }
            CharBuffer cb = CharBuffer.wrap(buf);
            cb.position(this.position);
            return cb;
        }

        @Override
        public Chars.Writable subBuffer(int startPosition, int length) {
            int i = 0;
            int p = startPosition;
            do {
                Chars.Writable chars;
                int r;
                if (p < (r = (chars = (Chars.Writable)this.list.get(i)).length())) {
                    Writable result = new Writable();
                    int l = Math.min(length, r - p);
                    result.add(chars.subBuffer(p, l));
                    length -= l;
                    while (length > 0 && ++i < this.list.size()) {
                        chars = (Chars.Writable)this.list.get(i);
                        l = Math.min(length, chars.length());
                        result.add(chars.subBuffer(0, l));
                        length -= l;
                    }
                    return result;
                }
                p -= r;
            } while (++i < this.list.size());
            return new CharArray.Writable(new char[0], false);
        }
    }

    public static class Readable
    extends CompositeChars<Chars.Readable>
    implements Chars.Readable {
        public Readable() {
        }

        public Readable(Chars.Readable ... chars) {
            super((Chars[])chars);
        }

        public Readable(List<Chars.Readable> chars) {
            super(chars);
        }

        @Override
        public char get() {
            Chars.Readable chars = (Chars.Readable)this.list.get(this.index);
            char c = chars.get();
            ++this.position;
            if (!chars.hasRemaining()) {
                ++this.index;
            }
            return c;
        }

        @Override
        public void get(char[] buffer, int offset, int length) {
            while (length > 0) {
                Chars.Readable chars = (Chars.Readable)this.list.get(this.index);
                int r = chars.remaining();
                if (length < r) {
                    chars.get(buffer, offset, length);
                    this.position += length;
                    return;
                }
                chars.get(buffer, offset, r);
                this.position += r;
                offset += r;
                length -= r;
                ++this.index;
            }
        }

        @Override
        public void get(IString string, int length) {
            while (length > 0) {
                Chars.Readable chars = (Chars.Readable)this.list.get(this.index);
                int r = chars.remaining();
                if (length < r) {
                    chars.get(string, length);
                    this.position += length;
                    return;
                }
                chars.get(string, r);
                this.position += r;
                length -= r;
                ++this.index;
            }
        }

        @Override
        public char getForward(int offset) {
            int i = this.index;
            int o = offset;
            Chars.Readable chars;
            int r;
            while (o >= (r = (chars = (Chars.Readable)this.list.get(i)).remaining())) {
                o -= r;
                ++i;
            }
            return chars.getForward(o);
        }

        @Override
        public CharBuffer toCharBuffer() {
            char[] buf = new char[this.length];
            int off = 0;
            for (Chars.Readable chars : this.list) {
                int p = chars.position();
                chars.setPosition(0);
                int l = chars.remaining();
                chars.get(buf, off, l);
                chars.setPosition(p);
                off += l;
            }
            return CharBuffer.wrap(buf);
        }

        @Override
        public Chars.Readable subBuffer(int startPosition, int length) {
            int i = 0;
            int p = startPosition;
            do {
                Chars.Readable chars;
                int r;
                if (p < (r = (chars = (Chars.Readable)this.list.get(i)).length())) {
                    Readable result = new Readable();
                    int l = Math.min(length, r - p);
                    result.add(chars.subBuffer(p, l));
                    length -= l;
                    while (length > 0 && ++i < this.list.size()) {
                        chars = (Chars.Readable)this.list.get(i);
                        l = Math.min(length, chars.length());
                        result.add(chars.subBuffer(0, l));
                        length -= l;
                    }
                    return result;
                }
                p -= r;
            } while (++i < this.list.size());
            return new CharArray(new char[0]);
        }
    }
}

