/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.out2in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.LockPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.out2in.OutputToInputTransferException;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class OutputToInputBuffers
extends ConcurrentCloseable<IOException>
implements IO.OutputToInput,
IO.Writable,
IO.Readable,
IO.Readable.Buffered {
    private boolean copyReceivedBuffers;
    private int maxPendingBuffers;
    private LinkedList<ByteBuffer> buffers = new LinkedList();
    private boolean eof = false;
    private LockPoint<IOException> lock = new LockPoint();
    private LinkedList<Async<NoException>> lockMaxBuffers;
    private byte priority;
    private AsyncSupplier<?, ?> lastWrite = null;

    public OutputToInputBuffers(boolean copyReceivedBuffers, int maxPendingBuffers, byte priority) {
        if (maxPendingBuffers < 0) {
            maxPendingBuffers = 0;
        }
        this.copyReceivedBuffers = copyReceivedBuffers;
        this.maxPendingBuffers = maxPendingBuffers;
        this.priority = priority;
        if (maxPendingBuffers > 0) {
            this.lockMaxBuffers = new LinkedList();
        }
    }

    public OutputToInputBuffers(boolean copyReceivedBuffers, byte priority) {
        this(copyReceivedBuffers, 0, priority);
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        this.eof = true;
        this.lock.unlock();
        if (this.maxPendingBuffers > 0) {
            while (!this.lockMaxBuffers.isEmpty()) {
                this.lockMaxBuffers.removeFirst().unblock();
            }
        }
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.buffers = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public String getSourceDescription() {
        return "OutputToInput";
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public void signalErrorBeforeEndOfData(IOException error) {
        this.lock.error(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOfData() {
        AsyncSupplier<?, ?> lw;
        OutputToInputBuffers outputToInputBuffers = this;
        synchronized (outputToInputBuffers) {
            lw = this.lastWrite;
        }
        if (lw == null || lw.isDone()) {
            this.eof = true;
            this.lock.unlock();
            return;
        }
        lw.onDone(() -> {
            this.eof = true;
            this.lock.unlock();
        });
    }

    @Override
    public boolean isFullDataAvailable() {
        return this.eof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableDataSize() {
        long total = 0L;
        OutputToInputBuffers outputToInputBuffers = this;
        synchronized (outputToInputBuffers) {
            for (ByteBuffer b : this.buffers) {
                total += (long)b.remaining();
            }
        }
        return total;
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeSync(ByteBuffer buffer) {
        OutputToInputBuffers outputToInputBuffers;
        if (this.maxPendingBuffers > 0) {
            while (true) {
                Async sp = null;
                outputToInputBuffers = this;
                synchronized (outputToInputBuffers) {
                    if (this.isClosing() || this.isClosed()) {
                        return 0;
                    }
                    if (this.buffers.size() >= this.maxPendingBuffers) {
                        sp = new Async();
                        this.lockMaxBuffers.addLast(sp);
                    }
                }
                if (sp == null) break;
                sp.block(0L);
            }
        }
        if (this.copyReceivedBuffers) {
            ByteBuffer b = ByteBuffer.allocate(buffer.remaining());
            b.put(buffer);
            b.flip();
            outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.add(b);
            }
            this.lock.unlock();
            return b.remaining();
        }
        OutputToInputBuffers outputToInputBuffers2 = this;
        synchronized (outputToInputBuffers2) {
            this.buffers.add(buffer);
        }
        this.lock.unlock();
        return buffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("OutputToInput.write", this.getPriority(), ondone){

            @Override
            public Integer run() {
                return OutputToInputBuffers.this.writeSync(buffer);
            }
        };
        Async sp = null;
        OutputToInputBuffers outputToInputBuffers = this;
        synchronized (outputToInputBuffers) {
            this.lastWrite = task.getOutput();
            if (this.maxPendingBuffers > 0) {
                if (this.isClosing() || this.isClosed()) {
                    return new AsyncSupplier<Object, Object>(null, null, IO.cancelClosed());
                }
                if (this.buffers.size() >= this.maxPendingBuffers) {
                    sp = new Async();
                    this.lockMaxBuffers.addLast(sp);
                }
            }
        }
        if (sp == null) {
            task.start();
        } else {
            task.startOn(sp, true);
        }
        return ((Task.Cpu)this.operation(task)).getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsync<IOException> canStartReading() {
        OutputToInputBuffers outputToInputBuffers = this;
        synchronized (outputToInputBuffers) {
            if (!this.buffers.isEmpty()) {
                return new Async<boolean>(true);
            }
            if (this.eof) {
                return new Async<boolean>(true);
            }
            if (this.lock.hasError()) {
                return this.lock;
            }
        }
        if (this.lock.isDone()) {
            this.lock.lock();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        ByteBuffer b = null;
        while (true) {
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (!this.buffers.isEmpty()) {
                    b = this.buffers.get(0);
                    break;
                }
                if (this.eof) {
                    return -1;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
            }
            this.lock.lock();
        }
        int nb = b.remaining();
        if (nb <= buffer.remaining()) {
            buffer.put(b);
        } else {
            int l = b.limit();
            b.limit(l - (nb - buffer.remaining()));
            nb = buffer.remaining();
            buffer.put(b);
            b.limit(l);
        }
        if (b.remaining() == 0) {
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        int done = 0;
        do {
            ByteBuffer b = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (this.isClosing() || this.isClosed()) {
                    return IOUtil.error(new ClosedChannelException(), ondone);
                }
                if (this.buffers.isEmpty()) {
                    return this.readFullyCannotSync(buffer, done, ondone);
                }
                b = this.buffers.get(0);
            }
            int len = buffer.remaining();
            if (len >= b.remaining()) {
                done += b.remaining();
                buffer.put(b);
            } else {
                int limit = b.limit();
                b.limit(b.position() + len);
                buffer.put(b);
                b.limit(limit);
                done += len;
            }
            if (b.remaining() != 0) continue;
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers2 = this;
            synchronized (outputToInputBuffers2) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp == null) continue;
            sp.unblock();
        } while (buffer.hasRemaining());
        return IOUtil.success(done, ondone);
    }

    private AsyncSupplier<Integer, IOException> readFullyCannotSync(ByteBuffer buffer, int done, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.eof) {
            return IOUtil.success(done > 0 ? done : -1, ondone);
        }
        if (this.lock.hasError()) {
            return IOUtil.error(new OutputToInputTransferException((Throwable)this.lock.getError()), ondone);
        }
        if (done == 0) {
            return this.readFullyAsync(buffer, ondone);
        }
        AsyncSupplier<Integer, IOException> r = new AsyncSupplier<Integer, IOException>();
        int d = done;
        this.readFullyAsync(buffer, res -> {
            if (ondone != null) {
                if (res.getValue1() != null) {
                    int n = (Integer)res.getValue1();
                    if (n < 0) {
                        n = 0;
                    }
                    ondone.accept(new Pair<Integer, Object>(n += d, null));
                } else {
                    ondone.accept(res);
                }
            }
        }).onDone(nb -> {
            int n = nb;
            if (n < 0) {
                n = 0;
            }
            r.unblockSuccess(n += d);
        }, r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readAsync() throws IOException {
        ByteBuffer b = null;
        OutputToInputBuffers outputToInputBuffers = this;
        synchronized (outputToInputBuffers) {
            if (this.isClosing() || this.isClosed()) {
                throw new ClosedChannelException();
            }
            if (this.buffers.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                if (!this.lock.isDone()) {
                    return -2;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
                return -2;
            }
            b = this.buffers.get(0);
        }
        int res = b.get() & 0xFF;
        if (b.remaining() == 0) {
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers2 = this;
            synchronized (outputToInputBuffers2) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
        }
        return res;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(final ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("OutputToInput.read", this.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return OutputToInputBuffers.this.readSync(buffer);
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skipSync(long n) throws IOException {
        long done = 0L;
        while (n > 0L) {
            ByteBuffer b = null;
            while (true) {
                OutputToInputBuffers outputToInputBuffers = this;
                synchronized (outputToInputBuffers) {
                    if (!this.buffers.isEmpty()) {
                        b = this.buffers.get(0);
                        break;
                    }
                    if (this.eof) {
                        return done;
                    }
                    if (this.lock.hasError()) {
                        throw new OutputToInputTransferException((Throwable)this.lock.getError());
                    }
                }
                this.lock.lock();
            }
            int nb = b.remaining();
            if ((long)nb > n) {
                b.position(b.position() + (int)n);
                return done + n;
            }
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
            done += (long)nb;
            n -= (long)nb;
        }
        return done;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.skipAsyncUsingSync(this, n, ondone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        ByteBuffer b = null;
        while (true) {
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (!this.buffers.isEmpty()) {
                    b = this.buffers.get(0);
                    break;
                }
                if (this.eof) {
                    return -1;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
            }
            this.lock.lock();
        }
        int res = b.get() & 0xFF;
        if (b.remaining() == 0) {
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        ByteBuffer b = null;
        while (true) {
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (!this.buffers.isEmpty()) {
                    b = this.buffers.get(0);
                    break;
                }
                if (this.eof) {
                    return -1;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
            }
            this.lock.lock();
        }
        int nb = b.remaining();
        if (nb <= len) {
            b.get(buffer, offset, nb);
            len = nb;
        } else {
            b.get(buffer, offset, len);
        }
        if (b.remaining() == 0) {
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
        }
        return len;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int skip(int skip) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        ByteBuffer b = null;
        while (true) {
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (!this.buffers.isEmpty()) {
                    b = this.buffers.get(0);
                    break;
                }
                if (this.eof) {
                    return 0;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
            }
            this.lock.lock();
        }
        int nb = b.remaining();
        if (nb <= skip) {
            Async<NoException> sp = null;
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                this.buffers.removeFirst();
                if (this.maxPendingBuffers > 0) {
                    sp = this.lockMaxBuffers.pollFirst();
                }
            }
            if (sp != null) {
                sp.unblock();
            }
            if (nb == skip) {
                return skip;
            }
            return nb + this.skip(skip - nb);
        }
        b.position(b.position() + skip);
        return skip;
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        Task.Cpu.FromSupplierThrows task = new Task.Cpu.FromSupplierThrows("Peek next buffer from OutputToInputBuffers", this.getPriority(), ondone, this::readNextBuffer);
        ((Task.Cpu)this.operation(task)).startOn(this.canStartReading(), true);
        return task.getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        Async<NoException> sp = null;
        ByteBuffer b = null;
        while (true) {
            OutputToInputBuffers outputToInputBuffers = this;
            synchronized (outputToInputBuffers) {
                if (this.isClosing() || this.isClosed()) {
                    throw new ClosedChannelException();
                }
                if (!this.buffers.isEmpty()) {
                    b = this.buffers.removeFirst();
                    if (this.maxPendingBuffers > 0) {
                        sp = this.lockMaxBuffers.pollFirst();
                    }
                    break;
                }
                if (this.eof) {
                    break;
                }
                if (this.lock.hasError()) {
                    throw new OutputToInputTransferException((Throwable)this.lock.getError());
                }
            }
            this.lock.lock();
        }
        if (sp != null) {
            sp.unblock();
        }
        return b;
    }
}

