/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOAsInputStream;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.serialization.Deserializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.SerializationUtil;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.util.Pair;

public abstract class AbstractDeserializer
implements Deserializer {
    protected byte priority;
    protected int maxTextSize = -1;
    protected final String taskDescription = "Deserialization using " + this.getClass().getName();
    protected List<Deserializer.StreamReferenceHandler> streamReferenceHandlers = new LinkedList<Deserializer.StreamReferenceHandler>();

    protected abstract IAsync<SerializationException> initializeDeserialization(IO.Readable var1);

    protected abstract IAsync<SerializationException> finalizeDeserialization();

    @Override
    public int getMaximumTextSize() {
        return this.maxTextSize;
    }

    @Override
    public void setMaximumTextSize(int max) {
        this.maxTextSize = max;
    }

    @Override
    public <T> AsyncSupplier<T, SerializationException> deserialize(TypeDefinition type, IO.Readable input, List<SerializationRule> rules) {
        this.priority = input.getPriority();
        IAsync<SerializationException> init = this.initializeDeserialization(input);
        AsyncSupplier result = new AsyncSupplier();
        init.thenStart(new DeserializationTask(() -> {
            AsyncSupplier<Object, SerializationException> sp = this.deserializeValue(null, type, "", rules);
            sp.onDone(obj -> this.finalizeDeserialization().onDone(() -> result.unblockSuccess(obj), result), (IAsync<SerializationException>)result);
        }), result);
        return result;
    }

    protected List<SerializationRule> addRulesForType(SerializationClass type, List<SerializationRule> currentList) {
        currentList = TypeAnnotationToRule.addRules(type, currentList);
        currentList = AttributeAnnotationToRuleOnType.addRules(type, false, currentList);
        return currentList;
    }

    protected List<SerializationRule> addRulesForAttribute(SerializationClass.Attribute a, List<SerializationRule> currentList) {
        return AttributeAnnotationToRuleOnAttribute.addRules(a, true, currentList);
    }

    public <T> AsyncSupplier<T, SerializationException> deserializeValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        rules = this.addRulesForType(new SerializationClass(type), rules);
        TypeDefinition newType = type;
        ArrayList<TypeDefinition> rulesTypes = new ArrayList<TypeDefinition>(rules.size());
        for (SerializationRule rule : rules) {
            rulesTypes.add(newType);
            newType = rule.getDeserializationType(newType, context);
        }
        AsyncSupplier<Object, SerializationException> value = this.deserializeValueType(context, newType, path, rules);
        AsyncSupplier result = new AsyncSupplier();
        List<SerializationRule> rul = rules;
        value.thenDoOrStart(val -> {
            Object o = val;
            ListIterator itType = rulesTypes.listIterator(rul.size());
            ListIterator itRule = rul.listIterator(rul.size());
            while (itRule.hasPrevious()) {
                try {
                    o = ((SerializationRule)itRule.previous()).getDeserializationValue(o, (TypeDefinition)itType.previous(), context);
                }
                catch (SerializationException e) {
                    result.error(e);
                    return;
                }
            }
            result.unblockSuccess(o);
        }, this.taskDescription, this.priority, result);
        return result;
    }

    private <T> AsyncSupplier<T, SerializationException> deserializeValueType(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        Class<?> c = type.getBase();
        if (c.isArray()) {
            if (byte[].class.equals(c)) {
                return this.deserializeByteArrayValue(context, rules);
            }
            return this.deserializeCollectionValue(context, type, path, rules);
        }
        if (Boolean.TYPE.equals(c)) {
            return this.deserializeBooleanValue(false);
        }
        if (Boolean.class.equals(c)) {
            return this.deserializeBooleanValue(true);
        }
        if (Byte.TYPE.equals(c) || Short.TYPE.equals(c) || Integer.TYPE.equals(c) || Long.TYPE.equals(c) || Float.TYPE.equals(c) || Double.TYPE.equals(c)) {
            return this.deserializeNumericValue(c, false, null);
        }
        if (Number.class.isAssignableFrom(c)) {
            return this.deserializeNumericValue(c, true, null);
        }
        if (Character.TYPE.equals(c)) {
            return this.deserializeCharacterValue(false);
        }
        if (Character.class.equals(c)) {
            return this.deserializeCharacterValue(true);
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            AsyncSupplier<? extends CharSequence, SerializationException> str = this.deserializeStringValue();
            AsyncSupplier result = new AsyncSupplier();
            str.onDone(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                if (c.isAssignableFrom(string.getClass())) {
                    result.unblockSuccess(string);
                    return;
                }
                for (Constructor<?> ctor : c.getConstructors()) {
                    Class<?>[] params = ctor.getParameterTypes();
                    if (params.length != 1) continue;
                    if (params[0].isAssignableFrom(string.getClass())) {
                        try {
                            result.unblockSuccess(ctor.newInstance(string));
                        }
                        catch (Exception t) {
                            result.error(SerializationException.instantiation(c.getName(), t));
                        }
                        return;
                    }
                    if (!params[0].isAssignableFrom(String.class)) continue;
                    try {
                        result.unblockSuccess(ctor.newInstance(string.toString()));
                    }
                    catch (Exception t) {
                        result.error(SerializationException.instantiation(c.getName(), t));
                    }
                    return;
                }
                result.error(new SerializationException("Type " + c.getName() + " does not have a compatible constructor with parameter type " + string.getClass() + " or String"));
            }, result);
            return result;
        }
        if (c.isEnum()) {
            AsyncSupplier<? extends CharSequence, SerializationException> str = this.deserializeStringValue();
            AsyncSupplier result = new AsyncSupplier();
            str.onDone(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                try {
                    result.unblockSuccess(Enum.valueOf(c, string.toString()));
                }
                catch (IllegalArgumentException e) {
                    result.error(new SerializationException("Unknown enum value '" + string + "' for " + c.getName()));
                }
            }, result);
            return result;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return this.deserializeCollectionValue(context, type, path, rules);
        }
        if (Map.class.isAssignableFrom(c)) {
            return this.deserializeMapValue(context, type, path, rules);
        }
        if (InputStream.class.isAssignableFrom(c)) {
            return this.deserializeInputStreamValue(context, rules);
        }
        if (IO.Readable.class.isAssignableFrom(c)) {
            return this.deserializeIOReadableValue(context, rules);
        }
        return this.deserializeObjectValue(context, type, path, rules);
    }

    protected abstract AsyncSupplier<Boolean, SerializationException> deserializeBooleanValue(boolean var1);

    protected AsyncSupplier<Boolean, SerializationException> deserializeBooleanAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        return this.deserializeBooleanValue(nullable);
    }

    protected abstract AsyncSupplier<? extends Number, SerializationException> deserializeNumericValue(Class<?> var1, boolean var2, Class<? extends IntegerUnit> var3);

    protected AsyncSupplier<? extends Number, SerializationException> deserializeNumericAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        IntegerUnit.Unit unit = context.getAttribute().getAnnotation(false, IntegerUnit.Unit.class);
        Class<? extends IntegerUnit> target = unit != null ? unit.value() : null;
        return this.deserializeNumericValue(context.getAttribute().getType().getBase(), nullable, target);
    }

    public static void convertBigDecimalValue(BigDecimal n, Class<?> type, AsyncSupplier<Number, SerializationException> result) {
        block11: {
            try {
                if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
                    result.unblockSuccess(n.byteValueExact());
                    break block11;
                }
                if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                    result.unblockSuccess(n.shortValueExact());
                    break block11;
                }
                if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                    result.unblockSuccess(n.intValueExact());
                    break block11;
                }
                if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                    result.unblockSuccess(n.longValueExact());
                    break block11;
                }
                if (Float.TYPE.equals(type) || Float.class.equals(type)) {
                    result.unblockSuccess(Float.valueOf(n.floatValue()));
                    break block11;
                }
                if (Double.TYPE.equals(type) || Double.class.equals(type)) {
                    result.unblockSuccess(n.doubleValue());
                    break block11;
                }
                if (BigInteger.class.equals(type)) {
                    result.unblockSuccess(n.toBigIntegerExact());
                    break block11;
                }
                if (BigDecimal.class.equals(type)) {
                    result.unblockSuccess(n);
                    break block11;
                }
                throw new SerializationException("Unknown numeric value type " + type.getName());
            }
            catch (SerializationException e) {
                result.error(e);
            }
            catch (Exception e) {
                result.error(new SerializationException("Invalid numeric value", e));
            }
        }
    }

    public static Number convertStringToInteger(Class<?> type, String str, Class<? extends IntegerUnit> targetUnit) throws IntegerUnit.UnitConversionException, ParseException {
        BigInteger value;
        char c;
        int i;
        int l = str.length();
        for (i = 0; i < l && (c = str.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        if (i == l) {
            value = new BigInteger(str);
        } else {
            String unitStr = str.substring(i).trim();
            value = new BigInteger(str.substring(0, i));
            if (unitStr.length() > 0) {
                Class<? extends IntegerUnit> unit = IntegerUnit.ParserRegistry.get(unitStr);
                if (unit == null) {
                    throw new ParseException("Unknown integer unit: " + unitStr, i);
                }
                long val = IntegerUnit.ConverterRegistry.convert(value.longValue(), unit, targetUnit);
                value = BigInteger.valueOf(val);
            }
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return value.byteValueExact();
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return value.shortValueExact();
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return value.intValueExact();
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return value.longValueExact();
        }
        if (BigInteger.class.equals(type)) {
            return value;
        }
        throw new ParseException("Unknown integer type " + type.getName(), 0);
    }

    protected AsyncSupplier<Character, SerializationException> deserializeCharacterValue(boolean nullable) {
        AsyncSupplier<? extends CharSequence, SerializationException> read = this.deserializeStringValue();
        return AbstractDeserializer.deserializeCharacter(read, nullable);
    }

    protected AsyncSupplier<Character, SerializationException> deserializeCharacterAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        SerializationClass.Attribute fakeAttr = new SerializationClass.Attribute(context.getAttribute());
        fakeAttr.setType(new TypeDefinition(String.class, new TypeDefinition[0]));
        SerializationContext.AttributeContext fakeContext = new SerializationContext.AttributeContext(context.getParent(), fakeAttr);
        AsyncSupplier<? extends CharSequence, SerializationException> read = this.deserializeStringAttributeValue(fakeContext);
        return AbstractDeserializer.deserializeCharacter(read, nullable);
    }

    private static AsyncSupplier<Character, SerializationException> deserializeCharacter(AsyncSupplier<? extends CharSequence, SerializationException> read, boolean nullable) {
        AsyncSupplier<Character, SerializationException> result = new AsyncSupplier<Character, SerializationException>();
        read.onDone(string -> {
            if (string == null || string.length() == 0) {
                if (nullable) {
                    result.unblockSuccess(null);
                } else {
                    result.error(new SerializationException("Character value expected"));
                }
                return;
            }
            if (string.length() > 1) {
                result.error(new SerializationException("A single character value is expected, " + string.length() + " characters found"));
                return;
            }
            result.unblockSuccess(Character.valueOf(string.charAt(0)));
        }, result);
        return result;
    }

    protected abstract AsyncSupplier<? extends CharSequence, SerializationException> deserializeStringValue();

    protected AsyncSupplier<? extends CharSequence, SerializationException> deserializeStringAttributeValue(SerializationContext.AttributeContext context) {
        return this.deserializeStringValue();
    }

    protected AsyncSupplier<Object, SerializationException> deserializeCollectionValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        TypeDefinition elementType;
        Collection col;
        AsyncSupplier<Boolean, SerializationException> start = this.startCollectionValue();
        AsyncSupplier<Object, SerializationException> result = new AsyncSupplier<Object, SerializationException>();
        if (type.getBase().isArray()) {
            col = new LinkedList();
            elementType = new TypeDefinition(type.getBase().getComponentType(), new TypeDefinition[0]);
        } else {
            try {
                col = (Collection)SerializationClass.instantiate(type, context, rules, false);
            }
            catch (SerializationException e) {
                return new AsyncSupplier<Object, SerializationException>(null, e);
            }
            catch (Exception e) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error instantiating collection", e));
            }
            if (type.getParameters().isEmpty()) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Cannot deserialize collection without an element type specified"));
            }
            elementType = type.getParameters().get(0);
        }
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, col, type, elementType);
        start.thenDoOrStart(res -> {
            if (!res.booleanValue()) {
                result.unblockSuccess(null);
            } else {
                this.deserializeNextCollectionValueElement(ctx, 0, path, rules, result);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected abstract AsyncSupplier<Boolean, SerializationException> startCollectionValue();

    protected void deserializeNextCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        this.deserializeCollectionValueElement(context, elementIndex, colPath, rules, false, result);
    }

    private void deserializeCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules, boolean isAttribute, AsyncSupplier<Object, SerializationException> result) {
        while (true) {
            AsyncSupplier<Pair<Object, Boolean>, SerializationException> next;
            AsyncSupplier<Pair<Object, Boolean>, SerializationException> asyncSupplier = next = isAttribute ? this.deserializeCollectionAttributeValueElement(context, elementIndex, colPath, rules) : this.deserializeCollectionValueElement(context, elementIndex, colPath, rules);
            if (!next.isDone()) {
                int currentIndex = elementIndex;
                next.onDone(p -> {
                    if (!((Boolean)p.getValue2()).booleanValue()) {
                        if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                            result.unblockSuccess(context.getCollection());
                        } else {
                            result.unblockSuccess(AbstractDeserializer.toArray(context));
                        }
                        return;
                    }
                    new DeserializationTask(() -> {
                        Object element = p.getValue1();
                        if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                            result.error(new SerializationException("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                            return;
                        }
                        ((Collection)context.getCollection()).add(element);
                        if (isAttribute) {
                            this.deserializeNextCollectionAttributeValueElement(context, currentIndex + 1, colPath, rules, result);
                        } else {
                            this.deserializeNextCollectionValueElement(context, currentIndex + 1, colPath, rules, result);
                        }
                    }).start();
                }, result);
                return;
            }
            if (next.hasError()) {
                result.error(next.getError());
                return;
            }
            Pair<Object, Boolean> p2 = next.getResult();
            if (!p2.getValue2().booleanValue()) {
                if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                    result.unblockSuccess(context.getCollection());
                } else {
                    result.unblockSuccess(AbstractDeserializer.toArray(context));
                }
                return;
            }
            Object element = p2.getValue1();
            if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                result.error(new SerializationException("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                return;
            }
            ((Collection)context.getCollection()).add(element);
            ++elementIndex;
        }
    }

    protected abstract AsyncSupplier<Pair<Object, Boolean>, SerializationException> deserializeCollectionValueElement(SerializationContext.CollectionContext var1, int var2, String var3, List<SerializationRule> var4);

    protected AsyncSupplier<Object, SerializationException> deserializeCollectionAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        TypeDefinition elementType;
        Collection col;
        AsyncSupplier<Boolean, SerializationException> start = this.startCollectionAttributeValue(context);
        TypeDefinition colType = context.getAttribute().getType();
        if (colType.getBase().isArray()) {
            col = new LinkedList();
            Class<Object> t = colType.getBase().getComponentType();
            if (t.equals(Boolean.TYPE)) {
                t = Boolean.class;
            } else if (t.equals(Byte.TYPE)) {
                t = Byte.class;
            } else if (t.equals(Short.TYPE)) {
                t = Short.class;
            } else if (t.equals(Integer.TYPE)) {
                t = Integer.class;
            } else if (t.equals(Long.TYPE)) {
                t = Long.class;
            } else if (t.equals(Float.TYPE)) {
                t = Float.class;
            } else if (t.equals(Double.TYPE)) {
                t = Double.class;
            } else if (t.equals(Character.TYPE)) {
                t = Character.class;
            }
            elementType = new TypeDefinition(t, new TypeDefinition[0]);
        } else {
            try {
                col = (Collection)SerializationClass.instantiate(colType, context, rules, false);
            }
            catch (SerializationException e) {
                return new AsyncSupplier<Object, SerializationException>(null, e);
            }
            catch (Exception e) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error instantiating collection", e));
            }
            if (colType.getParameters().isEmpty()) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Cannot deserialize collection without an element type specified"));
            }
            elementType = colType.getParameters().get(0);
        }
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, col, colType, elementType);
        AsyncSupplier<Object, SerializationException> result = new AsyncSupplier<Object, SerializationException>();
        start.thenDoOrStart(r -> {
            if (!r.booleanValue()) {
                result.unblockSuccess(null);
            } else {
                this.deserializeNextCollectionAttributeValueElement(ctx, 0, path, rules, result);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected AsyncSupplier<Boolean, SerializationException> startCollectionAttributeValue(SerializationContext.AttributeContext context) {
        return this.startCollectionValue();
    }

    protected void deserializeNextCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        this.deserializeCollectionValueElement(context, elementIndex, colPath, rules, true, result);
    }

    protected static Object toArray(SerializationContext.CollectionContext context) {
        Class<?> t = context.getCollectionType().getBase().getComponentType();
        Collection col = (Collection)context.getCollection();
        if (t.equals(Boolean.TYPE)) {
            boolean[] a = new boolean[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Boolean)o;
            }
            return a;
        }
        if (t.equals(Byte.TYPE)) {
            byte[] a = new byte[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Byte)o;
            }
            return a;
        }
        if (t.equals(Short.TYPE)) {
            short[] a = new short[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Short)o;
            }
            return a;
        }
        if (t.equals(Integer.TYPE)) {
            int[] a = new int[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Integer)o;
            }
            return a;
        }
        if (t.equals(Long.TYPE)) {
            long[] a = new long[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Long)o;
            }
            return a;
        }
        if (t.equals(Float.TYPE)) {
            float[] a = new float[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = ((Float)o).floatValue();
            }
            return a;
        }
        if (t.equals(Double.TYPE)) {
            double[] a = new double[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Double)o;
            }
            return a;
        }
        if (t.equals(Character.TYPE)) {
            char[] a = new char[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = ((Character)o).charValue();
            }
            return a;
        }
        return col.toArray((Object[])Array.newInstance(t, col.size()));
    }

    protected AsyncSupplier<Pair<Object, Boolean>, SerializationException> deserializeCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        return this.deserializeCollectionValueElement(context, elementIndex, colPath, rules);
    }

    protected AsyncSupplier<Map<?, ?>, SerializationException> deserializeMapValue(SerializationContext context, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, typeDef.getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        AsyncSupplier<Object, SerializationException> value = this.deserializeValueType(context, type, path, rules);
        AsyncSupplier result = new AsyncSupplier();
        value.thenDoOrStart(val -> {
            try {
                result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)val, typeDef, context, rules));
            }
            catch (SerializationException e) {
                result.error(e);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected AsyncSupplier<Map<?, ?>, SerializationException> deserializeMapAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, context.getAttribute().getType().getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        SerializationClass.Attribute fakeAttribute = new SerializationClass.Attribute(context.getAttribute());
        fakeAttribute.setType(type);
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context.getParent(), fakeAttribute);
        AsyncSupplier<Object, SerializationException> value = this.deserializeCollectionAttributeValue(ctx, path, rules);
        AsyncSupplier result = new AsyncSupplier();
        value.thenDoOrStart(val -> {
            try {
                result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)val, context.getAttribute().getType(), context, rules));
            }
            catch (SerializationException e) {
                result.error(e);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected static Map<?, ?> getMap(ArrayList<SerializationUtil.MapEntry> entries, TypeDefinition type, SerializationContext context, List<SerializationRule> rules) throws SerializationException {
        try {
            Map map = (Map)SerializationClass.instantiate(type, context, rules, false);
            for (SerializationUtil.MapEntry entry : entries) {
                map.put(entry.key, entry.value);
            }
            return map;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw SerializationException.instantiation(type.toString(), e);
        }
    }

    protected AsyncSupplier<InputStream, SerializationException> deserializeInputStreamValue(SerializationContext context, List<SerializationRule> rules) {
        AsyncSupplier<IO.Readable, SerializationException> io = this.deserializeIOReadableValue(context, rules);
        AsyncSupplier<InputStream, SerializationException> result = new AsyncSupplier<InputStream, SerializationException>();
        io.thenDoOrStart(ior -> result.unblockSuccess(ior != null ? IOAsInputStream.get(ior, false) : null), this.taskDescription, this.priority, result);
        return result;
    }

    protected AsyncSupplier<InputStream, SerializationException> deserializeInputStreamAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        AsyncSupplier<IO.Readable, SerializationException> io = this.deserializeIOReadableAttributeValue(context, rules);
        AsyncSupplier<InputStream, SerializationException> result = new AsyncSupplier<InputStream, SerializationException>();
        io.thenDoOrStart(ior -> result.unblockSuccess(ior != null ? IOAsInputStream.get(ior, false) : null), this.taskDescription, this.priority, result);
        return result;
    }

    @Override
    public void addStreamReferenceHandler(Deserializer.StreamReferenceHandler handler) {
        this.streamReferenceHandlers.add(handler);
    }

    protected abstract AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableValue(SerializationContext var1, List<SerializationRule> var2);

    protected abstract AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableAttributeValue(SerializationContext.AttributeContext var1, List<SerializationRule> var2);

    protected AsyncSupplier<byte[], SerializationException> deserializeByteArrayValue(SerializationContext context, List<SerializationRule> rules) {
        AsyncSupplier<IO.Readable, SerializationException> io = this.deserializeIOReadableValue(context, rules);
        return this.deserializeByteArray(io);
    }

    protected AsyncSupplier<byte[], SerializationException> deserializeByteArrayAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        AsyncSupplier<IO.Readable, SerializationException> io = this.deserializeIOReadableAttributeValue(context, rules);
        return this.deserializeByteArray(io);
    }

    private AsyncSupplier<byte[], SerializationException> deserializeByteArray(AsyncSupplier<IO.Readable, SerializationException> io) {
        AsyncSupplier<byte[], IOException> res = new AsyncSupplier<byte[], IOException>();
        AsyncSupplier<byte[], SerializationException> result = new AsyncSupplier<byte[], SerializationException>();
        res.forward(result, ioe -> new SerializationException("Error deserializing byte array", (Throwable)ioe));
        io.thenDoOrStart(ior -> {
            if (ior == null) {
                result.unblockSuccess(null);
            } else {
                IOUtil.readFully(ior, res);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected <T> AsyncSupplier<T, SerializationException> deserializeObjectValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        AsyncSupplier<Object, SerializationException> start = this.startObjectValue(context, type, rules);
        AsyncSupplier result = new AsyncSupplier();
        start.thenDoOrStart(instance -> {
            if (instance == null) {
                result.unblockSuccess(null);
            } else {
                this.deserializeObjectAttributes(context, instance, type, path, rules, result);
            }
        }, this.taskDescription, this.priority, result);
        return result;
    }

    protected abstract AsyncSupplier<Object, SerializationException> startObjectValue(SerializationContext var1, TypeDefinition var2, List<SerializationRule> var3);

    protected void deserializeObjectAttributes(SerializationContext parentContext, Object instance, TypeDefinition typeDef, String path, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        SerializationContext.ObjectContext ctx;
        try {
            SerializationClass sc = new SerializationClass(typeDef != null ? TypeDefinition.from(instance.getClass(), typeDef) : new TypeDefinition(instance.getClass(), new TypeDefinition[0]));
            ctx = new SerializationContext.ObjectContext(parentContext, instance, sc, typeDef);
            rules = this.addRulesForType(sc, rules);
            sc.apply(rules, ctx, false);
        }
        catch (SerializationException e) {
            result.error(e);
            return;
        }
        this.deserializeNextObjectAttribute(ctx, path, rules, result);
    }

    private static SerializationClass.Attribute checkNextAttributeName(String n, SerializationContext.ObjectContext context, String path, AsyncSupplier<Object, SerializationException> result) {
        if (n == null) {
            result.unblockSuccess(context.getInstance());
            return null;
        }
        SerializationClass.Attribute a = context.getSerializationClass().getAttributeByName(n);
        if (a == null) {
            result.error(new SerializationException("Unknown attribute " + n + " for type " + context.getInstance().getClass().getName() + " in " + path));
            return null;
        }
        if (!a.canSet()) {
            result.error(new SerializationException("Attribute " + n + " cannot be set on type " + context.getInstance().getClass().getName()));
            return null;
        }
        return a;
    }

    protected void deserializeNextObjectAttribute(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        AsyncSupplier<String, SerializationException> name;
        while ((name = this.deserializeObjectAttributeName(context)).isDone()) {
            if (name.hasError()) {
                result.error(name.getError());
                return;
            }
            String n2 = name.getResult();
            SerializationClass.Attribute a = AbstractDeserializer.checkNextAttributeName(n2, context, path, result);
            if (a == null) {
                return;
            }
            IAsync<SerializationException> val = this.deserializeObjectAttributeValue(context, a, path + '.' + n2, rules);
            if (val.isDone()) {
                if (!val.forwardIfNotSuccessful(result)) continue;
                return;
            }
            val.thenStart(new DeserializationTask(() -> this.deserializeNextObjectAttribute(context, path, rules, result)), result);
            return;
        }
        name.onDone(n -> {
            if (n == null) {
                result.unblockSuccess(context.getInstance());
                return;
            }
            new DeserializationTask(() -> {
                SerializationClass.Attribute a = AbstractDeserializer.checkNextAttributeName(n, context, path, result);
                if (a == null) {
                    return;
                }
                IAsync<SerializationException> val = this.deserializeObjectAttributeValue(context, a, path + '.' + n, rules);
                if (val.isDone()) {
                    if (val.forwardIfNotSuccessful(result)) {
                        return;
                    }
                    this.deserializeNextObjectAttribute(context, path, rules, result);
                    return;
                }
                val.thenStart(new DeserializationTask(() -> this.deserializeNextObjectAttribute(context, path, rules, result)), result);
            }).start();
        }, result);
    }

    protected abstract AsyncSupplier<String, SerializationException> deserializeObjectAttributeName(SerializationContext.ObjectContext var1);

    protected IAsync<SerializationException> deserializeObjectAttributeValue(SerializationContext.ObjectContext context, SerializationClass.Attribute a, String path, List<SerializationRule> rules) {
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context, a);
        AsyncSupplier<?, SerializationException> value = this.deserializeObjectAttributeValue(ctx, path, rules);
        Async<SerializationException> sp = new Async<SerializationException>();
        value.thenDoOrStart(val -> {
            if (!a.ignore()) {
                try {
                    a.setValue(context.getInstance(), val);
                }
                catch (SerializationException e) {
                    sp.error(e);
                    return;
                }
            }
            sp.unblock();
        }, this.taskDescription, this.priority, sp);
        return sp;
    }

    protected AsyncSupplier<?, SerializationException> deserializeObjectAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        SerializationClass.Attribute a = context.getAttribute();
        TypeDefinition type = a.getType();
        Class<?> c = type.getBase();
        rules = this.addRulesForAttribute(a, rules);
        if (c.isArray()) {
            if (byte[].class.equals(c)) {
                return this.deserializeByteArrayAttributeValue(context, rules);
            }
            return this.deserializeCollectionAttributeValue(context, path, rules);
        }
        if (Boolean.TYPE.equals(c)) {
            return this.deserializeBooleanAttributeValue(context, false);
        }
        if (Boolean.class.equals(c)) {
            return this.deserializeBooleanAttributeValue(context, true);
        }
        if (Byte.TYPE.equals(c) || Short.TYPE.equals(c) || Integer.TYPE.equals(c) || Long.TYPE.equals(c) || Float.TYPE.equals(c) || Double.TYPE.equals(c)) {
            return this.deserializeNumericAttributeValue(context, false);
        }
        if (Number.class.isAssignableFrom(c)) {
            return this.deserializeNumericAttributeValue(context, true);
        }
        if (Character.TYPE.equals(c)) {
            return this.deserializeCharacterAttributeValue(context, false);
        }
        if (Character.class.equals(c)) {
            return this.deserializeCharacterAttributeValue(context, true);
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            AsyncSupplier<? extends CharSequence, SerializationException> str = this.deserializeStringAttributeValue(context);
            return this.convertFromStringToCharSequence(str, c);
        }
        if (c.isEnum()) {
            AsyncSupplier<? extends CharSequence, SerializationException> str = this.deserializeStringAttributeValue(context);
            AsyncSupplier result = new AsyncSupplier();
            str.onDone(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                try {
                    result.unblockSuccess(Enum.valueOf(c, string.toString()));
                }
                catch (IllegalArgumentException e) {
                    result.error(new SerializationException("Unknown enum value '" + string + "' for " + c.getName()));
                }
            }, result);
            return result;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return this.deserializeCollectionAttributeValue(context, path, rules);
        }
        if (Map.class.isAssignableFrom(c)) {
            return this.deserializeMapAttributeValue(context, path, rules);
        }
        if (InputStream.class.isAssignableFrom(c)) {
            return this.deserializeInputStreamAttributeValue(context, rules);
        }
        if (IO.Readable.class.isAssignableFrom(c)) {
            return this.deserializeIOReadableAttributeValue(context, rules);
        }
        return this.deserializeObjectAttributeObjectValue(context, path, rules);
    }

    protected AsyncSupplier<Object, SerializationException> convertFromStringToCharSequence(AsyncSupplier<? extends CharSequence, SerializationException> str, Class<?> target) {
        AsyncSupplier<Object, SerializationException> result = new AsyncSupplier<Object, SerializationException>();
        str.onDone(string -> {
            if (string == null) {
                result.unblockSuccess(null);
                return;
            }
            if (target.isAssignableFrom(string.getClass())) {
                result.unblockSuccess(string);
                return;
            }
            for (Constructor<?> ctor : target.getConstructors()) {
                Class<?>[] params = ctor.getParameterTypes();
                if (params.length != 1) continue;
                if (params[0].isAssignableFrom(string.getClass())) {
                    try {
                        result.unblockSuccess(ctor.newInstance(string));
                    }
                    catch (Exception t) {
                        result.error(SerializationException.instantiation(target.getName(), t));
                    }
                    return;
                }
                if (!params[0].isAssignableFrom(String.class)) continue;
                try {
                    result.unblockSuccess(ctor.newInstance(string.toString()));
                }
                catch (Exception t) {
                    result.error(SerializationException.instantiation(target.getName(), t));
                }
                return;
            }
            result.error(new SerializationException("Type " + target.getName() + " does not have a compatible constructor with parameter type " + string.getClass() + " or String"));
        }, result);
        return result;
    }

    protected AsyncSupplier<Object, SerializationException> deserializeObjectAttributeObjectValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        return this.deserializeObjectValue(context, context.getAttribute().getType(), path, rules);
    }

    protected class DeserializationTask
    extends Task.Cpu<Void, NoException> {
        private Runnable run;

        public DeserializationTask(Runnable run) {
            super(AbstractDeserializer.this.taskDescription, AbstractDeserializer.this.priority);
            this.run = run;
        }

        @Override
        public Void run() throws CancelException {
            try {
                this.run.run();
            }
            catch (Exception t) {
                throw new CancelException("Error thrown in deserialization", t);
            }
            return null;
        }
    }
}

