/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.SerializationSpecWriter;
import net.lecousin.framework.io.serialization.SerializationUtil;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public abstract class AbstractSerializationSpecWriter
implements SerializationSpecWriter {
    protected byte priority;

    protected abstract IAsync<SerializationException> initializeSpecWriter(IO.Writable var1);

    protected abstract IAsync<SerializationException> finalizeSpecWriter();

    @Override
    public IAsync<SerializationException> writeSpecification(Class<?> type, IO.Writable output, List<SerializationRule> rules) {
        this.priority = output.getPriority();
        IAsync<SerializationException> init = this.initializeSpecWriter(output);
        Async<SerializationException> result = new Async<SerializationException>();
        init.thenStart(new SpecTask(() -> {
            IAsync<SerializationException> sp = type != null ? this.specifyValue(null, new TypeDefinition(type, new TypeDefinition[0]), rules) : this.specifyAnyValue(null);
            sp.onDone(() -> this.finalizeSpecWriter().onDone(result), result);
        }), result);
        return result;
    }

    protected List<SerializationRule> addRulesForType(SerializationClass type, List<SerializationRule> currentList) {
        currentList = TypeAnnotationToRule.addRules(type.getType().getBase(), currentList);
        currentList = AttributeAnnotationToRuleOnType.addRules(type, true, currentList);
        return currentList;
    }

    protected List<SerializationRule> addRulesForAttribute(SerializationClass.Attribute a, List<SerializationRule> currentList) {
        return AttributeAnnotationToRuleOnAttribute.addRules(a, true, currentList);
    }

    protected abstract IAsync<SerializationException> specifyAnyValue(SerializationContext var1);

    public IAsync<SerializationException> specifyValue(SerializationContext context, TypeDefinition typeDef, List<SerializationRule> rules) {
        Object elementType;
        for (SerializationRule rule : rules) {
            typeDef = rule.getDeserializationType(typeDef, context);
        }
        Class<?> type = typeDef.getBase();
        if (type.isArray()) {
            if (byte[].class.equals(type)) {
                return this.specifyByteArrayValue(context, rules);
            }
            elementType = type.getComponentType();
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, null, typeDef, new TypeDefinition((Class<?>)elementType, new TypeDefinition[0]));
            return this.specifyCollectionValue(ctx, rules);
        }
        if (Boolean.TYPE.equals(type)) {
            return this.specifyBooleanValue(context, false);
        }
        if (Boolean.class.equals(type)) {
            return this.specifyBooleanValue(context, true);
        }
        if (Byte.TYPE.equals(type)) {
            return this.specifyNumericValue(context, Byte.class, false, (byte)-128, (byte)127);
        }
        if (Byte.class.equals(type)) {
            return this.specifyNumericValue(context, Byte.class, true, (byte)-128, (byte)127);
        }
        if (Short.TYPE.equals(type)) {
            return this.specifyNumericValue(context, Short.class, false, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        if (Short.class.equals(type)) {
            return this.specifyNumericValue(context, Short.class, true, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        if (Integer.TYPE.equals(type)) {
            return this.specifyNumericValue(context, Integer.class, false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (Integer.class.equals(type)) {
            return this.specifyNumericValue(context, Integer.class, true, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (Long.TYPE.equals(type)) {
            return this.specifyNumericValue(context, Long.class, false, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (Long.class.equals(type)) {
            return this.specifyNumericValue(context, Long.class, true, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (Float.TYPE.equals(type) || Double.TYPE.equals(type) || Number.class.isAssignableFrom(type)) {
            return this.specifyNumericValue(context, type, !type.isPrimitive(), null, null);
        }
        if (Character.TYPE.equals(type)) {
            return this.specifyCharacterValue(context, false);
        }
        if (Character.class.equals(type)) {
            return this.specifyCharacterValue(context, true);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return this.specifyStringValue(context, typeDef);
        }
        if (type.isEnum()) {
            return this.specifyEnumValue(context, typeDef);
        }
        if (Collection.class.isAssignableFrom(type)) {
            elementType = typeDef.getParameters().isEmpty() ? null : typeDef.getParameters().get(0);
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, null, typeDef, (TypeDefinition)elementType);
            return this.specifyCollectionValue(ctx, rules);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.specifyMapValue(context, typeDef, rules);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return this.specifyInputStreamValue(context, rules);
        }
        if (IO.Readable.class.isAssignableFrom(type)) {
            return this.specifyIOReadableValue(context, rules);
        }
        return this.specifyObjectValue(context, typeDef, rules);
    }

    protected abstract IAsync<SerializationException> specifyBooleanValue(SerializationContext var1, boolean var2);

    protected abstract IAsync<SerializationException> specifyNumericValue(SerializationContext var1, Class<?> var2, boolean var3, Number var4, Number var5);

    protected abstract IAsync<SerializationException> specifyCharacterValue(SerializationContext var1, boolean var2);

    protected abstract IAsync<SerializationException> specifyStringValue(SerializationContext var1, TypeDefinition var2);

    protected abstract IAsync<SerializationException> specifyEnumValue(SerializationContext var1, TypeDefinition var2);

    protected abstract IAsync<SerializationException> specifyCollectionValue(SerializationContext.CollectionContext var1, List<SerializationRule> var2);

    protected IAsync<SerializationException> specifyMapValue(SerializationContext context, TypeDefinition type, List<SerializationRule> rules) {
        TypeDefinition elementType = new TypeDefinition(SerializationUtil.MapEntry.class, type.getParameters());
        TypeDefinition colType = new TypeDefinition(ArrayList.class, elementType);
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, null, colType, elementType);
        return this.specifyCollectionValue(ctx, rules);
    }

    protected IAsync<SerializationException> specifyInputStreamValue(SerializationContext context, List<SerializationRule> rules) {
        return this.specifyIOReadableValue(context, rules);
    }

    protected abstract IAsync<SerializationException> specifyIOReadableValue(SerializationContext var1, List<SerializationRule> var2);

    protected IAsync<SerializationException> specifyByteArrayValue(SerializationContext context, List<SerializationRule> rules) {
        return this.specifyIOReadableValue(context, rules);
    }

    protected IAsync<SerializationException> specifyObjectValue(SerializationContext context, TypeDefinition typeDef, List<SerializationRule> rules) {
        SerializationContext.ObjectContext ctx;
        try {
            Class<?> type = typeDef.getBase();
            SerializationClass sc = new SerializationClass(TypeDefinition.from(type, typeDef));
            ctx = new SerializationContext.ObjectContext(context, null, sc, typeDef);
            rules = this.addRulesForType(sc, rules);
            sc.apply(rules, ctx, true);
        }
        catch (SerializationException e) {
            return new Async<SerializationException>(e);
        }
        return this.specifyTypedValue(ctx, rules);
    }

    protected abstract IAsync<SerializationException> specifyTypedValue(SerializationContext.ObjectContext var1, List<SerializationRule> var2);

    protected IAsync<SerializationException> specifyTypeContent(SerializationContext.ObjectContext context, List<SerializationRule> rules) {
        List<SerializationClass.Attribute> attributes = this.sortAttributes(context.getSerializationClass().getAttributes());
        Async<SerializationException> sp = new Async<SerializationException>();
        this.specifyTypeAttribute(context, attributes, 0, rules, sp);
        return sp;
    }

    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        return attributes;
    }

    protected void specifyTypeAttribute(SerializationContext.ObjectContext context, List<SerializationClass.Attribute> attributes, int index, List<SerializationRule> rules, Async<SerializationException> sp) {
        if (index == attributes.size()) {
            sp.unblock();
            return;
        }
        SerializationClass.Attribute attr = attributes.get(index);
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context, attr);
        IAsync<SerializationException> s = this.specifyTypeAttribute(ctx, rules);
        if (s.isDone()) {
            if (s.hasError()) {
                sp.error(s.getError());
            } else {
                this.specifyTypeAttribute(context, attributes, index + 1, rules, sp);
            }
            return;
        }
        s.thenStart(new SpecTask(() -> this.specifyTypeAttribute(context, attributes, index + 1, rules, sp)), sp);
    }

    protected abstract IAsync<SerializationException> specifyTypeAttribute(SerializationContext.AttributeContext var1, List<SerializationRule> var2);

    protected class SpecTask
    extends Task.Cpu<Void, NoException> {
        private Runnable r;

        public SpecTask(Runnable r) {
            super("Write Specification", AbstractSerializationSpecWriter.this.priority);
            this.r = r;
        }

        @Override
        public Void run() {
            this.r.run();
            return null;
        }
    }
}

