/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.SerializationUtil;
import net.lecousin.framework.io.serialization.Serializer;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public abstract class AbstractSerializer
implements Serializer {
    protected byte priority;

    protected abstract IAsync<SerializationException> initializeSerialization(IO.Writable var1);

    protected abstract IAsync<SerializationException> finalizeSerialization();

    @Override
    public IAsync<SerializationException> serialize(Object object, TypeDefinition typeDef, IO.Writable output, List<SerializationRule> rules) {
        this.priority = output.getPriority();
        IAsync<SerializationException> init = this.initializeSerialization(output);
        Async<SerializationException> result = new Async<SerializationException>();
        init.thenStart(new SerializationTask(() -> {
            IAsync<SerializationException> sp = this.serializeValue(null, object, typeDef, "", rules);
            sp.onDone(() -> this.finalizeSerialization().onDone(result), result);
        }), result);
        return result;
    }

    protected List<SerializationRule> addRulesForType(SerializationClass type, List<SerializationRule> currentList) {
        currentList = TypeAnnotationToRule.addRules(type, currentList);
        currentList = AttributeAnnotationToRuleOnType.addRules(type, true, currentList);
        return currentList;
    }

    protected List<SerializationRule> addRulesForAttribute(SerializationClass.Attribute a, List<SerializationRule> currentList) {
        currentList = AttributeAnnotationToRuleOnAttribute.addRules(a, true, currentList);
        return currentList;
    }

    public IAsync<SerializationException> serializeValue(SerializationContext context, Object value, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        Object elementType;
        if (value == null) {
            return this.serializeNullValue();
        }
        for (SerializationRule rule : rules) {
            try {
                value = rule.convertSerializationValue(value, typeDef, context);
            }
            catch (SerializationException e) {
                return new Async<SerializationException>(e);
            }
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (value instanceof byte[]) {
                return this.serializeByteArrayValue(context, (byte[])value, path, rules);
            }
            elementType = type.getComponentType();
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, value, typeDef, new TypeDefinition((Class<?>)elementType, new TypeDefinition[0]));
            return this.serializeCollectionValue(ctx, path, rules);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return this.serializeBooleanValue((Boolean)value);
        }
        if (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type) || Number.class.isAssignableFrom(type)) {
            return this.serializeNumericValue((Number)value);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return this.serializeCharacterValue(((Character)value).charValue());
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return this.serializeStringValue((CharSequence)value);
        }
        if (type.isEnum()) {
            return this.serializeStringValue(((Enum)value).name());
        }
        if (Collection.class.isAssignableFrom(type)) {
            elementType = typeDef.getParameters().isEmpty() ? null : typeDef.getParameters().get(0);
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, value, typeDef, (TypeDefinition)elementType);
            return this.serializeCollectionValue(ctx, path, rules);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.serializeMapValue(context, (Map)value, typeDef, path, rules);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return this.serializeInputStreamValue(context, (InputStream)value, path, rules);
        }
        if (IO.Readable.class.isAssignableFrom(type)) {
            return this.serializeIOReadableValue(context, (IO.Readable)value, path, rules);
        }
        return this.serializeObjectValue(context, value, typeDef, path, rules);
    }

    protected abstract IAsync<SerializationException> serializeNullValue();

    protected abstract IAsync<SerializationException> serializeNullAttribute(SerializationContext.AttributeContext var1, String var2);

    protected abstract IAsync<SerializationException> serializeBooleanValue(boolean var1);

    protected abstract IAsync<SerializationException> serializeBooleanAttribute(SerializationContext.AttributeContext var1, boolean var2, String var3);

    protected abstract IAsync<SerializationException> serializeNumericValue(Number var1);

    protected abstract IAsync<SerializationException> serializeNumericAttribute(SerializationContext.AttributeContext var1, Number var2, String var3);

    protected abstract IAsync<SerializationException> serializeCharacterValue(char var1);

    protected abstract IAsync<SerializationException> serializeCharacterAttribute(SerializationContext.AttributeContext var1, char var2, String var3);

    protected abstract IAsync<SerializationException> serializeStringValue(CharSequence var1);

    protected abstract IAsync<SerializationException> serializeStringAttribute(SerializationContext.AttributeContext var1, CharSequence var2, String var3);

    protected IAsync<SerializationException> serializeObjectValue(SerializationContext context, Object value, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        SerializationContext.ObjectContext ctx;
        try {
            Class<?> type = value.getClass();
            SerializationClass sc = new SerializationClass(typeDef != null ? TypeDefinition.from(type, typeDef) : new TypeDefinition(type, new TypeDefinition[0]));
            ctx = new SerializationContext.ObjectContext(context, value, sc, typeDef);
            rules = this.addRulesForType(sc, rules);
            sc.apply(rules, ctx, true);
        }
        catch (Exception e) {
            return new Async<SerializationException>(new SerializationException("Error serializing object " + typeDef, e));
        }
        return this.serializeObjectValue(ctx, path, rules);
    }

    protected IAsync<SerializationException> serializeObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        List<SerializationClass.Attribute> attributes = this.sortAttributes(context.getSerializationClass().getAttributes());
        IAsync<SerializationException> start = this.startObjectValue(context, path, rules);
        Async<SerializationException> result = new Async<SerializationException>();
        if (start.isDone()) {
            if (start.hasError()) {
                return start;
            }
            this.serializeAttribute(attributes, 0, context, path, rules, result);
        } else {
            start.thenStart(new SerializationTask(() -> this.serializeAttribute(attributes, 0, context, path, rules, result)), result);
        }
        return result;
    }

    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        return attributes;
    }

    protected abstract IAsync<SerializationException> startObjectValue(SerializationContext.ObjectContext var1, String var2, List<SerializationRule> var3);

    protected abstract IAsync<SerializationException> endObjectValue(SerializationContext.ObjectContext var1, String var2, List<SerializationRule> var3);

    protected void serializeAttribute(final List<SerializationClass.Attribute> attributes, int attributeIndex, final SerializationContext.ObjectContext context, final String containerPath, final List<SerializationRule> rules, final Async<SerializationException> result) {
        IAsync<SerializationException> sp;
        block5: {
            while (true) {
                if (attributeIndex >= attributes.size()) {
                    this.endObjectValue(context, containerPath, rules).onDone(result);
                    return;
                }
                SerializationClass.Attribute a = attributes.get(attributeIndex);
                if (a.ignore() || !a.canGet()) {
                    ++attributeIndex;
                    continue;
                }
                SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context, a);
                List<SerializationRule> newRules = this.addRulesForAttribute(a, rules);
                sp = this.serializeAttribute(ctx, containerPath + '.' + a.getOriginalName(), newRules);
                if (!sp.isDone()) break block5;
                if (sp.hasError()) {
                    result.error(sp.getError());
                    break;
                }
                if (sp.isCancelled()) {
                    result.cancel(sp.getCancelEvent());
                    break;
                }
                ++attributeIndex;
            }
            return;
        }
        final int nextIndex = attributeIndex + 1;
        sp.thenStart(new Task.Cpu<Void, NoException>("Serialization", this.priority){

            @Override
            public Void run() {
                if (sp.hasError()) {
                    result.error(sp.getError());
                } else if (sp.isCancelled()) {
                    result.cancel(sp.getCancelEvent());
                } else {
                    AbstractSerializer.this.serializeAttribute(attributes, nextIndex, context, containerPath, rules, result);
                }
                return null;
            }
        }, true);
    }

    protected IAsync<SerializationException> serializeAttribute(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        Object value;
        try {
            value = context.getAttribute().getValue(context.getParent().getInstance());
        }
        catch (Exception e) {
            return new Async<SerializationException>(new SerializationException("Unable to get value of attribute " + context.getAttribute().getOriginalName() + " on " + context.getParent().getInstance().getClass().getName(), e));
        }
        if (value == null) {
            return this.serializeNullAttribute(context, path);
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (byte[].class.equals(type)) {
                return this.serializeByteArrayAttribute(context, (byte[])value, path, rules);
            }
            Class<?> elementType = type.getComponentType();
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, value, context.getAttribute().getType(), new TypeDefinition(elementType, new TypeDefinition[0]));
            return this.serializeCollectionAttribute(ctx, path, rules);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return this.serializeBooleanAttribute(context, (Boolean)value, path);
        }
        if (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type) || Number.class.isAssignableFrom(type)) {
            return this.serializeNumericAttribute(context, (Number)value, path);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return this.serializeCharacterAttribute(context, ((Character)value).charValue(), path);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return this.serializeStringAttribute(context, (CharSequence)value, path);
        }
        if (type.isEnum()) {
            return this.serializeStringAttribute(context, ((Enum)value).name(), path);
        }
        if (Collection.class.isAssignableFrom(type)) {
            TypeDefinition elementType = context.getAttribute().getType().getParameters().isEmpty() ? null : context.getAttribute().getType().getParameters().get(0);
            SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, value, context.getAttribute().getType(), elementType);
            return this.serializeCollectionAttribute(ctx, path, rules);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.serializeMapAttribute(context, (Map)value, context.getAttribute().getType(), path, rules);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return this.serializeInputStreamAttribute(context, (InputStream)value, path, rules);
        }
        if (IO.Readable.class.isAssignableFrom(type)) {
            return this.serializeIOReadableAttribute(context, (IO.Readable)value, path, rules);
        }
        return this.serializeObjectAttribute(context, value, path, rules);
    }

    protected abstract IAsync<SerializationException> serializeObjectAttribute(SerializationContext.AttributeContext var1, Object var2, String var3, List<SerializationRule> var4);

    protected IAsync<SerializationException> serializeCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        IAsync<SerializationException> start = this.startCollectionValue(context, path, rules);
        Async<SerializationException> result = new Async<SerializationException>();
        if (start.isDone()) {
            this.serializeCollectionElement(context, context.getIterator(), 0, path, rules, result);
            return result;
        }
        start.thenStart(new SerializationTask(() -> this.serializeCollectionElement(context, context.getIterator(), 0, path, rules, result)), result);
        return result;
    }

    protected abstract IAsync<SerializationException> startCollectionValue(SerializationContext.CollectionContext var1, String var2, List<SerializationRule> var3);

    protected abstract IAsync<SerializationException> endCollectionValue(SerializationContext.CollectionContext var1, String var2, List<SerializationRule> var3);

    protected abstract IAsync<SerializationException> startCollectionValueElement(SerializationContext.CollectionContext var1, Object var2, int var3, String var4, List<SerializationRule> var5);

    protected abstract IAsync<SerializationException> endCollectionValueElement(SerializationContext.CollectionContext var1, Object var2, int var3, String var4, List<SerializationRule> var5);

    protected void serializeCollectionElement(SerializationContext.CollectionContext context, Iterator<?> it, int elementIndex, String colPath, List<SerializationRule> rules, Async<SerializationException> result) {
        int currentIndex;
        Async next;
        while (true) {
            if (!it.hasNext()) {
                this.endCollectionValue(context, colPath, rules).onDone(result);
                return;
            }
            Object element = it.next();
            String elementPath = colPath + '[' + elementIndex + ']';
            IAsync<SerializationException> start = this.startCollectionValueElement(context, element, elementIndex, elementPath, rules);
            Async<SerializationException> value = new Async<SerializationException>();
            if (start.isDone()) {
                if (start.hasError()) {
                    value.error(start.getError());
                } else {
                    this.serializeValue(context, element, context.getElementType(), elementPath, rules).onDone(value);
                }
            } else {
                start.thenStart(new SerializationTask(() -> this.serializeValue(context, element, context.getElementType(), elementPath, rules).onDone(value)), value);
            }
            next = new Async();
            currentIndex = elementIndex;
            if (value.isDone()) {
                if (value.hasError()) {
                    next.error(value.getError());
                } else {
                    this.endCollectionValueElement(context, element, elementIndex, elementPath, rules).onDone(next);
                }
            } else {
                value.thenStart(new SerializationTask(() -> this.endCollectionValueElement(context, element, currentIndex, elementPath, rules).onDone(next)), next);
            }
            if (!next.isDone()) break;
            if (next.forwardIfNotSuccessful(result)) {
                return;
            }
            ++elementIndex;
        }
        next.thenStart(new SerializationTask(() -> {
            if (next.hasError()) {
                result.error((SerializationException)next.getError());
            } else {
                this.serializeCollectionElement(context, it, currentIndex + 1, colPath, rules, result);
            }
        }), result);
    }

    protected abstract IAsync<SerializationException> serializeCollectionAttribute(SerializationContext.CollectionContext var1, String var2, List<SerializationRule> var3);

    protected IAsync<SerializationException> serializeMapValue(SerializationContext context, Map<?, ?> map, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, typeDef.getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        ArrayList entries = new ArrayList(map.size());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            SerializationUtil.MapEntry me = new SerializationUtil.MapEntry();
            me.key = e.getKey();
            me.value = e.getValue();
            entries.add(me);
        }
        return this.serializeValue(context, entries, type, path, rules);
    }

    protected IAsync<SerializationException> serializeMapAttribute(SerializationContext.AttributeContext context, Map<?, ?> map, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, typeDef.getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        ArrayList entries = new ArrayList(map.size());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            SerializationUtil.MapEntry me = new SerializationUtil.MapEntry();
            me.key = e.getKey();
            me.value = e.getValue();
            entries.add(me);
        }
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, entries, type, type.getParameters().get(0));
        return this.serializeCollectionAttribute(ctx, path, rules);
    }

    protected IAsync<SerializationException> serializeInputStreamValue(SerializationContext context, InputStream in, String path, List<SerializationRule> rules) {
        return this.serializeIOReadableValue(context, new IOFromInputStream(in, in.toString(), Threading.getUnmanagedTaskManager(), this.priority), path, rules);
    }

    protected IAsync<SerializationException> serializeInputStreamAttribute(SerializationContext.AttributeContext context, InputStream in, String path, List<SerializationRule> rules) {
        return this.serializeIOReadableAttribute(context, new IOFromInputStream(in, in.toString(), Threading.getUnmanagedTaskManager(), this.priority), path, rules);
    }

    protected abstract IAsync<SerializationException> serializeIOReadableValue(SerializationContext var1, IO.Readable var2, String var3, List<SerializationRule> var4);

    protected abstract IAsync<SerializationException> serializeIOReadableAttribute(SerializationContext.AttributeContext var1, IO.Readable var2, String var3, List<SerializationRule> var4);

    protected IAsync<SerializationException> serializeByteArrayValue(SerializationContext context, byte[] bytes, String path, List<SerializationRule> rules) {
        return this.serializeIOReadableValue(context, new ByteArrayIO(bytes, "serialization of byte[]"), path, rules);
    }

    protected IAsync<SerializationException> serializeByteArrayAttribute(SerializationContext.AttributeContext context, byte[] bytes, String path, List<SerializationRule> rules) {
        return this.serializeIOReadableAttribute(context, new ByteArrayIO(bytes, "serialization of byte[]"), path, rules);
    }

    protected class SerializationTask
    extends Task.Cpu<Void, NoException> {
        private Runnable r;

        public SerializationTask(Runnable r) {
            super("Serialization", AbstractSerializer.this.priority);
            this.r = r;
        }

        @Override
        public Void run() throws CancelException {
            try {
                this.r.run();
            }
            catch (Exception t) {
                throw new CancelException("Error thrown by serialization", t);
            }
            return null;
        }
    }
}

