/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class SerializationClass {
    private TypeDefinition type;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public SerializationClass(TypeDefinition type) {
        this.type = type;
        this.populateAttributes();
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttributeByName(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute getAttributeByOriginalName(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getOriginalName())) continue;
            return a;
        }
        return null;
    }

    public void replaceAttribute(Attribute original, Attribute newAttribute) {
        ListIterator<Attribute> it = this.attributes.listIterator();
        while (it.hasNext()) {
            if (!it.next().equals(original)) continue;
            it.set(newAttribute);
            break;
        }
    }

    public void apply(List<SerializationRule> rules, SerializationContext context, boolean serializing) throws SerializationException {
        for (SerializationRule rule : rules) {
            if (rule.apply(this, context, rules, serializing)) break;
        }
    }

    private void populateAttributes() {
        this.populateAttributes(this.type.getBase(), this.type.getParameters());
        this.filterAttributes();
    }

    private void populateAttributes(Class<?> type, List<TypeDefinition> params) {
        if (Object.class.equals(type)) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            this.populateFieldAttribute(field);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            this.populateMethodAttribute((Method)accessibleObject, type, params);
        }
        if (type.getSuperclass() != null) {
            Type t = type.getGenericSuperclass();
            LinkedList<TypeDefinition> superParams = new LinkedList<TypeDefinition>();
            if (t instanceof ParameterizedType) {
                block2: for (Type arg : ((ParameterizedType)t).getActualTypeArguments()) {
                    if (arg instanceof TypeVariable) {
                        TypeVariable<Class<?>>[] typeArgs = type.getTypeParameters();
                        for (int i = 0; i < typeArgs.length; ++i) {
                            if (!typeArgs[i].getName().equals(((TypeVariable)arg).getName())) continue;
                            superParams.add(params.get(i));
                            continue block2;
                        }
                        continue;
                    }
                    superParams.add(new TypeDefinition(null, arg));
                }
            }
            this.populateAttributes(type.getSuperclass(), superParams);
        }
    }

    private void populateFieldAttribute(Field f) {
        if ((f.getModifiers() & 0x18) != 0) {
            return;
        }
        String name = f.getName();
        Attribute a = this.getAttributeByOriginalName(name);
        if (a == null) {
            a = new Attribute(this, f);
            this.attributes.add(a);
        }
    }

    private void populateMethodAttribute(Method m, Class<?> type, List<TypeDefinition> params) {
        if ((m.getModifiers() & 1) == 0) {
            return;
        }
        String name = m.getName();
        if (name.startsWith("get")) {
            if (name.length() == 3) {
                return;
            }
            if (m.getParameterCount() != 0) {
                return;
            }
            Class<?> returnType = m.getReturnType();
            if (returnType == null || Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
                return;
            }
            this.createAttributeFromGetter(Character.toLowerCase(name.charAt(3)) + name.substring(4), m, type, params);
        } else if (name.startsWith("is")) {
            if (name.length() == 2) {
                return;
            }
            if (m.getParameterCount() != 0) {
                return;
            }
            Class<?> returnType = m.getReturnType();
            if (returnType == null || !returnType.equals(Boolean.TYPE) && !returnType.equals(Boolean.class)) {
                return;
            }
            this.createAttributeFromGetterIs(Character.toLowerCase(name.charAt(2)) + name.substring(3), m, returnType);
        } else if (name.startsWith("set")) {
            if (name.length() == 3) {
                return;
            }
            if (m.getParameterCount() != 1) {
                return;
            }
            this.createAttributeFromSetter(Character.toLowerCase(name.charAt(3)) + name.substring(4), m, type, params);
        }
    }

    private void createAttributeFromGetter(String name, Method m, Class<?> type, List<TypeDefinition> params) {
        Attribute a = this.getAttributeByOriginalName(name);
        if (a == null) {
            a = new Attribute(this, name, new TypeDefinition(new TypeDefinition(type, params), m.getGenericReturnType()));
            this.attributes.add(a);
        }
        if (a.getter == null) {
            a.getter = m;
        }
    }

    private void createAttributeFromGetterIs(String name, Method m, Class<?> returnType) {
        Attribute a = this.getAttributeByOriginalName(name);
        if (a == null) {
            a = new Attribute(this, name, new TypeDefinition(returnType, new TypeDefinition[0]));
            this.attributes.add(a);
        }
        if (a.getter == null) {
            a.getter = m;
        }
    }

    private void createAttributeFromSetter(String name, Method m, Class<?> type, List<TypeDefinition> params) {
        Attribute a = this.getAttributeByOriginalName(name);
        if (a == null) {
            a = new Attribute(this, name, new TypeDefinition(new TypeDefinition(type, params), m.getGenericParameterTypes()[0]));
        }
        if (a.setter == null) {
            a.setter = m;
        }
    }

    private void filterAttributes() {
        Iterator<Attribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.canGet() || a.canSet()) continue;
            it.remove();
        }
    }

    public static TypeDefinition searchAttributeType(TypeDefinition containerType, String attributeName) {
        Class<?> returnType;
        Method m2;
        try {
            Field f = containerType.getBase().getField(attributeName);
            if ((f.getModifiers() & 0x18) != 0) {
                return new TypeDefinition(containerType, f.getGenericType());
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        try {
            m2 = containerType.getBase().getMethod("get" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1), new Class[0]);
            returnType = m2.getReturnType();
            if (returnType != null && !Void.class.equals(returnType) && !Void.TYPE.equals(returnType)) {
                return new TypeDefinition(containerType, m2.getGenericReturnType());
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = containerType.getBase().getMethod("is" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1), new Class[0]);
            returnType = m2.getReturnType();
            if (Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType)) {
                return new TypeDefinition(containerType, m2.getGenericReturnType());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object instantiate(Class<?> type) throws ReflectiveOperationException {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (type.isAssignableFrom(LinkedList.class)) {
            return new LinkedList();
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (type.isAssignableFrom(HashMap.class)) {
            return new HashMap();
        }
        return type.newInstance();
    }

    public static Object instantiate(TypeDefinition type, SerializationContext context, List<SerializationRule> rules, boolean forceType) throws SerializationException, ReflectiveOperationException {
        Object instance = null;
        for (SerializationRule rule : rules) {
            if (!rule.canInstantiate(type, context)) continue;
            instance = rule.instantiate(type, context);
            break;
        }
        if (instance == null) {
            instance = context instanceof SerializationContext.AttributeContext && !forceType ? ((SerializationContext.AttributeContext)context).getAttribute().instantiate((SerializationContext.AttributeContext)context) : SerializationClass.instantiate(type.getBase());
        }
        for (SerializationRule rule : rules) {
            rule.onInstantiation(type, instance, context);
        }
        return instance;
    }

    public static class Attribute {
        protected SerializationClass parent;
        protected String name;
        protected String originalName;
        protected Field field;
        protected Method getter;
        protected Method setter;
        protected TypeDefinition type;
        protected TypeDefinition originalType;
        protected boolean ignore = false;

        public Attribute(SerializationClass parent, String name, TypeDefinition type) {
            this.parent = parent;
            this.name = this.originalName = name;
            this.type = this.originalType = type;
        }

        public Attribute(SerializationClass parent, Field f) {
            this.parent = parent;
            this.field = f;
            this.name = this.originalName = f.getName();
            this.type = this.originalType = new TypeDefinition(parent.getType(), f.getGenericType());
            if ((f.getModifiers() & 0x80) != 0) {
                this.ignore = true;
            }
        }

        public Attribute(Attribute copy) {
            this.parent = copy.parent;
            this.name = copy.name;
            this.originalName = copy.originalName;
            this.field = copy.field;
            this.getter = copy.getter;
            this.setter = copy.setter;
            this.type = copy.type;
            this.originalType = copy.originalType;
            this.ignore = copy.ignore;
        }

        public SerializationClass getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public Field getField() {
            return this.field;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public TypeDefinition getType() {
            return this.type;
        }

        public TypeDefinition getOriginalType() {
            return this.originalType;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public void ignore(boolean ignore) {
            this.ignore = ignore;
        }

        public void renameTo(String newName) {
            this.name = newName;
        }

        public void setType(TypeDefinition type) {
            this.type = type;
        }

        public Class<?> getDeclaringClass() {
            if (this.field != null) {
                return this.field.getDeclaringClass();
            }
            if (this.getter != null) {
                return this.getter.getDeclaringClass();
            }
            return this.setter.getDeclaringClass();
        }

        public boolean canGet() {
            return this.getter != null || this.field != null && (this.field.getModifiers() & 1) != 0;
        }

        public boolean canSet() {
            return this.setter != null || this.field != null && (this.field.getModifiers() & 1) != 0;
        }

        public Object getValue(Object instance) throws SerializationException {
            try {
                Object val = this.getter != null ? this.getter.invoke(instance, new Object[0]) : this.field.get(instance);
                return val;
            }
            catch (Exception e) {
                throw new SerializationException("Error getting field " + this.originalName, e);
            }
        }

        public void setValue(Object instance, Object value) throws SerializationException {
            try {
                if (this.setter != null) {
                    this.setter.invoke(instance, value);
                } else {
                    this.field.set(instance, value);
                }
            }
            catch (Exception e) {
                throw new SerializationException("Error setting field " + this.originalName, e);
            }
        }

        public Object instantiate(SerializationContext.AttributeContext context) throws SerializationException {
            try {
                return SerializationClass.instantiate(context.getAttribute().getType().getBase());
            }
            catch (Exception e) {
                throw new SerializationException("Error instantiating field " + this.originalName, e);
            }
        }

        public boolean hasCustomInstantiation() {
            return false;
        }

        public <T extends Annotation> T getAnnotation(boolean onGet, Class<T> annotationType) {
            T a;
            if (this.field != null && (a = this.field.getAnnotation(annotationType)) != null) {
                return a;
            }
            if (onGet && this.getter != null && (a = this.getter.getAnnotation(annotationType)) != null) {
                return a;
            }
            if (!onGet && this.setter != null && (a = this.setter.getAnnotation(annotationType)) != null) {
                return a;
            }
            return null;
        }

        public List<Annotation> getAnnotations(boolean onGet) {
            LinkedList<Annotation> list = new LinkedList<Annotation>();
            if (this.field != null) {
                Collections.addAll(list, this.field.getAnnotations());
            }
            if (onGet && this.getter != null) {
                Collections.addAll(list, this.getter.getAnnotations());
            }
            if (!onGet && this.setter != null) {
                Collections.addAll(list, this.setter.getAnnotations());
            }
            return list;
        }
    }
}

