/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.serialization.CustomSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.rules.CustomAttributeSerializer;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface SerializationMethods {
    public String serialization();

    public String deserialization();

    public static class ToRule
    implements AttributeAnnotationToRuleOnType<SerializationMethods> {
        @Override
        public SerializationRule createRule(SerializationMethods annotation, SerializationClass.Attribute attribute) {
            try {
                Class<?> container = attribute.getParent().getType().getBase();
                final TypeDefinition sourceType = attribute.getOriginalType();
                final Method serializationMethod = container.getMethod(annotation.serialization(), new Class[0]);
                final TypeDefinition targetType = new TypeDefinition(attribute.getParent().getType(), serializationMethod.getGenericReturnType());
                final Method deserializationMethod = container.getMethod(annotation.deserialization(), targetType.getBase());
                if (!deserializationMethod.getReturnType().equals(sourceType.getBase())) {
                    throw new SerializationException("Deserialization method " + deserializationMethod.getName() + " must return a value of type " + sourceType.getBase().getName());
                }
                return new CustomAttributeSerializer(attribute.getDeclaringClass(), attribute.getOriginalName(), new CustomSerializer(){

                    @Override
                    public TypeDefinition sourceType() {
                        return sourceType;
                    }

                    @Override
                    public TypeDefinition targetType() {
                        return targetType;
                    }

                    @Override
                    public Object serialize(Object src, Object containerInstance) {
                        if (src == null) {
                            return null;
                        }
                        try {
                            if ((serializationMethod.getModifiers() & 8) != 0) {
                                return serializationMethod.invoke(null, new Object[0]);
                            }
                            return serializationMethod.invoke(containerInstance, new Object[0]);
                        }
                        catch (Exception t) {
                            LCCore.getApplication().getDefaultLogger().error("Error calling method " + serializationMethod.getName() + " on class " + serializationMethod.getDeclaringClass().getName(), t);
                            return null;
                        }
                    }

                    @Override
                    public Object deserialize(Object src, Object containerInstance) {
                        if (src == null) {
                            return null;
                        }
                        try {
                            if ((deserializationMethod.getModifiers() & 8) != 0) {
                                return deserializationMethod.invoke(null, src);
                            }
                            return deserializationMethod.invoke(containerInstance, src);
                        }
                        catch (Exception t) {
                            LCCore.getApplication().getDefaultLogger().error("Error calling method " + deserializationMethod.getName() + " on class " + deserializationMethod.getDeclaringClass().getName(), t);
                            return null;
                        }
                    }
                });
            }
            catch (Exception t) {
                LCCore.getApplication().getDefaultLogger().error("Error creating CustomAttributeSerializer from annotation SerializationMethods", t);
                return null;
            }
        }
    }
}

