/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.Pair;

public interface TypeAnnotationToRule<TAnnotation extends Annotation> {
    public SerializationRule createRule(TAnnotation var1, Class<?> var2);

    public static List<SerializationRule> addRules(SerializationClass type, List<SerializationRule> rules) {
        rules = TypeAnnotationToRule.addRules(type.getType().getBase(), rules);
        for (SerializationClass.Attribute a : type.getAttributes()) {
            rules = TypeAnnotationToRule.addRules(a.getType().getBase(), rules);
        }
        return rules;
    }

    public static List<SerializationRule> addRules(Class<?> clazz, List<SerializationRule> rules) {
        LinkedList<SerializationRule> newRules = new LinkedList<SerializationRule>();
        TypeAnnotationToRule.processAnnotations(clazz, newRules, rules);
        if (newRules.isEmpty()) {
            return rules;
        }
        ArrayList<SerializationRule> newList = new ArrayList<SerializationRule>(rules.size() + newRules.size());
        newList.addAll(rules);
        newList.addAll(newRules);
        return newList;
    }

    public static void processAnnotations(Class<?> clazz, List<SerializationRule> newRules, List<SerializationRule> rules) {
        for (Annotation a : ClassUtil.expandRepeatableAnnotations(clazz.getDeclaredAnnotations())) {
            for (TypeAnnotationToRule<?> toRule : TypeAnnotationToRule.getAnnotationToRules(a)) {
                TypeAnnotationToRule.addRule(toRule, a, clazz, newRules, rules);
            }
        }
        if (clazz.getSuperclass() != null) {
            TypeAnnotationToRule.processAnnotations(clazz.getSuperclass(), newRules, rules);
        }
        for (Class<?> i : clazz.getInterfaces()) {
            TypeAnnotationToRule.processAnnotations(i, newRules, rules);
        }
    }

    public static void addRule(TypeAnnotationToRule toRule, Annotation a, Class<?> clazz, List<SerializationRule> newRules, List<SerializationRule> rules) {
        SerializationRule rule;
        try {
            rule = toRule.createRule(a, clazz);
        }
        catch (Exception t) {
            LCCore.getApplication().getDefaultLogger().error("Error creating rule from annotation " + a.annotationType().getName() + " using " + toRule.getClass().getName(), t);
            return;
        }
        SerializationRule.addRuleIfNoEquivalent(rule, newRules, rules);
    }

    public static List<TypeAnnotationToRule<?>> getAnnotationToRules(Annotation a) {
        LinkedList list = new LinkedList();
        for (Class<?> c : a.annotationType().getDeclaredClasses()) {
            if (!TypeAnnotationToRule.class.isAssignableFrom(c)) continue;
            try {
                list.add((TypeAnnotationToRule)c.newInstance());
            }
            catch (Exception t) {
                LCCore.getApplication().getDefaultLogger().error("Error creating TypeAnnotationToRule " + a.annotationType().getName(), t);
            }
        }
        for (Pair p : Registry.registry) {
            if (!((Class)p.getValue1()).equals(a.annotationType())) continue;
            list.add((TypeAnnotationToRule<?>)p.getValue2());
        }
        return list;
    }

    public static final class Registry {
        private static List<Pair<Class<? extends Annotation>, TypeAnnotationToRule<?>>> registry = new ArrayList();

        private Registry() {
        }

        public static <T extends Annotation> void register(Class<T> annotationType, TypeAnnotationToRule<T> toRule) {
            registry.add(new Pair<Class<T>, TypeAnnotationToRule<T>>(annotationType, toRule));
        }
    }
}

