/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.serialization.CustomSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.annotations.TypeSerializers;
import net.lecousin.framework.io.serialization.rules.CustomTypeSerializer;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
@Repeatable(value=TypeSerializers.class)
public @interface TypeSerializer {
    public Class<? extends CustomSerializer> value();

    public boolean isGeneral() default false;

    public static class ToRule
    implements TypeAnnotationToRule<TypeSerializer>,
    AttributeAnnotationToRuleOnAttribute<TypeSerializer> {
        @Override
        public SerializationRule createRule(TypeSerializer annotation, Class<?> type) {
            return ToRule.createRule(annotation.value(), annotation.isGeneral() ? null : new SerializationContextPattern.OnClass(type));
        }

        @Override
        public SerializationRule createRule(TypeSerializer annotation, SerializationClass.Attribute attribute) {
            return ToRule.createRule(annotation.value(), annotation.isGeneral() ? null : new SerializationContextPattern.OnClassAttribute(attribute.getDeclaringClass(), attribute.getOriginalName()));
        }

        private static SerializationRule createRule(Class<? extends CustomSerializer> custom, SerializationContextPattern context) {
            try {
                return new CustomTypeSerializer(custom.newInstance(), context);
            }
            catch (Exception t) {
                LCCore.getApplication().getDefaultLogger().error("Error instantiating custom serializer " + custom.getName(), t);
                return null;
            }
        }
    }
}

