/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.Factory;

public class AbstractAttributeInstantiation
implements SerializationRule {
    private SerializationContextPattern.OnClassAttribute pattern;
    private String discriminator;
    private Class<? extends Factory> factory;

    public AbstractAttributeInstantiation(SerializationContextPattern.OnClassAttribute pattern, String discriminator, Class<? extends Factory> factory) {
        this.pattern = pattern;
        this.discriminator = discriminator;
        this.factory = factory;
    }

    public AbstractAttributeInstantiation(Class<?> clazz, String name, String discriminator, Class<? extends Factory> factory) {
        this(new SerializationContextPattern.OnClassAttribute(clazz, name), discriminator, factory);
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) throws SerializationException {
        SerializationClass.Attribute a = this.pattern.getAttribute(type, context);
        if (a == null) {
            return false;
        }
        SerializationClass.Attribute discr = type.getAttributeByOriginalName(this.discriminator);
        if (discr == null || !discr.canGet()) {
            throw new SerializationException("Unable to get discriminator attribute " + this.discriminator);
        }
        try {
            type.replaceAttribute(a, new InstantiationAttribute(a, discr, this.factory.newInstance()));
        }
        catch (Exception t) {
            throw new SerializationException("Unable to replace attribute by an InstantiationAttribute", t);
        }
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof AbstractAttributeInstantiation)) {
            return false;
        }
        AbstractAttributeInstantiation r = (AbstractAttributeInstantiation)rule;
        return r.pattern.isEquivalent(this.pattern) && r.discriminator.equals(this.discriminator);
    }

    private static class InstantiationAttribute
    extends SerializationClass.Attribute {
        private SerializationClass.Attribute discriminator;
        private Factory factory;

        public InstantiationAttribute(SerializationClass.Attribute a, SerializationClass.Attribute discriminator, Factory factory) {
            super(a);
            this.discriminator = discriminator;
            this.factory = factory;
        }

        @Override
        public Object instantiate(SerializationContext.AttributeContext context) throws SerializationException {
            return this.factory.create(this.discriminator.getValue(context.getParent().getInstance()));
        }

        @Override
        public boolean hasCustomInstantiation() {
            return true;
        }
    }
}

