/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.lang.reflect.Method;
import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.ClassUtil;

public class AddAttributeToType
implements SerializationRule {
    private Class<?> type;
    private String attributeName;
    private String serializingMethodName;
    private String deserializingMethodName;

    public AddAttributeToType(Class<?> type, String attributeName, String serializingMethodName, String deserializingMethodName) {
        this.type = type;
        this.attributeName = attributeName;
        this.serializingMethodName = serializingMethodName;
        this.deserializingMethodName = deserializingMethodName;
    }

    @Override
    public boolean apply(SerializationClass sc, SerializationContext context, List<SerializationRule> rules, boolean serializing) throws SerializationException {
        if (!this.type.isAssignableFrom(sc.getType().getBase())) {
            return false;
        }
        TypeDefinition t = null;
        Method sm = null;
        Method dm = null;
        if (this.serializingMethodName != null && !this.serializingMethodName.isEmpty()) {
            try {
                sm = this.type.getMethod(this.serializingMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new SerializationException("Serialization method " + this.serializingMethodName + " does not exist on calss " + this.type.getName(), e);
            }
            t = new TypeDefinition(sc.getType(), sm.getGenericReturnType());
        }
        if (this.deserializingMethodName != null && !this.deserializingMethodName.isEmpty()) {
            dm = ClassUtil.getMethod(this.type, this.deserializingMethodName, 1);
            if (dm == null) {
                throw new SerializationException("Deserialization method " + this.deserializingMethodName + " does not exist on class " + this.type.getName());
            }
            if (t == null) {
                t = new TypeDefinition(sc.getType(), dm.getGenericParameterTypes()[0]);
            }
        }
        sc.getAttributes().add(new AddedAttribute(sc, t, sm, dm));
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof AddAttributeToType)) {
            return false;
        }
        AddAttributeToType r = (AddAttributeToType)rule;
        return r.type.equals(this.type) && r.attributeName.equals(this.attributeName) && r.serializingMethodName.equals(this.serializingMethodName) && r.deserializingMethodName.equals(this.deserializingMethodName);
    }

    private class AddedAttribute
    extends SerializationClass.Attribute {
        public AddedAttribute(SerializationClass parent, TypeDefinition type, Method sm, Method dm) {
            super(parent, AddAttributeToType.this.attributeName, type);
            this.getter = sm;
            this.setter = dm;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return AddAttributeToType.this.type;
        }
    }
}

