/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class IgnoreAttribute
implements SerializationRule {
    private SerializationContextPattern contextPattern;

    public IgnoreAttribute(SerializationContextPattern contextPattern) {
        this.contextPattern = contextPattern;
    }

    public IgnoreAttribute(Class<?> type, String name) {
        this(new SerializationContextPattern.OnClassAttribute(type, name));
    }

    public IgnoreAttribute(Class<?> type) {
        this(new SerializationContextPattern.OnClass(type));
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        if (!this.contextPattern.matches(type, context)) {
            return false;
        }
        for (SerializationClass.Attribute a : type.getAttributes()) {
            if (!this.contextPattern.matches(type, context, a)) continue;
            a.ignore(true);
        }
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof IgnoreAttribute)) {
            return false;
        }
        IgnoreAttribute r = (IgnoreAttribute)rule;
        return this.contextPattern.isEquivalent(r.contextPattern);
    }
}

