/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.ClassUtil;

public class MergeTypeAttributes
implements SerializationRule {
    private SerializationContextPattern contextPattern;
    private Class<?> type;
    private String targetAttributeName;

    public MergeTypeAttributes(SerializationContextPattern contextPattern, Class<?> type, String targetAttributeName) {
        this.contextPattern = contextPattern;
        this.type = type;
        this.targetAttributeName = targetAttributeName;
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) throws SerializationException {
        try {
            if (context instanceof SerializationContext.ObjectContext && this.applyOnObjectContext((SerializationContext.ObjectContext)context, rules, serializing)) {
                return true;
            }
            if (!this.contextPattern.matches(type, context)) {
                return false;
            }
            ListIterator<SerializationClass.Attribute> it = type.getAttributes().listIterator();
            while (it.hasNext()) {
                TypeDefinition t;
                SerializationClass.Attribute a = it.next();
                if (!a.getOriginalType().getBase().equals(this.type) || (t = SerializationClass.searchAttributeType(a.getOriginalType(), this.targetAttributeName)) == null) continue;
                it.set(new MergeTargetAttribute(a, t));
            }
            return false;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Error merging attributes", e);
        }
    }

    private boolean applyOnObjectContext(SerializationContext.ObjectContext octx, List<SerializationRule> rules, boolean serializing) throws SerializationException, ReflectiveOperationException {
        if (octx.getParent() instanceof SerializationContext.AttributeContext) {
            SerializationContext.AttributeContext actx = (SerializationContext.AttributeContext)octx.getParent();
            this.applyOnAttributeContext(octx, actx, serializing);
            return false;
        }
        if (this.type.isAssignableFrom(octx.getSerializationClass().getType().getBase())) {
            if (octx.getParent() instanceof SerializationContext.CollectionContext) {
                SerializationContext.AttributeContext actx;
                SerializationContext.CollectionContext cctx = (SerializationContext.CollectionContext)octx.getParent();
                while (cctx.getParent() instanceof SerializationContext.CollectionContext) {
                    cctx = (SerializationContext.CollectionContext)cctx.getParent();
                }
                if (cctx.getParent() instanceof SerializationContext.AttributeContext && this.contextPattern.matches(actx = (SerializationContext.AttributeContext)cctx.getParent())) {
                    this.applyOnCollectionContextInAttribute(octx, serializing);
                }
            }
            return false;
        }
        if (serializing || !this.type.isAssignableFrom(octx.getOriginalType().getBase())) {
            return false;
        }
        TypeDefinition targetType = SerializationClass.searchAttributeType(octx.getOriginalType(), this.targetAttributeName);
        if (targetType == null) {
            return false;
        }
        Object mergedInstance = octx.getInstance();
        Object containerInstance = SerializationClass.instantiate(octx.getOriginalType().getBase());
        Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
        if (setter != null) {
            setter.invoke(containerInstance, mergedInstance);
        } else {
            Field f = ClassUtil.getField(this.type, this.targetAttributeName);
            if (f != null) {
                f.set(containerInstance, mergedInstance);
            } else {
                throw MergeTypeAttributes.cannotFindAttribute(this.targetAttributeName, this.type.getName());
            }
        }
        octx.setInstance(containerInstance);
        SerializationClass containerClass = new SerializationClass(octx.getOriginalType());
        SerializationClass targetClass = octx.getSerializationClass();
        octx.setSerializationClass(containerClass);
        Iterator<SerializationClass.Attribute> it = containerClass.getAttributes().iterator();
        while (it.hasNext()) {
            if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
            it.remove();
            break;
        }
        List<SerializationRule> subRules = rules.subList(rules.indexOf(this) + 1, rules.size());
        targetClass.apply(subRules, octx, serializing);
        for (SerializationClass.Attribute a : targetClass.getAttributes()) {
            containerClass.getAttributes().add(new MergedAttribute(a, containerClass, mergedInstance));
        }
        List<SerializationRule> newRules = TypeAnnotationToRule.addRules(containerClass.getType().getBase(), rules);
        newRules = AttributeAnnotationToRuleOnType.addRules(containerClass, false, newRules);
        newRules.remove(this);
        containerClass.apply(newRules, octx, serializing);
        return true;
    }

    private void applyOnAttributeContext(SerializationContext.ObjectContext octx, SerializationContext.AttributeContext actx, boolean serializing) throws SerializationException, ReflectiveOperationException {
        if (actx.getAttribute() instanceof MergeTargetAttribute) {
            MergeTargetAttribute ma = (MergeTargetAttribute)actx.getAttribute();
            if (serializing) {
                this.applyOnAttributeContextForSerialization(octx, ma);
            } else {
                this.applyOnAttributeContextForDeserialization(octx, ma);
            }
        }
    }

    private void applyOnAttributeContextForSerialization(SerializationContext.ObjectContext octx, MergeTargetAttribute ma) throws SerializationException, ReflectiveOperationException {
        TypeDefinition targetType;
        Object containerObject = octx.getInstance();
        if (containerObject != null) {
            Object targetInstance;
            Method getter = ClassUtil.getGetter(containerObject.getClass(), this.targetAttributeName);
            if (getter != null) {
                targetInstance = getter.invoke(containerObject, new Object[0]);
            } else {
                Field f = ClassUtil.getField(containerObject.getClass(), this.targetAttributeName);
                if (f != null) {
                    targetInstance = f.get(containerObject);
                } else {
                    throw MergeTypeAttributes.cannotFindAttribute(this.targetAttributeName, containerObject.getClass().getName());
                }
            }
            octx.setInstance(targetInstance);
            targetType = TypeDefinition.from(targetInstance.getClass(), ma.targetType);
        } else {
            SerializationClass.Attribute a = octx.getSerializationClass().getAttributeByOriginalName(this.targetAttributeName);
            targetType = a.getOriginalType();
        }
        SerializationClass containerClass = octx.getSerializationClass();
        SerializationClass sc = new SerializationClass(targetType);
        octx.setSerializationClass(sc);
        octx.setOriginalType(ma.targetType);
        for (SerializationClass.Attribute a : containerClass.getAttributes()) {
            if (a.getOriginalName().equals(this.targetAttributeName)) continue;
            sc.getAttributes().add(new MergedAttribute(a, sc, containerObject));
        }
    }

    private void applyOnAttributeContextForDeserialization(SerializationContext.ObjectContext octx, MergeTargetAttribute ma) throws SerializationException, ReflectiveOperationException {
        Object mergedInstance = SerializationClass.instantiate(ma.targetType.getBase());
        Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
        if (setter != null) {
            setter.invoke(octx.getInstance(), mergedInstance);
        } else {
            Field f = ClassUtil.getField(this.type, this.targetAttributeName);
            if (f != null) {
                f.set(octx.getInstance(), mergedInstance);
            } else {
                throw MergeTypeAttributes.cannotFindAttribute(this.targetAttributeName, this.type.getName());
            }
        }
        Iterator<SerializationClass.Attribute> it = octx.getSerializationClass().getAttributes().iterator();
        while (it.hasNext()) {
            if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
            it.remove();
            break;
        }
        SerializationClass sc = new SerializationClass(ma.targetType);
        for (SerializationClass.Attribute a : sc.getAttributes()) {
            octx.getSerializationClass().getAttributes().add(new MergedAttribute(a, octx.getSerializationClass(), mergedInstance));
        }
    }

    private void applyOnCollectionContextInAttribute(SerializationContext.ObjectContext octx, boolean serializing) throws SerializationException, ReflectiveOperationException {
        TypeDefinition targetType = SerializationClass.searchAttributeType(octx.getOriginalType(), this.targetAttributeName);
        if (targetType != null) {
            if (serializing) {
                this.applyOnCollectionContextInAttributeForSerialization(octx, targetType);
            } else {
                this.applyOnCollectionContextInAttributeForDeserialization(octx, targetType);
            }
        }
    }

    private void applyOnCollectionContextInAttributeForSerialization(SerializationContext.ObjectContext octx, TypeDefinition targetType) throws SerializationException, ReflectiveOperationException {
        TypeDefinition newType;
        Object containerObject = octx.getInstance();
        if (containerObject != null) {
            Object targetInstance;
            Method getter = ClassUtil.getGetter(containerObject.getClass(), this.targetAttributeName);
            if (getter != null) {
                targetInstance = getter.invoke(containerObject, new Object[0]);
            } else {
                Field f = ClassUtil.getField(containerObject.getClass(), this.targetAttributeName);
                if (f != null) {
                    targetInstance = f.get(containerObject);
                } else {
                    throw MergeTypeAttributes.cannotFindAttribute(this.targetAttributeName, containerObject.getClass().getName());
                }
            }
            octx.setInstance(targetInstance);
            newType = TypeDefinition.from(targetInstance.getClass(), targetType);
        } else {
            SerializationClass.Attribute a = octx.getSerializationClass().getAttributeByOriginalName(this.targetAttributeName);
            newType = a.getOriginalType();
        }
        SerializationClass containerClass = octx.getSerializationClass();
        SerializationClass sc = new SerializationClass(newType);
        octx.setSerializationClass(sc);
        octx.setOriginalType(targetType);
        for (SerializationClass.Attribute a : containerClass.getAttributes()) {
            if (a.getOriginalName().equals(this.targetAttributeName)) continue;
            sc.getAttributes().add(new MergedAttribute(a, sc, containerObject));
        }
    }

    private void applyOnCollectionContextInAttributeForDeserialization(SerializationContext.ObjectContext octx, TypeDefinition targetType) throws SerializationException, ReflectiveOperationException {
        Object mergedInstance = SerializationClass.instantiate(targetType.getBase());
        Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
        if (setter != null) {
            setter.invoke(octx.getInstance(), mergedInstance);
        } else {
            Field f = ClassUtil.getField(this.type, this.targetAttributeName);
            if (f != null) {
                f.set(octx.getInstance(), mergedInstance);
            } else {
                throw MergeTypeAttributes.cannotFindAttribute(this.targetAttributeName, this.type.getName());
            }
        }
        Iterator<SerializationClass.Attribute> it = octx.getSerializationClass().getAttributes().iterator();
        while (it.hasNext()) {
            if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
            it.remove();
            break;
        }
        SerializationClass sc = new SerializationClass(targetType);
        for (SerializationClass.Attribute a : sc.getAttributes()) {
            octx.getSerializationClass().getAttributes().add(new MergedAttribute(a, octx.getSerializationClass(), mergedInstance));
        }
    }

    private static SerializationException cannotFindAttribute(String attrName, String clazz) {
        return new SerializationException("Cannot find attribute " + attrName + " on class " + clazz);
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof MergeTypeAttributes)) {
            return false;
        }
        MergeTypeAttributes r = (MergeTypeAttributes)rule;
        return r.type.equals(this.type) && r.targetAttributeName.equals(this.targetAttributeName);
    }

    private static class MergedAttribute
    extends SerializationClass.Attribute {
        private Object containerInstance;

        public MergedAttribute(SerializationClass.Attribute original, SerializationClass newParent, Object containerInstance) {
            super(original);
            this.parent = newParent;
            this.containerInstance = containerInstance;
        }

        @Override
        public Object getValue(Object instance) throws SerializationException {
            return super.getValue(this.containerInstance);
        }

        @Override
        public void setValue(Object instance, Object value) throws SerializationException {
            super.setValue(this.containerInstance, value);
        }
    }

    private static class MergeTargetAttribute
    extends SerializationClass.Attribute {
        private TypeDefinition targetType;

        public MergeTargetAttribute(SerializationClass.Attribute originalAttribute, TypeDefinition targetType) {
            super(originalAttribute);
            this.targetType = targetType;
        }
    }
}

