/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;

public interface SerializationRule {
    public boolean apply(SerializationClass var1, SerializationContext var2, List<SerializationRule> var3, boolean var4) throws SerializationException;

    public boolean isEquivalent(SerializationRule var1);

    default public Object convertSerializationValue(Object value, TypeDefinition type, SerializationContext context) throws SerializationException {
        return value;
    }

    default public TypeDefinition getDeserializationType(TypeDefinition type, SerializationContext context) {
        return type;
    }

    default public Object getDeserializationValue(Object value, TypeDefinition type, SerializationContext context) throws SerializationException {
        return value;
    }

    default public boolean canInstantiate(TypeDefinition type, SerializationContext context) {
        return false;
    }

    default public Object instantiate(TypeDefinition type, SerializationContext context) throws SerializationException {
        return null;
    }

    default public void onInstantiation(TypeDefinition type, Object instance, SerializationContext context) throws SerializationException {
    }

    public static void addRuleIfNoEquivalent(SerializationRule rule, List<SerializationRule> newRules, List<SerializationRule> rules) {
        if (rule == null) {
            return;
        }
        boolean found = false;
        for (SerializationRule r : rules) {
            if (!r.isEquivalent(rule)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (SerializationRule r : newRules) {
                if (!r.isEquivalent(rule)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            newRules.add(rule);
        }
    }
}

