/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.CompositeChars;
import net.lecousin.framework.io.data.DataBuffer;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedReadableCharacterStream
extends ConcurrentCloseable<IOException>
implements ICharacterStream.Readable.Buffered {
    private IO.Readable input;
    private CharacterDecoder decoder;
    private TurnArray<Chars.Readable> ready;
    private ByteArrayCache cache;
    private int bufferSize;
    private Chars.Readable currentChars;
    private boolean endReached = false;
    private int back = -1;
    private Async<IOException> nextReady = new Async();

    public BufferedReadableCharacterStream(IO.Readable input, Charset charset, int bufferSize, int maxBuffers) {
        this(input, CharacterDecoder.get(charset, bufferSize), bufferSize, maxBuffers);
    }

    public BufferedReadableCharacterStream(IO.Readable input, CharacterDecoder decoder, int bufferSize, int maxBuffers) {
        this(input, decoder, bufferSize, maxBuffers, null, null);
    }

    public BufferedReadableCharacterStream(IO.Readable input, Charset charset, int bufferSize, int maxBuffers, ByteBuffer initBytes, Chars.Readable initChars) {
        this(input, CharacterDecoder.get(charset, bufferSize), bufferSize, maxBuffers, initBytes, initChars);
    }

    public BufferedReadableCharacterStream(IO.Readable input, CharacterDecoder decoder, int bufferSize, int maxBuffers, ByteBuffer initBytes, Chars.Readable initChars) {
        this.input = input;
        this.decoder = decoder;
        if (bufferSize < 64) {
            bufferSize = 64;
        }
        this.ready = new TurnArray(maxBuffers);
        this.cache = ByteArrayCache.getInstance();
        this.bufferSize = bufferSize;
        Chars.Readable readable = this.currentChars = initChars != null && initChars.hasRemaining() ? initChars : null;
        if (initBytes != null && initBytes.hasRemaining()) {
            ByteArray rb = ByteArray.fromByteBuffer(initBytes);
            AsyncSupplier<Integer, Object> readTask = new AsyncSupplier<Integer, Object>(rb.remaining(), null);
            DecodeTask decode = new DecodeTask(readTask, rb);
            this.operation(decode).startOn(readTask, true);
        } else if (input instanceof IO.Readable.Buffered) {
            ((IO.Readable.Buffered)input).canStartReading().onDone(this::bufferize);
        } else {
            this.bufferize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Async<IOException> canStartReading() {
        TurnArray<Chars.Readable> turnArray = this.ready;
        synchronized (turnArray) {
            if (this.ready.isEmpty()) {
                return this.nextReady;
            }
            return new Async<boolean>(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        TurnArray<Chars.Readable> turnArray = this.ready;
        synchronized (turnArray) {
            this.nextReady.cancel(new CancelException("Closed"));
        }
        return this.input.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.currentChars = null;
        this.decoder = null;
        this.ready = null;
        this.input = null;
        ondone.unblock();
    }

    @Override
    public String getDescription() {
        return this.input.getSourceDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.decoder.getEncoding();
    }

    @Override
    public byte getPriority() {
        return this.input.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.input.setPriority(priority);
    }

    private void bufferize() {
        byte[] buf = (byte[])this.cache.get(this.bufferSize, true);
        ByteBuffer bb = ByteBuffer.wrap(buf);
        AsyncSupplier<Integer, IOException> readTask = this.input.readFullyAsync(bb);
        DecodeTask decode = new DecodeTask(readTask, new ByteArray(buf));
        this.operation(decode).startOn(readTask, true);
    }

    private void pollNextBuffer() {
        this.currentChars = this.ready.pollFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endReached() {
        if (this.endReached && this.currentChars == null) {
            TurnArray<Chars.Readable> turnArray = this.ready;
            synchronized (turnArray) {
                if (this.endReached && this.currentChars == null && this.ready.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void back(char c) {
        this.back = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char read() throws IOException {
        TurnArray<Chars.Readable> turnArray;
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            return c;
        }
        while (this.currentChars == null) {
            Async<IOException> sp;
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
                if (this.currentChars == null && this.endReached) {
                    throw new EOFException();
                }
                if (this.nextReady.hasError()) {
                    throw this.nextReady.getError();
                }
                sp = this.nextReady;
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.currentChars != null) break;
            sp.block(0L);
        }
        char c = this.currentChars.get();
        if (!this.currentChars.hasRemaining()) {
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(char[] buf, int offset, int length) throws IOException {
        TurnArray<Chars.Readable> turnArray;
        if (length <= 0) {
            return 0;
        }
        int done = 0;
        if (this.back != -1) {
            buf[offset++] = (char)this.back;
            this.back = -1;
            if (--length == 0) {
                return 1;
            }
            done = 1;
        }
        while (this.currentChars == null) {
            Async<IOException> sp;
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
                sp = this.nextReady;
                if (this.currentChars == null && this.endReached) {
                    if (done > 0) {
                        return done;
                    }
                    return -1;
                }
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.currentChars != null) break;
            sp.block(0L);
            if (sp.hasError()) {
                throw sp.getError();
            }
            if (!sp.isCancelled()) continue;
            throw IO.error(sp.getCancelEvent());
        }
        int len = Math.min(length, this.currentChars.remaining());
        this.currentChars.get(buf, offset, len);
        if (!this.currentChars.hasRemaining()) {
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return len + done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readAsync() throws IOException {
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            return c;
        }
        if (this.currentChars == null) {
            boolean full;
            TurnArray<Chars.Readable> turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
                if (this.currentChars == null && this.endReached) {
                    return -1;
                }
                if (this.nextReady.hasError()) {
                    throw this.nextReady.getError();
                }
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.currentChars == null) {
                return -2;
            }
        }
        char c = this.currentChars.get();
        if (!this.currentChars.hasRemaining()) {
            boolean full;
            TurnArray<Chars.Readable> turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return c;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(char[] buf, int off, int len) {
        if (len <= 0) {
            return new AsyncSupplier<Integer, Object>(0, null);
        }
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        this.operation(new ReadAsyncTask(buf, off, len, result)).startOn(this.canStartReading(), true);
        return result;
    }

    @Override
    public AsyncSupplier<Chars.Readable, IOException> readNextBufferAsync() {
        AsyncSupplier<Chars.Readable, IOException> result = new AsyncSupplier<Chars.Readable, IOException>();
        this.readNextBufferAsync(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNextBufferAsync(AsyncSupplier<Chars.Readable, IOException> result) {
        boolean full;
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            result.unblockSuccess(new CharArray(new char[]{c}));
            return;
        }
        if (this.currentChars == null) {
            boolean full2;
            TurnArray<Chars.Readable> turnArray = this.ready;
            synchronized (turnArray) {
                full2 = this.ready.isFull();
                this.pollNextBuffer();
                if (this.currentChars == null && this.endReached) {
                    result.unblockSuccess(null);
                    return;
                }
                if (this.nextReady.hasError()) {
                    result.error(this.nextReady.getError());
                    return;
                }
            }
            if (full2 && !this.endReached) {
                this.bufferize();
            }
            if (this.currentChars == null) {
                this.canStartReading().thenStart(new Task.Cpu.FromRunnable("BufferedReadableCharacterStream.readNextBufferAsync", this.getPriority(), () -> this.readNextBufferAsync(result)), result);
                return;
            }
        }
        Chars.Readable buf = this.currentChars;
        TurnArray<Chars.Readable> turnArray = this.ready;
        synchronized (turnArray) {
            full = this.ready.isFull();
            this.pollNextBuffer();
        }
        if (full && !this.endReached) {
            this.bufferize();
        }
        result.unblockSuccess(buf);
    }

    @Override
    public Chars.Readable readNextBuffer() throws IOException {
        try {
            return this.readNextBufferAsync().blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    @Override
    public AsyncSupplier<Boolean, IOException> readUntilAsync(char endChar, IString string) {
        AsyncSupplier<Boolean, IOException> result = new AsyncSupplier<Boolean, IOException>();
        new Task.Cpu.FromRunnable("BufferedReadableCharacterStream.readUntil", this.getPriority(), () -> this.readUntil(endChar, string, result)).start();
        return result;
    }

    @Override
    public boolean readUntil(char endChar, IString string) throws IOException {
        AsyncSupplier<Boolean, IOException> result = new AsyncSupplier<Boolean, IOException>();
        this.readUntil(endChar, string, result);
        try {
            return result.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUntil(char endChar, IString string, AsyncSupplier<Boolean, IOException> result) {
        boolean found;
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            if (c == endChar) {
                result.unblockSuccess(Boolean.TRUE);
                return;
            }
            string.append(c);
        }
        do {
            boolean full;
            if (this.currentChars == null) {
                boolean full2;
                TurnArray<Chars.Readable> turnArray = this.ready;
                synchronized (turnArray) {
                    full2 = this.ready.isFull();
                    this.pollNextBuffer();
                    if (this.currentChars == null && this.endReached) {
                        result.unblockSuccess(Boolean.FALSE);
                        return;
                    }
                    if (this.nextReady.hasError()) {
                        result.error(this.nextReady.getError());
                        return;
                    }
                }
                if (full2 && !this.endReached) {
                    this.bufferize();
                }
                if (this.currentChars == null) {
                    this.canStartReading().thenStart(new Task.Cpu.FromRunnable("BufferedReadableCharacterStream.readUntil", this.getPriority(), () -> this.readUntil(endChar, string, result)), result);
                    return;
                }
            }
            found = this.searchCurrentChars(endChar, string);
            if (this.currentChars.hasRemaining()) continue;
            TurnArray<Chars.Readable> turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.pollNextBuffer();
            }
            if (!full || this.endReached) continue;
            this.bufferize();
        } while (!found);
        result.unblockSuccess(Boolean.TRUE);
    }

    private boolean searchCurrentChars(char endChar, IString string) {
        int r = this.currentChars.remaining();
        for (int i = 0; i < r; ++i) {
            if (this.currentChars.getForward(i) != endChar) continue;
            if (i == 0) {
                this.currentChars.moveForward(1);
            } else {
                this.currentChars.get(string, i);
                this.currentChars.moveForward(1);
            }
            return true;
        }
        this.currentChars.get(string, this.currentChars.remaining());
        return false;
    }

    private class ReadAsyncTask
    extends Task.Cpu<Void, NoException> {
        private char[] buf;
        private int offset;
        private int length;
        private AsyncSupplier<Integer, IOException> readResult;

        private ReadAsyncTask(char[] buf, int offset, int length, AsyncSupplier<Integer, IOException> result) {
            super("BufferedReadableCharacterStream.readAsync", BufferedReadableCharacterStream.this.input.getPriority());
            this.buf = buf;
            this.offset = offset;
            this.length = length;
            this.readResult = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            int done = 0;
            if (BufferedReadableCharacterStream.this.back != -1) {
                this.buf[this.offset++] = (char)BufferedReadableCharacterStream.this.back;
                BufferedReadableCharacterStream.this.back = -1;
                --this.length;
                if (this.length == 0) {
                    this.readResult.unblockSuccess(1);
                    return null;
                }
                done = 1;
            }
            if (BufferedReadableCharacterStream.this.currentChars == null && !this.getNextChars(done, this.readResult)) {
                return null;
            }
            int len = Math.min(this.length, BufferedReadableCharacterStream.this.currentChars.remaining());
            BufferedReadableCharacterStream.this.currentChars.get(this.buf, this.offset, len);
            if (!BufferedReadableCharacterStream.this.currentChars.hasRemaining()) {
                boolean full;
                TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                synchronized (turnArray) {
                    full = BufferedReadableCharacterStream.this.ready.isFull();
                    BufferedReadableCharacterStream.this.pollNextBuffer();
                }
                if (full && !BufferedReadableCharacterStream.this.endReached) {
                    BufferedReadableCharacterStream.this.bufferize();
                }
            }
            this.readResult.unblockSuccess(len + done);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getNextChars(int done, AsyncSupplier<Integer, IOException> result) {
            Async sp;
            boolean full;
            TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
            synchronized (turnArray) {
                full = BufferedReadableCharacterStream.this.ready.isFull();
                BufferedReadableCharacterStream.this.pollNextBuffer();
                sp = BufferedReadableCharacterStream.this.nextReady;
                if (BufferedReadableCharacterStream.this.currentChars == null && BufferedReadableCharacterStream.this.endReached) {
                    if (done > 0) {
                        result.unblockSuccess(done);
                    } else {
                        result.unblockSuccess(-1);
                    }
                    return false;
                }
            }
            if (full && !BufferedReadableCharacterStream.this.endReached) {
                BufferedReadableCharacterStream.this.bufferize();
            }
            if (BufferedReadableCharacterStream.this.currentChars == null) {
                if (sp.forwardIfNotSuccessful(result)) {
                    return false;
                }
                int don = done;
                BufferedReadableCharacterStream.this.readAsync(this.buf, this.offset + done, this.length - done).onDone(nb -> result.unblockSuccess(don + nb), result);
                return false;
            }
            return !sp.forwardIfNotSuccessful(result);
        }
    }

    private class DecodeTask
    extends Task.Cpu<Void, NoException> {
        private AsyncSupplier<Integer, IOException> readTask;
        private ByteArray buf;

        private DecodeTask(AsyncSupplier<Integer, IOException> readTask, ByteArray buf) {
            super("Decode character stream", BufferedReadableCharacterStream.this.input.getPriority());
            this.readTask = readTask;
            this.buf = buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                return null;
            }
            if (this.readTask.isCancelled()) {
                if (BufferedReadableCharacterStream.this.decoder == null) {
                    return null;
                }
                TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                synchronized (turnArray) {
                    BufferedReadableCharacterStream.this.nextReady.cancel(this.readTask.getCancelEvent());
                }
                return null;
            }
            if (this.readTask.hasError()) {
                TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                synchronized (turnArray) {
                    BufferedReadableCharacterStream.this.nextReady.error(this.readTask.getError());
                }
                return null;
            }
            if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                return null;
            }
            try {
                this.decode();
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
            catch (Exception t) {
                if (!BufferedReadableCharacterStream.this.nextReady.isDone()) {
                    TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        BufferedReadableCharacterStream.this.nextReady.error(IO.error(t));
                    }
                }
                LCCore.getApplication().getDefaultLogger().error("Error while buffering", t);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decode() {
            DataBuffer chars;
            boolean end;
            int nb = this.readTask.getResult();
            if (nb < this.buf.remaining()) {
                BufferedReadableCharacterStream.this.input.closeAsync();
                end = true;
            } else {
                end = false;
            }
            if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                return;
            }
            if (nb > 0) {
                this.buf.setPosition(nb);
                this.buf.flip();
                chars = BufferedReadableCharacterStream.this.decoder.decode(this.buf);
            } else {
                chars = null;
            }
            if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                return;
            }
            if (chars != null && !chars.hasRemaining()) {
                chars = null;
            }
            Chars.Readable endChars = end ? BufferedReadableCharacterStream.this.decoder.flush() : null;
            Async sp = null;
            boolean full = false;
            TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
            synchronized (turnArray) {
                if (chars == null && endChars == null) {
                    if (end) {
                        BufferedReadableCharacterStream.this.endReached = true;
                        sp = BufferedReadableCharacterStream.this.nextReady;
                        BufferedReadableCharacterStream.this.nextReady = new Async<boolean>(true);
                    }
                } else {
                    if (chars != null) {
                        if (endChars != null) {
                            if (BufferedReadableCharacterStream.this.ready.getNbAvailableSlots() >= 2) {
                                BufferedReadableCharacterStream.this.ready.addLast(chars);
                                BufferedReadableCharacterStream.this.ready.addLast(endChars);
                            } else {
                                BufferedReadableCharacterStream.this.ready.addLast(new CompositeChars.Readable(new Chars.Readable[]{chars, endChars}));
                            }
                        } else {
                            BufferedReadableCharacterStream.this.ready.addLast(chars);
                        }
                    } else {
                        BufferedReadableCharacterStream.this.ready.addLast(endChars);
                    }
                    full = BufferedReadableCharacterStream.this.ready.isFull();
                    sp = BufferedReadableCharacterStream.this.nextReady;
                    BufferedReadableCharacterStream.this.nextReady = new Async<boolean>(end);
                    BufferedReadableCharacterStream.this.endReached = end;
                }
            }
            if (sp == null) {
                BufferedReadableCharacterStream.this.bufferize();
                return;
            }
            sp.unblock();
            if (!full && !BufferedReadableCharacterStream.this.endReached) {
                BufferedReadableCharacterStream.this.bufferize();
            }
        }
    }
}

