/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.IString;

public class CharacterStreamWritePool {
    private ICharacterStream.Writable stream;
    private IAsync<IOException> lastWrite = new Async<boolean>(true);

    public CharacterStreamWritePool(ICharacterStream.Writable stream) {
        this.stream = stream;
    }

    public IAsync<IOException> write(char c) {
        if (!(this.stream instanceof ICharacterStream.Writable.Buffered)) {
            return this.write(new char[]{c}, 0, 1);
        }
        IAsync<IOException> last = this.lastWrite;
        if (last.isDone()) {
            this.lastWrite = ((ICharacterStream.Writable.Buffered)this.stream).writeAsync(c);
            return this.lastWrite;
        }
        Async<IOException> ours = new Async<IOException>();
        this.lastWrite = ours;
        last.onDone(() -> ((ICharacterStream.Writable.Buffered)this.stream).writeAsync(c).onDone(ours), ours);
        return ours;
    }

    public IAsync<IOException> write(char[] chars) {
        return this.write(chars, 0, chars.length);
    }

    public IAsync<IOException> write(char[] chars, int offset, int length) {
        IAsync<IOException> last = this.lastWrite;
        if (length == 0) {
            return last;
        }
        if (last.isDone()) {
            this.lastWrite = this.stream.writeAsync(chars, offset, length);
            return this.lastWrite;
        }
        Async<IOException> ours = new Async<IOException>();
        this.lastWrite = ours;
        last.onDone(() -> this.stream.writeAsync(chars, offset, length).onDone(ours), ours);
        return ours;
    }

    public IAsync<IOException> write(CharArray chars) {
        return this.write((char[])chars.getArray(), chars.getCurrentArrayOffset(), chars.remaining());
    }

    public IAsync<IOException> write(CharArray[] chars) {
        IAsync<IOException> last = this.lastWrite;
        for (int i = 0; i < chars.length; ++i) {
            last = this.write(chars[i]);
        }
        return last;
    }

    public IAsync<IOException> write(String s) {
        return this.write(s.toCharArray());
    }

    public IAsync<IOException> write(IString s) {
        return this.write(s.asCharBuffers());
    }

    public IAsync<IOException> write(CharSequence s) {
        return this.write(s.toString());
    }

    public IAsync<IOException> flush() {
        return this.lastWrite;
    }
}

