/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.IConcurrentCloseable;

public interface ICharacterStream
extends IConcurrentCloseable<IOException> {
    public byte getPriority();

    public void setPriority(byte var1);

    public String getDescription();

    public Charset getEncoding();

    public static interface Writable
    extends ICharacterStream,
    WriterAsync {
        public void writeSync(char[] var1, int var2, int var3) throws IOException;

        default public void writeSync(char[] c) throws IOException {
            this.writeSync(c, 0, c.length);
        }

        default public void writeSync(String s) throws IOException {
            this.writeSync(s.toCharArray());
        }

        public static interface Buffered
        extends Writable {
            public void writeSync(char var1) throws IOException;

            public IAsync<IOException> writeAsync(char var1);

            public IAsync<IOException> flush();
        }
    }

    public static interface WriterAsync {
        public IAsync<IOException> writeAsync(char[] var1, int var2, int var3);

        default public IAsync<IOException> writeAsync(char[] c) {
            return this.writeAsync(c, 0, c.length);
        }

        default public IAsync<IOException> writeAsync(String s) {
            return this.writeAsync(s.toCharArray());
        }
    }

    public static interface Readable
    extends ICharacterStream {
        public int readSync(char[] var1, int var2, int var3) throws IOException;

        public AsyncSupplier<Integer, IOException> readAsync(char[] var1, int var2, int var3);

        public boolean endReached();

        default public int readFullySync(char[] buf, int offset, int length) throws IOException {
            int done = 0;
            int nb;
            while ((nb = this.readSync(buf, offset, length)) > 0) {
                done += nb;
                if (length == nb) {
                    return done;
                }
                length -= nb;
                offset += nb;
            }
            return done;
        }

        default public AsyncSupplier<Integer, IOException> readFullyAsync(final char[] buf, final int offset, final int length) {
            final MutableInteger done = new MutableInteger(0);
            final AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
            Runnable next = new Runnable(){

                @Override
                public void run() {
                    1 that = this;
                    AsyncSupplier<Integer, IOException> read = this.readAsync(buf, offset + done.get(), length - done.get());
                    read.onDone(() -> {
                        int nb = (Integer)read.getResult();
                        if (nb <= 0) {
                            result.unblockSuccess(done.get());
                            return;
                        }
                        if (done.add(nb) == length) {
                            result.unblockSuccess(done.get());
                            return;
                        }
                        that.run();
                    }, (IAsync<IOException>)result);
                }
            };
            next.run();
            return result;
        }

        public static interface Buffered
        extends Readable {
            public IAsync<IOException> canStartReading();

            public void back(char var1);

            public char read() throws IOException;

            public int readAsync() throws IOException;

            public Chars.Readable readNextBuffer() throws IOException;

            public AsyncSupplier<Chars.Readable, IOException> readNextBufferAsync();

            public boolean readUntil(char var1, IString var2) throws IOException;

            public AsyncSupplier<Boolean, IOException> readUntilAsync(char var1, IString var2);
        }

        public static interface PositionInText
        extends Readable {
            public int getLine();

            public int getPositionInLine();
        }
    }
}

